package pl.islandworld.listeners;

import java.util.HashMap;

import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

import pl.islandworld.Config;
import pl.islandworld.IslandWorld;
import pl.islandworld.entity.SimpleIslandV6;

public class PlayerMoveListener implements Listener
{
	private final IslandWorld plugin;

	private HashMap<String, String> curentPos = new HashMap<String, String>();

	public PlayerMoveListener(IslandWorld iw)
	{
		this.plugin = iw;
	}

	@EventHandler
	public void onPlayerMove(PlayerMoveEvent event)
	{
		if (event.isCancelled())
			return;

		final Player player = event.getPlayer();

		if (plugin.getConfig().getBoolean("flags.move-info", false))
		{
			if (event.getTo().getWorld() != plugin.getIslandWorld())
				return;

			if (event.getFrom().getBlockX() != event.getTo().getBlockX() || event.getFrom().getBlockY() != event.getTo().getBlockY()
					|| event.getFrom().getBlockZ() != event.getTo().getBlockZ())
				checkCoords(player, event.getTo().getBlockX(), event.getTo().getBlockZ());
		}
	}

	@EventHandler
	public void onPlayerTeleport(PlayerTeleportEvent event)
	{
		if (event.isCancelled())
			return;

		if (event.getTo().getWorld() != plugin.getIslandWorld())
			return;

		final Player player = event.getPlayer();

		if (plugin.getConfig().getBoolean("flags.move-info", false))
			checkCoords(player, event.getTo().getBlockX(), event.getTo().getBlockZ());
	}

	private void checkCoords(Player player, int blockX, int blockZ)
	{
		final String plName = player.getName().toLowerCase();
		final String coordHash = String.valueOf(blockX / Config.ISLE_SIZE) + "-" + String.valueOf(blockZ / Config.ISLE_SIZE);
		final SimpleIslandV6 is = plugin.getCoordList().get(coordHash);

		if (is != null && plugin.isInsideIsland(player, is)
				&& (!curentPos.containsKey(plName) || (curentPos.containsKey(plName) && !curentPos.get(plName).equalsIgnoreCase(coordHash))))
		{
			plugin.showMessage(player, ChatColor.AQUA + plugin.getLoc("info-entered").replaceAll("%name%", is.getOwner()));
			curentPos.put(plName, coordHash);
			return;
		}

		if (curentPos.containsKey(plName)
				&& (is == null || (!plugin.isInsideIsland(player, is) || !curentPos.get(plName).equalsIgnoreCase(coordHash))))
		{
			plugin.showMessage(player, ChatColor.AQUA + plugin.getLoc("info-quitted"));
			curentPos.remove(plName);
			return;
		}
	}
}