package net.minecraft.src;
// Decompiled by Jad v1.5.8g. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.kpdus.com/jad.html
// Decompiler options: packimports(3) braces deadcode 

import java.util.*;
import net.minecraft.client.Minecraft;

public class BlockFan extends BlockContainer
{

    public BlockFan(int i, int j)
    {
        super(i, j, Material.rock);
        setTickOnLoad(true);
    }

    public int getBlockTexture(IBlockAccess iblockaccess, int i, int j, int k, int l)
    {
        TileEntityFan tileentityfan = (TileEntityFan)mod_Fanblock.mcInst.theWorld.getBlockTileEntity(i, j, k);
        if(tileentityfan != null)
        {
            if(l == tileentityfan.side)
            {
                return mod_Fanblock.itemindex1;
            }
            else
            {
                return 74;
            }
        }
        return 74;
    }

    public int getBlockTextureFromSideAndMetadata(int i, int j)
    {
        if(i == 3)
        {
            return mod_Fanblock.itemindex1;
        }
        else
        {
            return 74;
        }

    }

    public int tickRate()
    {
        return 1;
    }

    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLiving entityliving)
    {
        if(entityliving instanceof EntityPlayer)
        {
                int l = determineOrientation(world, i, j, k, (EntityPlayer)entityliving);
                TileEntityFan tileentityfan = (TileEntityFan)world.getBlockTileEntity(i, j, k);
                if(tileentityfan != null)
                {
                    tileentityfan.side = l;
                }
        }
    }

    private static int determineOrientation(World world, int i, int j, int k, EntityPlayer entityplayer)
    {
        if(MathHelper.abs((float)entityplayer.posX - (float)i) < 2.0F && MathHelper.abs((float)entityplayer.posZ - (float)k) < 2.0F)
        {
            double d = (entityplayer.posY + 1.8200000000000001D) - (double)entityplayer.yOffset;
            if(d - (double)j > 2D)
            {
                return 1;
            }
            if((double)j - d > 0.0D)
            {
                return 0;
            }
        }
        int l = MathHelper.floor_double((double)((entityplayer.rotationYaw * 4F) / 360F) + 0.5D) & 3;
        if(l == 0)
        {
            return 2;
        }
        if(l == 1)
        {
            return 5;
        }
        if(l == 2)
        {
            return 3;
        }
        return l != 3 ? 0 : 4;
    }

    public void updateTick(World world, int i, int j, int k, Random random)
    {
        int side = 1;
        boolean mode = true;
        TileEntityFan tileentityfan = (TileEntityFan)world.getBlockTileEntity(i, j, k);
        if(tileentityfan != null)
        {
            side = tileentityfan.side;
            mode = tileentityfan.mode;
        }
    	if(!(world.isBlockIndirectlyGettingPowered(i, j, k)) && !(world.isBlockIndirectlyGettingPowered(i, j + 1, k)) && tileentityfan != null)
        {
            int l = world.getBlockMetadata(i, j, k);
            int i1 = 0;
            int j1 = 0;
            int k1 = 0;
            int io = 0;
            int jo = 0;
            int ko = 0;
            int fanBlowRange = tileentityfan.range;
            if(side == 0)
            {
                jo = -1;
                j1 = -1;
                do
                {
                    if(j1 < -fanBlowRange)
                    {
                        j1++;
                        break;
                    }
                    int l1 = world.getBlockId(i, j + j1, k);
                    if(!getIsPassable(l1))
                    {
                        j1++;
                        break;
                    }
                    j1--;
                } while(true);
            } else
            if(side == 1)
            {
                jo = 1;
                j1 = 1;
                do
                {
                    if(j1 > fanBlowRange)
                    {
                        j1--;
                        break;
                    }
                    int i2 = world.getBlockId(i, j + j1, k);
                    if(!getIsPassable(i2))
                    {
                        j1--;
                        break;
                    }
                    j1++;
                } while(true);
            } else
            if(side == 2)
            {
                ko = -1;
                k1 = -1;
                do
                {
                    if(k1 < -fanBlowRange)
                    {
                        k1++;
                        break;
                    }
                    int j2 = world.getBlockId(i, j, k + k1);
                    if(!getIsPassable(j2))
                    {
                        k1++;
                        break;
                    }
                    k1--;
                } while(true);
            } else
            if(side == 3)
            {
                ko = 1;
                k1 = 1;
                do
                {
                    if(k1 > fanBlowRange)
                    {
                        k1--;
                        break;
                    }
                    int k2 = world.getBlockId(i, j, k + k1);
                    if(!getIsPassable(k2))
                    {
                        k1--;
                        break;
                    }
                    k1++;
                } while(true);
            } else
            if(side == 4)
            {
                io = -1;
                i1 = -1;
                do
                {
                    if(i1 < -fanBlowRange)
                    {
                        i1++;
                        break;
                    }
                    int l2 = world.getBlockId(i + i1, j, k);
                    if(!getIsPassable(l2))
                    {
                        i1++;
                        break;
                    }
                    i1--;
                } while(true);
            } else
            if(side == 5)
            {
                io = 1;
                i1 = 1;
                do
                {
                    if(i1 > fanBlowRange)
                    {
                        i1--;
                        break;
                    }
                    int i3 = world.getBlockId(i + i1, j, k);
                    if(!getIsPassable(i3))
                    {
                        i1--;
                        break;
                    }
                    i1++;
                } while(true);
            }
            if(!mode)
            {
                io *= -1;
                jo *= -1;
                ko *= -1;
            }
            AxisAlignedBB axisalignedbb = getCollisionBoundingBoxFromPool(world, i, j, k).addCoord(i1, j1, k1);
            List list = world.getEntitiesWithinAABB(Entity.class, axisalignedbb);
            Iterator iterator = list.iterator();
            do
            {
                if(!iterator.hasNext())
                {
                    break;
                }
                Object obj = iterator.next();
                Entity entity = (Entity)obj;
                if(!(entity instanceof EntityFallingSand) && !(mod_Fanblock.powerstaffloaded && entity instanceof EntityBlockPushPull))
                {
                    double d = (entity.getDistance((double)i + 0.5D, (double)j + 0.5D, (double)k + 0.5D)) - 1; //* (double)Math.abs(i1 + j1 + k1)) / 4D;
                    d = 1 - (d / fanBlowRange);
                    double multiplier = fanBlowRange;
                    multiplier = multiplier > 8 ? 8 : multiplier;
                    double power = 0.070000000000000007D * multiplier;
                    power = power * d;
                    boolean flagIronBoots = false;
                    boolean flagHoverBoots = false;
                    boolean flagGliding = false;
                    if(mod_Fanblock.magicBootsLoaded)
                    {
                        if(mod_MagicBoots.wearingHoverBoots())
                        {
                            flagHoverBoots = true;
                            if(mod_MagicBoots.isGliding)
                            {
                                flagGliding = true;
                            }
                        }
                        else
                        if(mod_MagicBoots.wearingHeavyBoots())
                        {
                            flagIronBoots = true;
                        }
                    }
                    if(mod_Fanblock.umbrellasLoaded)
                    {
                        if(mod_Umbrella.usingUmbrella())
                        {
                            flagHoverBoots = true;
                        }
                    }
                    if(flagHoverBoots && side == 1 && entity instanceof EntityPlayer && mode)
                    {
                        power *= 2;
                        if(flagGliding)
                        {
                            mod_MagicBoots.fanNotify = true;
                        }
                    }
                    if(flagIronBoots && entity instanceof EntityPlayer)
                    {
                    }else
                    {
                        if(side == 1 && mode)
                        {
                            entity.fallDistance = 0F;
                        }
                        entity.addVelocity(power * io, power * jo, power * ko);
                    }
                }
            } while(true);
            if(mod_Fanblock.effectsOn == 1)
            {
                List list2 = mod_Fanblock.getEffectsWithinAABB(axisalignedbb);
                if(list2 != null)
                {
                    Iterator iterator2 = list2.iterator();
                    do
                    {
                        if(!iterator2.hasNext())
                        {
                            break;
                        }
                        Object obj1 = iterator2.next();
                        Entity entity = (Entity)obj1;
                        if(!(entity instanceof EntityFallingSand))
                        {
                            double d = (entity.getDistance((double)i + 0.5D, (double)j + 0.5D, (double)k + 0.5D)) - 1; //* (double)Math.abs(i1 + j1 + k1)) / 4D;
                            d = 1 - (d / fanBlowRange);
                            double multiplier = fanBlowRange;
                            multiplier = multiplier > 8 ? 8 : multiplier;
                            double power = 0.029999999999999999D * multiplier;
                            power = power * d;
                            entity.addVelocity(power * io, power * jo, power * ko);
                        }
                    } while(true);
                }
                if(tileentityfan.mode)
                {
                    for(int ii = 1; ii <= fanBlowRange/4+1; ii++)
                    {
                        ModLoader.getMinecraftInstance().effectRenderer.addEffect(new EntityAirFX(world, (double)i + random.nextDouble(), (double)j + random.nextDouble(), (double)k + random.nextDouble()));
                    }
                }
                else
                {
                    for(int ii = 1; ii <= fanBlowRange/4+1; ii++)
                    {
                        ModLoader.getMinecraftInstance().effectRenderer.addEffect(new EntityAirFX(world, ((double)i + random.nextDouble()) + (i1 * random.nextDouble()), ((double)j + random.nextDouble()) + (j1 * random.nextDouble()), ((double)k + random.nextDouble()) + (k1 * random.nextDouble())));
                    }
                }
            }
        }
    }

    public void randomDisplayTick(World world, int i, int j, int k, Random random)
    {
        world.scheduleBlockUpdate(i, j, k, blockID, tickRate());
    }

    public boolean getIsPassable(int c1)
    {
	if(Block.blocksList[c1] == Block.glass || Block.blocksList[c1] == Block.waterStill || Block.blocksList[c1] == Block.waterMoving ||
           Block.blocksList[c1] == Block.lavaStill || Block.blocksList[c1] == Block.lavaMoving || Block.blocksList[c1] == Block.ice ||
           Block.blocksList[c1] == Block.mobSpawner)
        {
	    return false;
        }
	if(Block.blocksList[c1] != null && Block.blocksList[c1].blockMaterial != Material.air && Block.blocksList[c1].isOpaqueCube())
        {
	    return false;
        }
        return true;
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l)
    {
        if(l > 0 && Block.blocksList[l].canProvidePower())
        {
            boolean flag = world.isBlockIndirectlyGettingPowered(i, j, k) || world.isBlockIndirectlyGettingPowered(i, j + 1, k);
            if(flag)
            {
                world.scheduleBlockUpdate(i, j, k, blockID, tickRate());
            }
        }
    }

    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer)
    {
        if(!entityplayer.isSneaking())
        {
            TileEntityFan tileentityfan = (TileEntityFan)world.getBlockTileEntity(i, j, k);
            ModLoader.OpenGUI(entityplayer, new GuiFanBlock(entityplayer, world, tileentityfan));
            return true;
        }
        return false;
    }

    public TileEntity getBlockEntity()
    {
        return new TileEntityFan();
    }
}
