package net.minecraft.src;

import org.lwjgl.input.Keyboard;
import net.minecraft.client.Minecraft;
import java.io.File;

public class GuiFanBlock extends GuiScreen
{
	public GuiFanBlock(EntityPlayer ientityplayer, World world, TileEntityFan itileentityfan)
	{
		entityplayer = ientityplayer;
		tileentityfan = itileentityfan;
		worldObj = world;
		range = tileentityfan.range;
		mode = tileentityfan.mode;
		mcObj = ModLoader.getMinecraftInstance();
		rangeStr = ((new StringBuilder()).append(range).toString());
	}
	
	public void initGui()
	{
		controlList.clear();
        controlList.add(okbutton = new GuiButton(0, width / 2 - 80, height / 4 + 120, 70, 20, "OK"));
        controlList.add(cancelbutton = new GuiButton(1, width / 2 + 10, height / 4 + 120, 70, 20, "Cancel"));
        controlList.add(modeButton = new GuiButton(2, width / 2 - 50, height / 4 + 10, 100, 20, mode ? "Blow" : "Suck"));
        controlList.add(plusoneButton = new GuiButton(3, width / 2 + 20, height / 4 + 65, 40, 20, "+1"));
        controlList.add(plusfiveButton = new GuiButton(4, width / 2 + 65, height / 4 + 65, 40, 20, "+5"));
        controlList.add(maxButton = new GuiButton(5, width / 2 + 110, height / 4 + 65, 40, 20, "MAX"));
        controlList.add(minusoneButton = new GuiButton(6, width / 2 - 60, height / 4 + 65, 40, 20, "-1"));
        controlList.add(minusfiveButton = new GuiButton(7, width / 2 - 105, height / 4 + 65, 40, 20, "-5"));
        controlList.add(minButton = new GuiButton(8, width / 2 - 150, height / 4 + 65, 40, 20, "MIN"));
	}
	
    public void drawScreen(int i, int j, float f)
	{
        drawDefaultBackground();
        drawStrings();
        super.drawScreen(i, j, f);
	}

	public void drawStrings()
	{
		drawCenteredString(fontRenderer, "Mode:", width / 2, height / 4 - 10, 0xffffff);
        drawCenteredString(fontRenderer, "Range:", width / 2, height / 4 + 45, 0xffffff);
        if(range > 32)
        {
        	range = 32;
        }
        if(range < 1)
        {
        	range = 1;
        }
        rangeStr = ((new StringBuilder()).append(range).toString());
        drawCenteredString(fontRenderer, rangeStr, width / 2, height / 4 + 70, 0xffffff);

	}
	
	protected void saveChanges()
	{
		tileentityfan.range = range;
		tileentityfan.mode = mode;
	}
	
	protected void actionPerformed(GuiButton guibutton)
	{
	    switch(guibutton.id)
        {
            case 0:
				saveChanges();
                mcObj.displayGuiScreen((GuiScreen)null);
                mcObj.setIngameFocus();
                break;
            case 1:
                mcObj.displayGuiScreen((GuiScreen)null);
                mcObj.setIngameFocus();
                break;
			case 2:
				if(mode)
				{
					mode = false;
					modeButton.displayString = "Suck";
					drawStrings();
				}
				else
				{
					mode = true;
					modeButton.displayString = "Blow";
					drawStrings();
				}
				break;
			case 3:
				range += 1;
				drawStrings();
				break;
			case 4:
				range += 5;
				drawStrings();
				break;
			case 5:
				range = 32;
				drawStrings();
				break;
			case 6:
				range -= 1;
				drawStrings();
				break;
			case 7:
				range -= 5;
				drawStrings();
				break;
			case 8:
				range = 1;
				drawStrings();
				break;
			default:
				break;
		}
	}

	protected TileEntityFan tileentityfan;
	protected EntityPlayer entityplayer;
	protected World worldObj;
	private Minecraft mcObj;
	private int range;
	private boolean mode;
	private GuiButton okbutton;
    private GuiButton cancelbutton;
    private GuiButton modeButton;
    private GuiButton plusoneButton;
    private GuiButton plusfiveButton;
    private GuiButton minusoneButton;
    private GuiButton minusfiveButton;
    private GuiButton maxButton;
    private GuiButton minButton;
    private String rangeStr;
	
}