package net.minecraft.src;
import net.minecraft.client.Minecraft;
import java.io.File;

public class TileEntityFan extends TileEntity
{

	public TileEntityFan()
	{
		mode = true;
		range = 1;
		side = 1;
	}

	public void updateEntity()
	{
		worldObj.scheduleBlockUpdate(xCoord, yCoord, zCoord, worldObj.getBlockId(xCoord, yCoord, zCoord), 1);
		super.updateEntity();
	}

	public void readFromNBT(NBTTagCompound nbttagcompound)
	{
		super.readFromNBT(nbttagcompound);
		mode = nbttagcompound.getBoolean("mode");
		side = nbttagcompound.getInteger("side");
		range = nbttagcompound.getInteger("range");
	}
	
	public void writeToNBT(NBTTagCompound nbttagcompound)
	{
        super.writeToNBT(nbttagcompound);
		nbttagcompound.setBoolean("mode", mode);
		nbttagcompound.setInteger("side", side);
		nbttagcompound.setInteger("range", range);
	}

	public int range;
	public int side;
	public boolean mode;

}