package net.minecraft.src;


import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import java.io.IOException;
import java.util.*;
import java.util.Properties;
import java.io.*;
import java.net.URI;
import java.net.URL;
import net.minecraft.client.Minecraft;

public class mod_Fanblock extends BaseMod
{

    public mod_Fanblock()
    {
        ModLoader.RegisterTileEntity(TileEntityFan.class, "Fan Block");
        ModLoader.AddRecipe(new ItemStack(fanblock, 1), new Object[] {
            "X X", "XYX", "XXX", Character.valueOf('X'), Block.planks, Character.valueOf('Y'), Item.redstone
        });
        try
        {
            int test = mod_PowerStaff.itemindex2;
        }
        catch(Throwable t)
        {
            powerstaffloaded = false;
        }

        try
        {
            int test2 = mod_Umbrella.itemindex1;
        }
        catch(Throwable t)
        {
            umbrellasLoaded = false;
        }

        try
        {
            boolean test3 = mod_MagicBoots.isGliding;
        }
        catch(Throwable t)
        {
            magicBootsLoaded = false;
        }
    }

    public static List getEffectsWithinAABB(AxisAlignedBB axisalignedbb)
    {
        if(fxLayers == null)
        {
            try
            {
                if(ModLoader.getMinecraftInstance().effectRenderer != null)
                {
                    fxLayers = (List[]) (ModLoader.getPrivateValue(EffectRenderer.class, ModLoader.getMinecraftInstance().effectRenderer, 1));
                }
            }
            catch(java.lang.SecurityException exception)
            {
                System.out.println("Could not access effect renderer: access denied.");
                exception.printStackTrace();
            }
            catch(java.lang.IllegalArgumentException exception)
            {
                System.out.println("Illegal argument thrown.");
                exception.printStackTrace();
            }
            catch(java.lang.NoSuchFieldException exception)
            {
                System.out.println("No such field thrown.");
                exception.printStackTrace();
            }
            catch(java.lang.NullPointerException exception)
            {
                
            }
        }
        ArrayList arraylist = new ArrayList();
label0:
        for(int i = 0; i < 4; i++)
        {
            Iterator iterator = fxLayers[i].iterator();
            do
            {
                if(!iterator.hasNext())
                {
                    continue label0;
                }
                Object obj = iterator.next();
                Entity entity = (Entity)obj;
                if(axisalignedbb.minX <= entity.posX && axisalignedbb.maxX >= entity.posX && axisalignedbb.minY <= entity.posY && axisalignedbb.maxY >= entity.posY && axisalignedbb.minZ <= entity.posZ && axisalignedbb.maxZ >= entity.posZ)
                {
                    arraylist.add(entity);
                }
            } while(true);
        }

        return arraylist;
    }

    public void load()
    {
        
    }

    public String getVersion()
    {
        return "Airblock 1.0";
    }

    private static void RegisterNames()
    {
         ModLoader.AddName(fanblock, "Fan Block");
    }

    public static void RegisterTextures()
    {
        int itemindex2 = ModLoader.getUniqueSpriteIndex("/terrain.png");
        itemindex1 = ModLoader.getUniqueSpriteIndex("/terrain.png");
        ModLoader.addOverride("/terrain.png", "/imgz/airblock.png", itemindex1);
    }

    private static void RegisterBlocks()
    {
        ModLoader.RegisterBlock(fanblock);
    }

    private static void LoadProperties()
    {
        Properties properties = new Properties();
        try
        {
            if(!propsFile.exists())
            {
                propsFile.getParentFile().mkdirs();
                if(propsFile.createNewFile())
                {
                    CreateProperties();
                } else
                {
                    return;
                }
            }
            if(!propsFile.canRead())
            {
                return;
            }
        }
        catch(Exception exception) { }

        try
        {
            String s = propsFile.getAbsolutePath();
            properties.load(new FileInputStream(s));
            String s1 = properties.getProperty("fanBlockID");
            fanBlockID = Integer.parseInt(s1.trim());
            s1 = properties.getProperty("effectsOn");
            effectsOn = Integer.parseInt(s1.trim());
        }
        catch(Exception exception)
        {
            System.out.println("Error loading properties.");
            exception.printStackTrace();
        }
    }

    public static void CreateProperties()
    {
        try
        {
            FileOutputStream fileoutputstream = new FileOutputStream(propsFile);
            OutputStreamWriter output = new OutputStreamWriter(fileoutputstream, "UTF-8");
            output.write("# Fan block ID"); output.write('\n');
            output.write("# Default: 127"); output.write('\n');
            output.write("fanBlockID=127"); output.write('\n');
            output.write('\n');
            output.write("# Particle effects"); output.write('\n');
            output.write("# Values: 1 = on, 0 = off"); output.write('\n');
            output.write("effectsOn=1"); output.write('\n');
            output.close();
            fileoutputstream.close();
        }
        catch(Exception exception) { }
    }

    public static Block fanblock;
    public static int itemindex1;
    public static int fanBlockID = 127;
    public static int effectsOn = 1;
    public static boolean powerstaffloaded = true;
    public static boolean umbrellasLoaded = true;
    public static boolean magicBootsLoaded = true;
    public static List fxLayers[];
    public static mod_Fanblock instance;
    public static Minecraft mcInst = ModLoader.getMinecraftInstance();
    public static final File propsFile = new File(Minecraft.getMinecraftDir(), "/mods/peronix/Fanblock/Fanblock.properties");

    static 
    {
        RegisterTextures();
	   LoadProperties();
        fanblock = (new BlockFan(fanBlockID, 74)).setHardness(1.5F).setResistance(10F).setStepSound(Block.soundStoneFootstep).setBlockName("fanBlock");
	   RegisterNames();
        RegisterBlocks();
    }
}