package net.minecraft.src;
// Decompiled by Jad v1.5.8g. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.kpdus.com/jad.html
// Decompiler options: packimports(3) braces deadcode 


public class EntityBlockPushPull extends Entity
{

    public EntityBlockPushPull(World world)
    {
        super(world);
        fallTime = 0;
        preventEntitySpawning = true;
        setSize(0.98F, 0.98F);
        yOffset = height / 2.0F;
    }

    public EntityBlockPushPull(World world, double d, double d1, double d2, 
            int i)
    {
        super(world);
        fallTime = 0;
        blockID = i;
        preventEntitySpawning = true;
        setSize(0.98F, 0.98F);
        yOffset = height / 2.0F;
        setPosition(d, d1, d2);
        motionX = 0.0D;
        motionY = 0.0D;
        motionZ = 0.0D;
        prevPosX = d;
        prevPosY = d1;
        prevPosZ = d2;
        field_22110_h = d;
        field_22112_a = d2;
    }

    protected void entityInit()
    {
    }

    public boolean canBeCollidedWith()
    {
        return !isDead;
    }

    public void onUpdate()
    {
        if(blockID == 0)
        {
            setEntityDead();
            return;
        }
        prevPosX = posX;
        prevPosY = posY;
        prevPosZ = posZ;
        fallTime++;
        motionY -= 0.039999999105930328D;
        moveEntity(motionX, motionY, motionZ);
        motionX *= 0.98000001907348633D;
        motionY *= 0.98000001907348633D;
        motionZ *= 0.98000001907348633D;
        int i = MathHelper.floor_double(posX);
        int j = MathHelper.floor_double(posY);
        int k = MathHelper.floor_double(posZ);
        if(worldObj.getBlockId(i, j, k) == blockID)
        {
            worldObj.setBlockWithNotify(i, j, k, 0);
        }
        if(onGround && Math.abs(motionX) < 0.01D && Math.abs(motionZ) < 0.01D)
        {
            motionX *= 0.69999998807907104D;
            motionZ *= 0.69999998807907104D;
            motionY *= -0.5D;
            setEntityDead();
            if((!worldObj.canBlockBePlacedAt(blockID, i, j, k, true, 1) || !worldObj.setBlockAndMetadataWithNotify(i, j, k, blockID, field_22111_h)) && !worldObj.multiplayerWorld)
            {
                dropItem(blockID, 1);
            }
        } else
        if(fallTime > 100 && !worldObj.multiplayerWorld)
        {
            dropItem(blockID, 1);
            setEntityDead();
        }
        if(Math.abs(posX - field_22110_h) >= 1.0D)
        {
            motionX = 0.0D;
            posX = Math.floor(posX) + 0.5D;
        }
        if(Math.abs(posZ - field_22112_a) >= 1.0D)
        {
            motionZ = 0.0D;
            posZ = Math.floor(posZ) + 0.5D;
        }
    }

    protected void writeEntityToNBT(NBTTagCompound nbttagcompound)
    {
        nbttagcompound.setByte("Tile", (byte)blockID);
        nbttagcompound.setInteger("EntityID", entityId);
    }

    protected void readEntityFromNBT(NBTTagCompound nbttagcompound)
    {
        blockID = nbttagcompound.getByte("Tile") & 0xff;
        if(nbttagcompound.hasKey("EntityID"))
        {
            entityId = nbttagcompound.getInteger("EntityID");
        }
    }

    public float getShadowSize()
    {
        return 0.0F;
    }

    public World func_465_i()
    {
        return worldObj;
    }

    public int blockID;
    public int field_22111_h;
    public int fallTime;
    public double field_22110_h;
    public double field_22112_a;
}
