package net.minecraft.src;

import java.util.Random;
import java.util.Map;
import org.lwjgl.opengl.GL11;
import net.minecraft.client.Minecraft;
import java.util.Properties;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;


public class mod_PowerStaff extends BaseMod
{

    public mod_PowerStaff()
    {
        ModLoader.AddRecipe(new ItemStack(powerstaff, 1), new Object[] {
            "IDI", "IRI", " I ", Character.valueOf('D'), Item.diamond, Character.valueOf('R'), Item.redstone, Character.valueOf('I'), Item.ingotIron
        });
    }

    public void load()
    {
        
    }

    public String getVersion()
    {
        return "PowerStaff 1.0";
    }

    public void AddRenderer(Map map)
    {
        map.put(EntityBlockPushPull.class, new RenderBlockPushPull());
    }

    public void AddRecipes(CraftingManager recipes)
    {
    }

    private static void RegisterNames()
    {
         ModLoader.AddName(powerstaff, "Power Staff");
    }

    public static void renderBlockFallingSand(Block block, World world, int i, int j, int k, int l, RenderBlocks renderblocks)
    {
        float f = 0.5F;
        float f1 = 1.0F;
        float f2 = 0.8F;
        float f3 = 0.6F;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        float f4 = block.getBlockBrightness(world, i, j, k);
        float f5 = block.getBlockBrightness(world, i, j - 1, k);
        if(f5 < f4)
        {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f * f5, f * f5, f * f5);
        renderblocks.renderBottomFace(block, -0.5D, -0.5D, -0.5D, block.getBlockTextureFromSideAndMetadata(0, l));
        f5 = block.getBlockBrightness(world, i, j + 1, k);
        if(f5 < f4)
        {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f1 * f5, f1 * f5, f1 * f5);
        renderblocks.renderTopFace(block, -0.5D, -0.5D, -0.5D, block.getBlockTextureFromSideAndMetadata(1, l));
        f5 = block.getBlockBrightness(world, i, j, k - 1);
        if(f5 < f4)
        {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f2 * f5, f2 * f5, f2 * f5);
        renderblocks.renderEastFace(block, -0.5D, -0.5D, -0.5D, block.getBlockTextureFromSideAndMetadata(2, l));
        f5 = block.getBlockBrightness(world, i, j, k + 1);
        if(f5 < f4)
        {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f2 * f5, f2 * f5, f2 * f5);
        renderblocks.renderWestFace(block, -0.5D, -0.5D, -0.5D, block.getBlockTextureFromSideAndMetadata(3, l));
        f5 = block.getBlockBrightness(world, i - 1, j, k);
        if(f5 < f4)
        {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f3 * f5, f3 * f5, f3 * f5);
        renderblocks.renderNorthFace(block, -0.5D, -0.5D, -0.5D, block.getBlockTextureFromSideAndMetadata(4, l));
        f5 = block.getBlockBrightness(world, i + 1, j, k);
        if(f5 < f4)
        {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f3 * f5, f3 * f5, f3 * f5);
        renderblocks.renderSouthFace(block, -0.5D, -0.5D, -0.5D, block.getBlockTextureFromSideAndMetadata(5, l));
        tessellator.draw();
    }

    private static void LoadProperties()
    {
        Properties properties = new Properties();
        try
        {
            String s = (mod_PowerStaff.class).getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            s = s.substring(0, s.lastIndexOf('/') + 1);
            s = (new StringBuilder()).append(s).append("mod_PowerStaff.properties").toString();
            properties.load(new FileInputStream(s));
            String s1 = properties.getProperty("powerstaffID");
            powerstaffID = Integer.parseInt(s1.trim());
        }
        catch(Exception exception)
        {
            System.out.println("Error loading properties.");
            exception.printStackTrace();
        }
    }

    public static void RegisterTextures()
    {
        itemindex2 = ModLoader.getUniqueSpriteIndex("/gui/items.png");
        ModLoader.addOverride("/gui/items.png", "/imgz/staffpush.png", itemindex2);
        itemindex3 = ModLoader.getUniqueSpriteIndex("/gui/items.png");
        ModLoader.addOverride("/gui/items.png", "/imgz/staffpull.png", itemindex3);
    }
    public static Item powerstaff;
    public static int itemindex2;
    public static int itemindex3;
    public static Minecraft mcInst = ModLoader.getMinecraftInstance();
    public static int powerstaffID = 1112;

    static 
    {
        LoadProperties();
        RegisterTextures();
	powerstaff = (new ItemPowerStaff(powerstaffID)).setItemName("powerStaff");
	RegisterNames();
    }
}