package net.minecraft.src;
// Decompiled by Jad v1.5.8g. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.kpdus.com/jad.html
// Decompiler options: packimports(3) braces deadcode 

import java.util.*;
import net.minecraft.client.Minecraft;
import java.io.*;

public class BlockSensor extends BlockContainer implements net.minecraft.src.forge.ITextureProvider
{

    public BlockSensor(int i, int j)
    {
        super(i, j, Material.rock);
        setTickOnLoad(true);
    }

    public String getTextureFile()
    {
        return "/imgz/sensors.png";
    }

    public boolean isBlockNormalCube(World world, int i, int j, int k) {
        return false;
    }

    public int getBlockTexture(IBlockAccess iblockaccess, int i, int j, int k, int l)
    {
        TileEntitySensor tileentitysensor = (TileEntitySensor)mod_Sensor.mcInst.theWorld.getBlockTileEntity(i, j, k);
        if(tileentitysensor != null)
        {
            if(l == tileentitysensor.side)
            {
                switch(mod_Sensor.mcInst.theWorld.getBlockMetadata(i, j, k))
                {
                    case 0:
                        if(tileentitysensor.activated)
                        {
                            return 4;
                        }
                        return 0;
                    case 1:
                        if(tileentitysensor.activated)
                        {
                            return 5;
                        }
                        return 1;
                    case 2:
                        if(tileentitysensor.activated)
                        {
                            return 6;
                        }
                        return 2;
                    case 3:
                        if(tileentitysensor.activated)
                        {
                            return 7;
                        }
                        return 3;
                }
            }
            else
            {
                switch(mod_Sensor.mcInst.theWorld.getBlockMetadata(i, j, k))
                {
                    case 0:
                        return 8;
                    case 1:
                        return 9;
                    case 2:
                        return 10;
                    case 3:
                        return 11;
                } 
            }
        }
        return 1;
    }

    public int getBlockTextureFromSideAndMetadata(int i, int j)
    {
        switch(j)
        {
            case 0:
                if(i == 3)
                {
                    return 0;
                }else
                {
                    return 8;
                }
            case 1:
                if(i == 3)
                {
                    return 1;
                }else
                {
                    return 9;
                }
            case 2:
                if(i == 3)
                {
                    return 2;
                }else
                {
                    return 10;
                }
            case 3:
                if(i == 3)
                {
                    return 3;
                }else
                {
                    return 11;
                }
        }
        return 1;
    }

    public int tickRate()
    {
        return 1;
    }

    public void randomDisplayTick(World world, int i, int j, int k, Random random)
    {
        world.scheduleBlockUpdate(i, j, k, blockID, tickRate());
    }

    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLiving entityliving)
    {
        if(entityliving instanceof EntityPlayer)
        {
                int l = determineOrientation(world, i, j, k, (EntityPlayer)entityliving);
                TileEntitySensor tileentitysensor = (TileEntitySensor)mod_Sensor.mcInst.theWorld.getBlockTileEntity(i, j, k);
                if(tileentitysensor != null)
                {
                    tileentitysensor.side = l;
                }
        }
    }

    private static int determineOrientation(World world, int i, int j, int k, EntityPlayer entityplayer)
    {
        if(MathHelper.abs((float)entityplayer.posX - (float)i) < 2.0F && MathHelper.abs((float)entityplayer.posZ - (float)k) < 2.0F)
        {
            double d = (entityplayer.posY + 1.8200000000000001D) - (double)entityplayer.yOffset;
            if(d - (double)j > 2D)
            {
                return 1;
            }
            if((double)j - d > 0.0D)
            {
                return 0;
            }
        }
        int l = MathHelper.floor_double((double)((entityplayer.rotationYaw * 4F) / 360F) + 0.5D) & 3;
        if(l == 0)
        {
            return 2;
        }
        if(l == 1)
        {
            return 5;
        }
        if(l == 2)
        {
            return 3;
        }
        return l != 3 ? 0 : 4;
    }

    public void updateTick(World world, int i, int j, int k, Random random)
    {
            int side = 0;
            TileEntitySensor tileentitysensor = (TileEntitySensor)world.getBlockTileEntity(i, j, k);
            if(tileentitysensor != null)
            {
                side = tileentitysensor.side;
            }
            int i1 = 0;
            int j1 = 0;
            int k1 = 0;
            if(side == 0)
            {
                j1 = -1;
                do
                {
                    if(j1 < -15)
                    {
                        break;
                    }
                    int l1 = world.getBlockId(i, j + j1, k);
                    if(isTraversable(l1))
                    {
                        j1++;
                        break;
                    }
                    j1--;
                } while(true);
            } else
            if(side == 1)
            {
                j1 = 1;
                do
                {
                    if(j1 > 15)
                    {
                        break;
                    }
                    int i2 = world.getBlockId(i, j + j1, k);
                    if(isTraversable(i2))
                    {
                        j1--;
                        break;
                    }
                    j1++;
                } while(true);
            } else
            if(side == 2)
            {
                k1 = -1;
                do
                {
                    if(k1 < -15)
                    {
                        break;
                    }
                    int j2 = world.getBlockId(i, j, k + k1);
                    if(isTraversable(j2))
                    {
                        k1++;
                        break;
                    }
                    k1--;
                } while(true);
            } else
            if(side == 3)
            {
                k1 = 1;
                do
                {
                    if(k1 > 15)
                    {
                        break;
                    }
                    int k2 = world.getBlockId(i, j, k + k1);
                    if(isTraversable(k2))
                    {
                        k1--;
                        break;
                    }
                    k1++;
                } while(true);
            } else
            if(side == 4)
            {
                i1 = -1;
                do
                {
                    if(i1 < -15)
                    {
                        break;
                    }
                    int l2 = world.getBlockId(i + i1, j, k);
                    if(isTraversable(l2))
                    {
                        i1++;
                        break;
                    }
                    i1--;
                } while(true);
            } else
            if(side == 5)
            {
                i1 = 1;
                do
                {
                    if(i1 > 15)
                    {
                        break;
                    }
                    int i3 = world.getBlockId(i + i1, j, k);
                    if(isTraversable(i3))
                    {
                        i1--;
                        break;
                    }
                    i1++;
                } while(true);
            }
            AxisAlignedBB axisalignedbb = getCollisionBoundingBoxFromPool(world, i, j, k).addCoord(i1, j1, k1);
            int meta = world.getBlockMetadata(i,j,k);
            Class triggerType = Entity.class;
            switch(meta)
            {
                case 0:
                    triggerType = EntityLiving.class;
                    break;
                case 1:
                    triggerType = EntityPlayer.class;
                    break;
                case 2:
                    triggerType = Entity.class;
                    break;
                case 3:
                    triggerType = EntityMob.class;
            }
            List list = world.getEntitiesWithinAABB(triggerType, axisalignedbb);
            if(tileentitysensor != null)
            {
                if(list.isEmpty() && tileentitysensor.activated)
                {
                    turnOff(world, i, j, k);
                }else
                if(!list.isEmpty() && !tileentitysensor.activated){
                    turnOn(world, i, j, k);
                }
            }
    }

    public boolean isTraversable(int c1)
    {
	if(Block.blocksList[c1] == Block.lavaStill || Block.blocksList[c1] == Block.lavaMoving ||
           Block.blocksList[c1] == Block.mobSpawner || (Block.blocksList[c1] != null && Block.blocksList[c1].blockID == mod_Sensor.sensorID))
        {
	    return true;
        }
	if(Block.blocksList[c1] != null && Block.blocksList[c1].blockMaterial != Material.air && Block.blocksList[c1].isOpaqueCube())
        {
	    return true;
        }
        return false;
    }

    public void turnOn(World world, int i, int j, int k)
    {
        TileEntitySensor tileentitysensor = (TileEntitySensor)world.getBlockTileEntity(i, j, k);
        if(tileentitysensor != null)
        {
            tileentitysensor.activated = true;
        }
        world.notifyBlocksOfNeighborChange(i, j, k, blockID);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, blockID);
        world.markBlocksDirty(i, j, k, i, j, k);
    }

    public void turnOff(World world, int i, int j, int k)
    {
        TileEntitySensor tileentitysensor = (TileEntitySensor)world.getBlockTileEntity(i, j, k);
        if(tileentitysensor != null)
        {
            tileentitysensor.activated = false;
        }
        world.notifyBlocksOfNeighborChange(i, j, k, blockID);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, blockID);
        world.markBlocksDirty(i, j, k, i, j, k);
    }

    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l)
    {
        TileEntitySensor tileentitysensor = (TileEntitySensor)mod_Sensor.mcInst.theWorld.getBlockTileEntity(i, j, k);
        if(tileentitysensor != null)
        {
            return tileentitysensor.activated;
        }
        return false;
    }

    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l)
    {
        TileEntitySensor tileentitysensor = (TileEntitySensor)world.getBlockTileEntity(i, j, k);
        if(tileentitysensor != null)
        {
            return (tileentitysensor.activated && l == 1);
        }
        return false;
    }

    public void onBlockRemoval(World world, int i, int j, int k)
    {
        TileEntitySensor tileentitysensor = (TileEntitySensor)world.getBlockTileEntity(i, j, k);
        if(tileentitysensor != null)
        {
            if(tileentitysensor.activated == true)
            {
                world.notifyBlocksOfNeighborChange(i, j, k, blockID);
                world.notifyBlocksOfNeighborChange(i, j - 1, k, blockID);
            }
        }
        super.onBlockRemoval(world, i, j, k);
    }

    public boolean canProvidePower()
    {
        return true;
    }

    protected int damageDropped(int i)
    {
        return i;
    }

    public TileEntity getBlockEntity()
    {
        return new TileEntitySensor();
    }

    public int getMobilityFlag()
    {
        return 1;
    }

}
