package net.minecraft.src;
import net.minecraft.client.Minecraft;
import java.io.File;

public class TileEntitySensor extends TileEntity
{
	public TileEntitySensor()
	{
	    side = 0;
	    activated = false;
	}
	public void updateEntity()
	{
		worldObj.scheduleBlockUpdate(xCoord, yCoord, zCoord, worldObj.getBlockId(xCoord, yCoord, zCoord), 1);
		super.updateEntity();
	}
	
	public void readFromNBT(NBTTagCompound nbttagcompound)
	{
		super.readFromNBT(nbttagcompound);
		activated = nbttagcompound.getBoolean("activated");
		side = nbttagcompound.getInteger("side");
	}
	
	public void writeToNBT(NBTTagCompound nbttagcompound)
	{
        super.writeToNBT(nbttagcompound);
		nbttagcompound.setBoolean("activated", activated);
		nbttagcompound.setInteger("side", side);
	}
	
	public int side;
	public boolean activated;
}