package net.minecraft.src;

import net.minecraft.client.Minecraft;
import java.util.Random;
import java.util.Map;
import java.util.Properties;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.io.*;

public class mod_Sensor extends BaseMod
{

    public mod_Sensor()
    {
        ModLoader.RegisterTileEntity(TileEntitySensor.class, "Sensor Block");
        ModLoader.AddRecipe(new ItemStack(sensor, 1, 0), new Object[] {
            "IGI", "XYX", "IXI", Character.valueOf('X'), Block.stone, Character.valueOf('Y'), Item.redstone, Character.valueOf('G'), Block.glass, Character.valueOf('I'), Item.ingotIron
        });
        ModLoader.AddRecipe(new ItemStack(sensor, 1, 1), new Object[] {
            "XGX", "XYX", "XXX", Character.valueOf('X'), Item.ingotIron, Character.valueOf('Y'), Item.redstone, Character.valueOf('G'), Block.glass
        });
        ModLoader.AddRecipe(new ItemStack(sensor, 1, 2), new Object[] {
            "IGI", "XYX", "IXI", Character.valueOf('X'), Block.planks, Character.valueOf('Y'), Item.redstone, Character.valueOf('G'), Block.glass, Character.valueOf('I'), Item.ingotIron
        });
        ModLoader.AddRecipe(new ItemStack(sensor, 1, 3), new Object[] {
            "IGI", "XYX", "IXI", Character.valueOf('X'), Block.netherrack, Character.valueOf('Y'), Item.redstone, Character.valueOf('G'), Block.glass, Character.valueOf('I'), Item.ingotIron
        });
    }

    public void load()
    {
        
    }

    public String getVersion()
    {
        return "Sensors 1.0";
    }

    private static void RegisterNames()
    {
         ModLoader.AddName(new ItemStack(sensor, 1, 0), "Stone Sensor");
         ModLoader.AddName(new ItemStack(sensor, 1, 1), "Iron Sensor");
         ModLoader.AddName(new ItemStack(sensor, 1, 2), "Wood Sensor");
         ModLoader.AddName(new ItemStack(sensor, 1, 3), "Nether Sensor");
    }

    private static void RegisterBlocks()
    {
        ModLoader.RegisterBlock(sensor, ItemSensor.class);
    }

    private static void LoadProperties()
    {
        Properties properties = new Properties();
        try
        {
            if(!propsFile.exists())
            {
                propsFile.getParentFile().mkdirs();
                if(propsFile.createNewFile())
                {
                    CreateProperties();
                } else
                {
                    return;
                }
            }
            if(!propsFile.canRead())
            {
                return;
            }
        }
        catch(Exception exception) { }

        try
        {
            String s = propsFile.getAbsolutePath();
            properties.load(new FileInputStream(s));
            String s1 = properties.getProperty("sensorID");
            sensorID = Integer.parseInt(s1.trim());
        }
        catch(Exception exception)
        {
            System.out.println("Error loading properties.");
            exception.printStackTrace();
        }
    }

    public static void CreateProperties()
    {
        //Properties properties = new Properties();
        try
        {
            //properties.put("speakerID", "117");
            FileOutputStream fileoutputstream = new FileOutputStream(propsFile);
            //properties.store(fileoutputstream, "");
            OutputStreamWriter output = new OutputStreamWriter(fileoutputstream, "UTF-8");
            output.write("# Sensor block ID"); output.write('\n');
            output.write("# Default: 124"); output.write('\n');
            output.write("sensorID=124"); output.write('\n');
            output.close();
            fileoutputstream.close();
        }
        catch(Exception exception) { }
    }

    public static Block sensor;
    public static int sensorID = 124;
    public static Minecraft mcInst = ModLoader.getMinecraftInstance();
    public static final File propsFile = new File(Minecraft.getMinecraftDir(), "/mods/peronix/Sensor/Sensor.properties");

    static 
    {
	    LoadProperties();
        sensor = (new BlockSensor(sensorID, 74)).setHardness(0.5F).setResistance(10F).setStepSound(Block.soundStoneFootstep).setBlockName("sensor");
        RegisterBlocks();
	    RegisterNames();
    }
}