package net.minecraft.src;

public class BlockSpeaker extends BlockContainer
{

	public BlockSpeaker(int i, int j)
	{
		super(i, j, Material.wood);
	}

	public int getBlockTextureFromSide(int i)
    {
        return i != 1 ? blockIndexInTexture : mod_SpeakerBlock.itemindex1;
    }
	
	public void onNeighborBlockChange(World world, int i, int j, int k, int l)
    {
        if(l > 0 && Block.blocksList[l].canProvidePower())
        {
            boolean flag = world.isBlockGettingPowered(i, j, k);
            TileEntitySpeaker tileentityspeaker = (TileEntitySpeaker)world.getBlockTileEntity(i, j, k);
            if(tileentityspeaker.previousRedstoneState != flag)
            {
                if(flag)
                {
                    tileentityspeaker.triggerSpeaker(world, i, j, k);
					tileentityspeaker.isPowered = true;
                }
				else
				{
					tileentityspeaker.isPowered = false;
					if(!tileentityspeaker.soundContinues)
					{
						tileentityspeaker.stopSpeaker(world, i, j, k);
					}
				}
                tileentityspeaker.previousRedstoneState = flag;
            }
        }
    }
	
	public void onBlockRemoval(World world, int i, int j, int k)
    {
		TileEntitySpeaker tileentityspeaker = (TileEntitySpeaker)world.getBlockTileEntity(i, j, k);
		tileentityspeaker.stopSpeaker(world, i, j, k);
		super.onBlockRemoval(world, i, j, k);
    }
	
	public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer)
    {
    	if(!entityplayer.isSneaking())
    	{
			TileEntitySpeaker tileentityspeaker = (TileEntitySpeaker)world.getBlockTileEntity(i, j, k);
			ModLoader.OpenGUI(entityplayer, new GuiSpeakerBlock(entityplayer, world, tileentityspeaker));
			return true;
		}
		return false;
	}
	
	public TileEntity getBlockEntity()
    {
        return new TileEntitySpeaker();
    }
}