package net.minecraft.src;

import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class GuiSliderSpeaker extends GuiButton
{
	public GuiSliderSpeaker(int i, int j, int k, TileEntitySpeaker itileentityspeaker, String s)
	{
		super(i, j, k, 150, 20, s);
		sliderValue = 1.0F;
		dragging = false;
		sliderValue = itileentityspeaker.getVolume();
		tileentityspeaker = itileentityspeaker;
		displayString = (new StringBuilder("Volume: ").append((int)(sliderValue * 100F)).append("%").toString());
	}

	protected int getHoverState(boolean flag)
	{
		return 0;
	}

	protected void mouseDragged(Minecraft minecraft, int i, int j)
	{
		if(!drawButton)
		{
			return;
		}
		if(dragging)
		{
			sliderValue = (float)(i - (xPosition + 4)) / (float)(width - 8);
			if(sliderValue < 0.0F)
			{
				sliderValue = 0.0F;
			}
			if(sliderValue > 1.0F)
			{
				sliderValue = 1.0F;
			}
			displayString = (new StringBuilder("Volume: ").append((int)(sliderValue * 100F)).append("%").toString());
			tileentityspeaker.setVolume(sliderValue);
		}
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		drawTexturedModalRect(xPosition + (int)(sliderValue * (float)(width - 8)), yPosition, 0, 66, 4, 20);
		drawTexturedModalRect(xPosition + (int)(sliderValue * (float)(width - 8)) + 4, yPosition, 196, 66, 4, 20);
	}
	
	public boolean mousePressed(Minecraft minecraft, int i, int j)
	{
		if(super.mousePressed(minecraft, i, j))
		{
            sliderValue = (float)(i - (xPosition + 4)) / (float)(width - 8);
            if(sliderValue < 0.0F)
            {
                sliderValue = 0.0F;
            }
            if(sliderValue > 1.0F)
            {
                sliderValue = 1.0F;
            }
			displayString = (new StringBuilder("Volume: ").append((int)(sliderValue * 100F)).append("%").toString());
			tileentityspeaker.setVolume(sliderValue);
            dragging = true;
            return true;
		}else
		{
			return false;
		}
	}
	
	public void mouseReleased(int i, int j)
	{
		dragging = false;
	}
	
	public float sliderValue;
	public boolean dragging;
	public TileEntitySpeaker tileentityspeaker;
}