package net.minecraft.src;

import org.lwjgl.input.Keyboard;
import net.minecraft.client.Minecraft;
import java.io.File;

public class GuiSpeakerBlock extends GuiScreen
{
	public GuiSpeakerBlock(EntityPlayer ientityplayer, World world, TileEntitySpeaker itileentityspeaker)
	{
		entityplayer = ientityplayer;
		tileentityspeaker = itileentityspeaker;
		worldObj = world;
		loops = tileentityspeaker.soundLoops;
		continues = tileentityspeaker.soundContinues;
		fileinputstring = tileentityspeaker.getSound();
		mcObj = ModLoader.getMinecraftInstance();
		prevVolume = tileentityspeaker.getVolume();
		pathMode = tileentityspeaker.pathMode;
		path = tileentityspeaker.path;
	}
	
	public void initGui()
	{
		fileinput = new GuiTextField(this, fontRenderer, width / 2 - 110, 60, 265, 20, "");
		fileinput.isFocused = true;
		fileinput.setText(fileinputstring);
		controlList.clear();
        controlList.add(okbutton = new GuiButton(0, width / 2 - 80, height / 4 + 120, 70, 20, "OK"));
        controlList.add(cancelbutton = new GuiButton(1, width / 2 + 10, height / 4 + 120, 70, 20, "Cancel"));
        controlList.add(loopButton = new GuiButton(2, width / 2 - 110, height / 4 + 40, 100, 20, loops ? "Loops: YES" : "Loops: NO"));
        controlList.add(continueButton = new GuiButton(3, width / 2 + 10, height / 4 + 40, 100, 20, continues ? "Finishes: YES" : "Finishes: NO"));
		controlList.add(volumeSlider = new GuiSliderSpeaker(4, width / 2 - 75, height / 4 + 80, tileentityspeaker, ""));
		controlList.add(pathButton = new GuiButton(5, width / 2 - 170, 60, 50, 20, "Manual"));
		switch(pathMode)
		{
			case 1:
				pathButton.displayString = "Default";
				break;
			case 2:
				pathButton.displayString = "User";
				break;
			case 3:
				pathButton.displayString = "World";
				break;
			case 4:
				pathButton.displayString = "Manual";
				break;
			default:
				pathButton.displayString = "Default";
				pathMode = 1;
		}
		Keyboard.enableRepeatEvents(true);
	}
	
    public void drawScreen(int i, int j, float f)
	{
        drawDefaultBackground();
        drawCenteredString(fontRenderer, "File Name:", width / 2 - 70, 40, 0xffffff);
        drawCenteredString(fontRenderer, "Path:", width / 2 - 145, 40, 0xffffff);
        //drawCenteredString(fontRenderer, "Loops:", width / 2 - 60, height / 4 + 60, 0xffffff);
        //drawCenteredString(fontRenderer, "Sound Finishes:", width / 2 + 60, height / 4 + 60, 0xffffff);
        fileinput.drawTextBox();
        super.drawScreen(i, j, f);
	}
	
	protected void keyTyped(char c, int i)
    {
		if(fileinput.isFocused)
		{
			fileinput.textboxKeyTyped(c, i);
		}
    }
	
	protected void saveChanges()
	{
		fileinputstring = fileinput.getText();
		tileentityspeaker.setSound(fileinputstring);
		tileentityspeaker.soundLoops = loops;
		tileentityspeaker.soundContinues = continues;
		tileentityspeaker.pathMode = pathMode;
		tileentityspeaker.path = path;
	}
	
	protected void actionPerformed(GuiButton guibutton)
	{
	    switch(guibutton.id)
        {
            case 0:
				saveChanges();
				Keyboard.enableRepeatEvents(false);
                mcObj.displayGuiScreen((GuiScreen)null);
                mcObj.setIngameFocus();
                break;
            case 1:
            	tileentityspeaker.setVolume(prevVolume);
                Keyboard.enableRepeatEvents(false);
                mcObj.displayGuiScreen((GuiScreen)null);
                mcObj.setIngameFocus();
                break;
			case 2:
				if(loops)
				{
					loops = false;
					loopButton.displayString = "Loops: NO";
				}
				else
				{
					loops = true;
					loopButton.displayString = "Loops: YES";
				}
				break;
			case 3:
				if(continues)
				{
					continues = false;
					continueButton.displayString = "Finishes: NO";
				}
				else
				{
					continues = true;
					continueButton.displayString = "Finishes: YES";
				}
				break;
			case 5:
				pathMode++;
				pathMode = pathMode > 4 ? 1 : pathMode;
				switch(pathMode)
				{
					case 1:
						File soundsdir = new File(Minecraft.getMinecraftDir(), mod_SpeakerBlock.soundDir);
						path = (new StringBuilder()).append(soundsdir.getAbsolutePath()).append("/").toString();
						pathButton.displayString = "Default";
						break;
					case 2:
						path = mod_SpeakerBlock.userDir;
						pathButton.displayString = "User";
						break;
					case 3:
						File worlddir = mod_SpeakerBlock.getWorldDir();
						path = (new StringBuilder()).append(worlddir.getAbsolutePath()).append("/").toString();
						pathButton.displayString = "World";
						break;
					case 4:
						path = "";
						pathButton.displayString = "Manual";
						break;
					default:
						break;
				}
				break;
			default:
				break;
		}
	}

	protected TileEntitySpeaker tileentityspeaker;
	protected EntityPlayer entityplayer;
	protected World worldObj;
	private Minecraft mcObj;
	private boolean loops;
	private boolean continues;
	private GuiTextField fileinput;
	private GuiSliderSpeaker volumeSlider;
	private String fileinputstring;
	private GuiButton okbutton;
    private GuiButton cancelbutton;
    private GuiButton loopButton;
    private GuiButton continueButton;
    private GuiButton pathButton;
    private float prevVolume;
    private int pathMode;
    private String path;
	
}