package net.minecraft.src;
import net.minecraft.client.Minecraft;
import java.io.File;

public class TileEntitySpeaker extends TileEntity
{
	public TileEntitySpeaker()
	{
	    previousRedstoneState = false;
		isPowered = false;
		soundLoops = false;
		soundContinues = false;
		loopedMusic = true;
		soundfilename = "";
		volume = 1.0F;
		pathMode = 1;
		File soundsdir = new File(Minecraft.getMinecraftDir(), mod_SpeakerBlock.soundDir);
		path = (new StringBuilder()).append(soundsdir.getAbsolutePath()).append("/").toString();
	}
	
	public void triggerSpeaker(World world, int i, int j, int k)
	{
		mod_SpeakerBlock.playBlock(soundfilename, path, (float) i, (float) j, (float) k, 3F, volume);
		iLoc = i;
		jLoc = j;
		kLoc = k;
	}
	
	public void stopSpeaker(World world, int i, int j, int k)
	{
		mod_SpeakerBlock.stopPlaying((float) i, (float) j, (float) k);
	}
	
	public void updateEntity()
	{
		boolean playingFlag = false;
		if(mod_SpeakerBlock.isPlaying((float) iLoc, (float) jLoc, (float) kLoc))
		{
			loopedMusic = false;
			playingFlag = true;
		}
			
		if(soundLoops && isPowered && !loopedMusic && !playingFlag)
		{
			mod_SpeakerBlock.playBlock(soundfilename, path, (float) iLoc, (float) jLoc, (float) kLoc, 3F, volume);
			loopedMusic = true;
		}
		
		if(options == null)
		{
			options = ModLoader.getMinecraftInstance().gameSettings;
			masterVolume = options.soundVolume;
		}
		
		if(masterVolume != options.soundVolume)
		{
			masterVolume = options.soundVolume;
			mod_SpeakerBlock.setVolume((float) iLoc, (float) jLoc, (float) kLoc, volume);
		}
		
		super.updateEntity();
	}
	
	public void setSound(String filename)
	{
		soundfilename = filename;
	}
	
	public String getSound()
	{
		return soundfilename;
	}
	
	public void setVolume(float vol)
	{
		volume = vol;
		mod_SpeakerBlock.setVolume((float) iLoc, (float) jLoc, (float) kLoc, volume);
	}
	
	public float getVolume()
	{
		return volume;
	}
	
	public void readFromNBT(NBTTagCompound nbttagcompound)
	{
		super.readFromNBT(nbttagcompound);
		soundLoops = nbttagcompound.getBoolean("soundLoops");
		soundContinues = nbttagcompound.getBoolean("soundContinues");
		soundfilename = nbttagcompound.getString("soundfilename");
		volume = nbttagcompound.getFloat("volume");
		pathMode = nbttagcompound.getInteger("pathmode");
		switch(pathMode)
		{
			case 1:
				File soundsdir = new File(Minecraft.getMinecraftDir(), mod_SpeakerBlock.soundDir);
				path = (new StringBuilder()).append(soundsdir.getAbsolutePath()).append("/").toString();
				break;
			case 2:
				path = mod_SpeakerBlock.userDir;
				break;
			case 3:
				File worlddir = mod_SpeakerBlock.getWorldDir();
				path = (new StringBuilder()).append(worlddir.getAbsolutePath()).append("/").toString();
				break;
			case 4:
				path = "";
				break;
			default:
				break;
		}
	}
	
	public void writeToNBT(NBTTagCompound nbttagcompound)
	{
        super.writeToNBT(nbttagcompound);
		nbttagcompound.setBoolean("soundLoops", soundLoops);
		nbttagcompound.setBoolean("soundContinues", soundContinues);
		nbttagcompound.setString("soundfilename", soundfilename);
		nbttagcompound.setFloat("volume", volume);
		nbttagcompound.setInteger("pathmode", pathMode);
	}
	
	public boolean previousRedstoneState;
	public boolean isPowered;
	public boolean loopedMusic;
	private String soundfilename;
	public boolean soundLoops;
	public boolean soundContinues;
	public int iLoc;
	public int jLoc;
	public int kLoc;
	private float volume;
	public float masterVolume;
	public int pathMode;
	public String path;
	public static GameSettings options;
}