package net.minecraft.src;

import java.io.*;
import java.util.Properties;
import java.net.URI;
import java.net.URL;
import net.minecraft.client.Minecraft;
import java.util.*;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.codecs.CodecJOrbis;
import paulscode.sound.codecs.CodecWav;
import paulscode.sound.libraries.LibraryLWJGLOpenAL;

public final class mod_SpeakerBlock extends BaseMod
{

    public mod_SpeakerBlock()
    {
    	ModLoader.SetInGameHook(this, true, false);
		ModLoader.SetInGUIHook(this, true, false); 
		mcInst = ModLoader.getMinecraftInstance();
		ModLoader.RegisterBlock(speakerblock);
		ModLoader.RegisterTileEntity(TileEntitySpeaker.class, "Speaker Block");
		ModLoader.AddName(speakerblock, "Speaker Block");
        ModLoader.AddRecipe(new ItemStack(speakerblock, 1), new Object[] {
			"WIW", "WRW", "WWW", Character.valueOf('W'), Block.planks, Character.valueOf('I'), Item.ingotIron, Character.valueOf('R'), Item.redstone
        });
		streamSources = new ArrayList<String>();
    }

    public void load()
    {

    }

    public String getVersion()
    {
        return "Speaker Block 1.0";
    }

    public boolean OnTickInGame(float f, Minecraft minecraft)
    {
        if(sndSystem == null)
        {
			try
			{
				sndSystem = (SoundSystem) (ModLoader.getPrivateValue(SoundManager.class, mcInst.sndManager, 0));
			}
			catch(java.lang.SecurityException exception)
			{
				System.out.println("Could not access sound system: access denied.");
				exception.printStackTrace();
			}
			catch(java.lang.IllegalArgumentException exception)
			{
				System.out.println("Illegal argument thrown.");
				exception.printStackTrace();
			}
			catch(java.lang.NoSuchFieldException exception)
			{
				System.out.println("No such field thrown.");
				exception.printStackTrace();
			}
        }
		if(options == null)
		{
			options = mcInst.gameSettings;
		}
		if(theWorld == null)
		{
			theWorld = mcInst.theWorld;
		}
		if(mcInst.theWorld != theWorld)
		{
			theWorld = mcInst.theWorld;
			Iterator iterator = streamSources.iterator();
			do
			{
				if(!iterator.hasNext())
				{
					break;
				}
				Object obj = iterator.next();
				String currentSource = (String) obj;
				sndSystem.stop(currentSource);
			
			}
			while(true);
			streamSources.clear();
		}
		return true;
    }
	
	public boolean OnTickInGUI(float f, Minecraft minecraft, GuiScreen guiscreen)
    {
		if(mcInst.theWorld != theWorld)
		{
			theWorld = mcInst.theWorld;
			Iterator iterator = streamSources.iterator();
			do
			{
				if(!iterator.hasNext())
				{
					break;
				}
				Object obj = iterator.next();
				String currentSource = (String) obj;
				sndSystem.stop(currentSource);
			
			}
			while(true);
			streamSources.clear();
		}
		return true;
    }

	
	private static void LoadProperties()
    {
        Properties properties = new Properties();
        try
        {
            soundsDir.mkdirs();
            if(!propsFile.exists())
            {
                propsFile.getParentFile().mkdirs();
                if(propsFile.createNewFile())
                {
                    CreateProperties();
                } else
                {
                    return;
                }
            }
            if(!propsFile.canRead())
            {
                return;
            }
        }
        catch(Exception exception) { }

        try
        {
            String s = propsFile.getAbsolutePath();
            properties.load(new FileInputStream(s));
            String s1 = properties.getProperty("speakerID");
            speakerID = Integer.parseInt(s1.trim());
            s1 = properties.getProperty("userDir");
            s1.trim();
            userDir = s1;
        }
        catch(Exception exception)
        {
            System.out.println("Error loading properties.");
            exception.printStackTrace();
        }
    }

    public static void CreateProperties()
    {
    	//Properties properties = new Properties();
        try
        {
            //properties.put("speakerID", "117");
            FileOutputStream fileoutputstream = new FileOutputStream(propsFile);
            //properties.store(fileoutputstream, "");
            OutputStreamWriter output = new OutputStreamWriter(fileoutputstream, "UTF-8");
            output.write("# Speaker block ID"); output.write('\n');
            output.write("# Default: 123"); output.write('\n');
            output.write("speakerID=123"); output.write('\n');
            output.write('\n');
            output.write("# User Directory:"); output.write('\n');
            output.write("# Input a path to use with the user directory option"); output.write('\n');
            output.write("# Use / or \\\\ in path names. \\ by itself is read as an escape character and will be omitted.");output.write('\n');
            output.write("# For example C:\\Users\\You\\Music\\ will be read as C:UsersYouMusic.");output.write('\n');
            output.write("# However C:/Users/You/Music/ will be read as is.");output.write('\n');
            output.write("userDir="); output.write('\n');output.write('\n');
            output.close();
            fileoutputstream.close();
        }
        catch(Exception exception) { }
    }

    public static File getWorldDir()
    {
        ISaveHandler isavehandler = ModLoader.getMinecraftInstance().theWorld.saveHandler;
        if(isavehandler instanceof SaveHandler)
        {
            return ((SaveHandler)isavehandler).getSaveDirectory();
        } else
        {
            return new File("");
        }
    }
	
	public static void RegisterTextures()
    {
        itemindex1 = ModLoader.getUniqueSpriteIndex("/terrain.png");
        ModLoader.addOverride("/terrain.png", "/imgz/speakerblock.png", itemindex1);
    }
	
	public static void playBlock(String s, String s1, float i, float j, float k, float f1, float f2)
	{
	    if(sndSystem == null || options.soundVolume == 0.0F)
        {
            return;
        }
		String instanceName = (new StringBuilder()).append("speakerstreaming").append(i).append(j).append(k).toString();
		if(instanceName == null)
		{
			return;
		}
		if(sndSystem.playing(instanceName))
		{
			sndSystem.stop(instanceName);
		}
		if(s == null)
		{
			return;
		}
		if(f1 > 0.0F)
		{
			try
			{
				float f5 = 16F;
				String soundUrlString = (new StringBuilder()).append(s1).append(s).toString();
				File soundFile = new File(soundUrlString);
				sndSystem.newStreamingSource(true, instanceName, soundFile.toURI().toURL(), s, false, i, j, k, 2, f5 * 4F);
				sndSystem.setVolume(instanceName, 0.5F * options.soundVolume * f2);
				sndSystem.play(instanceName);
				if(!streamSources.contains(instanceName))
				{
					streamSources.add(instanceName);
				}
			}
			catch(Throwable t)
			{
				System.out.println("Unhandled Exception thrown.");
			}
		}
	}
	
	public static boolean isPlaying(float i, float j, float k)
	{
		String instanceName = (new StringBuilder()).append("speakerstreaming").append(i).append(j).append(k).toString();
		if(sndSystem != null && sndSystem.playing(instanceName))
		{
			return true;
		}
		return false;
	}
	
	public static void stopPlaying(float i, float j, float k)
	{
		String instanceName = (new StringBuilder()).append("speakerstreaming").append(i).append(j).append(k).toString();
		if(sndSystem != null && sndSystem.playing(instanceName))
		{
			sndSystem.stop(instanceName);
			if(streamSources.contains(instanceName))
			{
				streamSources.remove(instanceName);
			}
		}
	}
	
	public static void setVolume(float i, float j, float k, float volume)
	{
		String instanceName = (new StringBuilder()).append("speakerstreaming").append(i).append(j).append(k).toString();
		if(sndSystem != null && sndSystem.playing(instanceName))
		{
			sndSystem.setVolume(instanceName, 0.5F * options.soundVolume * volume);
		}
	}

    public static SoundSystem sndSystem;
    public static Minecraft mcInst;
	public static World theWorld;
	public static GameSettings options;
	public static final Block speakerblock;
	public static int speakerID = 123;
	public static int itemindex1;
	public static List<String> streamSources;
	public static String userDir = "";
	public static String soundDir = "/mods/peronix/SpeakerBlock/Sounds/";
	public static File soundsDir = new File(Minecraft.getMinecraftDir(), "/mods/peronix/SpeakerBlock/Sounds/");
	public static final File propsFile = new File(Minecraft.getMinecraftDir(), "/mods/peronix/SpeakerBlock/SpeakerBlock.properties");

	
	static
	{
		LoadProperties();
		speakerblock = (new BlockSpeaker(speakerID, 74)).setHardness(0.8F).setBlockName("speakerBlock");
		RegisterTextures();
	}

}