package net.minecraft.src;
// Decompiled by Jad v1.5.8g. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.kpdus.com/jad.html
// Decompiler options: packimports(3) braces deadcode 

import java.util.Random;

public class BlockSpike extends Block
{

    protected BlockSpike(int i)
    {
        super(i, mod_Spike.itemindex1, Material.iron);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k)
    {
        return null;
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k)
    {
        if(world.getBlockMetadata(i, j, k) < 7)
        {
            return AxisAlignedBB.getBoundingBoxFromPool((double)i + minX, (double)j + minY, (double)k + minZ, (double)i + maxX, (double)j + maxY, (double)k + maxZ);
        }
        switch(world.getBlockMetadata(i, j, k))
        {
            case 7:
                return AxisAlignedBB.getBoundingBoxFromPool((double)i + minX, (double)j + minY, (double)k + minZ, (double)i + maxX, (double)j + 0.0625, (double)k + maxZ);
            case 8:
                return AxisAlignedBB.getBoundingBoxFromPool((double)i + minX, (double)j + minY, (double)k + 0.9375, (double)i + maxX, (double)j + maxY, (double)k + maxZ);
            case 9:
                return AxisAlignedBB.getBoundingBoxFromPool((double)i + minX, (double)j + minY, (double)k + minZ, (double)i + maxX, (double)j + maxY, (double)k + 0.0625);
            case 10:
                return AxisAlignedBB.getBoundingBoxFromPool((double)i + 0.9375, (double)j + minY, (double)k + minZ, (double)i + maxX, (double)j + maxY, (double)k + maxZ);
            case 11:
                return AxisAlignedBB.getBoundingBoxFromPool((double)i + minX, (double)j + minY, (double)k + minZ, (double)i + 0.0625, (double)j + maxY, (double)k + maxZ);
            case 12:
                return AxisAlignedBB.getBoundingBoxFromPool((double)i + minX, (double)j + 0.9375, (double)k + minZ, (double)i + maxX, (double)j + maxY, (double)k + maxZ);
        }
        return AxisAlignedBB.getBoundingBoxFromPool((double)i + minX, (double)j + minY, (double)k + minZ, (double)i + maxX, (double)j + maxY, (double)k + maxZ);
    }

    public int tickRate()
    {
        return 4;
    }

    public void randomDisplayTick(World world, int i, int j, int k, Random random)
    {
        world.scheduleBlockUpdate(i, j, k, blockID, tickRate());
    }

    public int getBlockTextureFromSideAndMetadata(int i, int j)
    {
        if(j < 7)
        {
            return mod_Spike.itemindex1;
        }else
        {
            return mod_Spike.itemindex2;
        }
    }

    public boolean isBlockNormalCube(World world, int i, int j, int k) {
        return false;
    }

    public boolean isOpaqueCube()
    {
        return false;
    }

    public int getRenderType()
    {
        return mod_Spike.spikeRenderID;
    }

    public void onBlockPlaced(World world, int i, int j, int k, int l)
    {
        int metaD = 0;
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        boolean flag4 = false;
        boolean flag5 = false;
        boolean flag6 = false;
        if(world.isBlockOpaqueCube(i, j - 1, k) || (Block.blocksList[world.getBlockId(i, j - 1, k)] != null && getValidBlock(Block.blocksList[world.getBlockId(i, j - 1, k)])))
        {
            flag1 = true;
            metaD = l == 1 ? 1 : metaD;
        }
        if(world.isBlockOpaqueCube(i, j, k + 1) || (Block.blocksList[world.getBlockId(i, j, k + 1)] != null && getValidBlock(Block.blocksList[world.getBlockId(i, j, k + 1)])))
        {
            flag2 = true;
            metaD = l == 2 ? 2 : metaD;
        }
        if(world.isBlockOpaqueCube(i, j, k - 1) || (Block.blocksList[world.getBlockId(i, j, k - 1)] != null && getValidBlock(Block.blocksList[world.getBlockId(i, j, k - 1)])))
        {
            flag3 = true;
            metaD = l == 3 ? 3 : metaD;
        }
        if(world.isBlockOpaqueCube(i + 1, j, k) || (Block.blocksList[world.getBlockId(i + 1, j, k)] != null && getValidBlock(Block.blocksList[world.getBlockId(i + 1, j, k)])))
        {
            flag4 = true;
            metaD = l == 4 ? 4 : metaD;
        }
        if(world.isBlockOpaqueCube(i - 1, j, k) || (Block.blocksList[world.getBlockId(i - 1, j, k)] != null && getValidBlock(Block.blocksList[world.getBlockId(i - 1, j, k)])))
        {
            flag5 = true;
            metaD = l == 5 ? 5 : metaD;
        }
        if(world.isBlockOpaqueCube(i, j + 1, k) || (Block.blocksList[world.getBlockId(i, j + 1, k)] != null && getValidBlock(Block.blocksList[world.getBlockId(i, j + 1, k)])))
        {
            flag6 = true;
            metaD = l == 0 ? 6 : metaD;
        }

        if(metaD == 0)
        {
            if(flag1)
            {
                metaD = 1;
            }else
            if(flag6)
            {
                metaD = 6;
            }else
            if(flag4)
            {
                metaD = 4;
            }else
            if(flag5)
            {
                metaD = 5;
            }else
            if(flag2)
            {
                metaD = 2;
            }else
            if(flag3)
            {
                metaD = 3;
            }else
            {
                metaD = 1;
            }
        }
        world.setBlockMetadataWithNotify(i, j, k, metaD);
    }

    public boolean canPlaceBlockAt(World world, int i, int j, int k)
    {
        if(world.isBlockOpaqueCube(i - 1, j, k) || (Block.blocksList[world.getBlockId(i - 1, j, k)] != null && getValidBlock(Block.blocksList[world.getBlockId(i - 1, j, k)])))
        {
            return true;
        }
        if(world.isBlockOpaqueCube(i + 1, j, k) || (Block.blocksList[world.getBlockId(i + 1, j, k)] != null && getValidBlock(Block.blocksList[world.getBlockId(i + 1, j, k)])))
        {
            return true;
        }
        if(world.isBlockOpaqueCube(i, j, k - 1) || (Block.blocksList[world.getBlockId(i, j, k - 1)] != null && getValidBlock(Block.blocksList[world.getBlockId(i, j, k - 1)])))
        {
            return true;
        }
        if(world.isBlockOpaqueCube(i, j, k + 1) || (Block.blocksList[world.getBlockId(i, j, k + 1)] != null && getValidBlock(Block.blocksList[world.getBlockId(i, j, k + 1)])))
        {
            return true;
        }
        if(world.isBlockOpaqueCube(i, j + 1, k) || (Block.blocksList[world.getBlockId(i, j + 1, k)] != null && getValidBlock(Block.blocksList[world.getBlockId(i, j + 1, k)])))
        {
            return true;
        }
        return world.isBlockOpaqueCube(i, j - 1, k) || (Block.blocksList[world.getBlockId(i, j - 1, k)] != null && getValidBlock(Block.blocksList[world.getBlockId(i, j - 1, k)]));
    }

    public boolean canBlockStay(World world, int i, int j, int k)
    {
        int metaD = world.getBlockMetadata(i, j, k);
        if((metaD == 1 || metaD == 7) && world.isBlockOpaqueCube(i, j - 1, k) || (Block.blocksList[world.getBlockId(i, j - 1, k)] != null && getValidBlock(Block.blocksList[world.getBlockId(i, j - 1, k)])))
        {
            return true;
        }
        if((metaD == 2 || metaD == 8) && world.isBlockOpaqueCube(i, j, k + 1) || (Block.blocksList[world.getBlockId(i, j, k + 1)] != null && getValidBlock(Block.blocksList[world.getBlockId(i, j, k + 1)])))
        {
            return true;
        }
        if((metaD == 3 || metaD == 9) && world.isBlockOpaqueCube(i, j, k - 1) || (Block.blocksList[world.getBlockId(i, j, k - 1)] != null && getValidBlock(Block.blocksList[world.getBlockId(i, j, k - 1)])))
        {
            return true;
        }
        if((metaD == 4 || metaD == 10) && world.isBlockOpaqueCube(i + 1, j, k) || (Block.blocksList[world.getBlockId(i + 1, j, k)] != null && getValidBlock(Block.blocksList[world.getBlockId(i + 1, j, k)])))
        {
            return true;
        }
        if((metaD == 5 || metaD == 11) && world.isBlockOpaqueCube(i - 1, j, k) || (Block.blocksList[world.getBlockId(i - 1, j, k)] != null && getValidBlock(Block.blocksList[world.getBlockId(i - 1, j, k)])))
        {
            return true;
        }
        if((metaD == 6 || metaD == 12) && world.isBlockOpaqueCube(i, j + 1, k) || (Block.blocksList[world.getBlockId(i, j + 1, k)] != null && getValidBlock(Block.blocksList[world.getBlockId(i, j + 1, k)])))
        {
            return true;
        }
        return false;
    }

    public boolean getValidBlock(Block b)
    {
        if(b == Block.glass || b == Block.pistonStickyBase || b == Block.pistonExtension || b == Block.pistonBase || b == Block.pistonMoving)
        {
            return true;
        }
        return false;
    }

    protected final void checkBlockCoordValid(World world, int i, int j, int k)
    {
        if(!canBlockStay(world, i, j, k))
        {
            dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k), 0);
            world.setBlockWithNotify(i, j, k, 0);
        }
    }

    public void updateTick(World world, int i, int j, int k, Random random)
    {
        //checkBlockCoordValid(world, i, j, k);
        int metaD = world.getBlockMetadata(i, j, k);
        int bsm1 = 1;
        int bsm2 = 1;
        if(metaD == 1 || metaD == 7)
        {
            bsm1 = 1;
            bsm2 = 7;
        }else
        if(metaD == 2 || metaD == 8)
        {
            bsm1 = 2;
            bsm2 = 8;
        }else
        if(metaD == 3 || metaD == 9)
        {
            bsm1 = 3;
            bsm2 = 9;    
        }else
        if(metaD == 4 || metaD == 10)
        {
            bsm1 = 4;
            bsm2 = 10;
        }else
        if(metaD == 5 || metaD == 11)
        {
            bsm1 = 5;
            bsm2 = 11;
        }else
        if(metaD == 6 || metaD == 12)
        {
            bsm1 = 6;
            bsm2 = 12;
        }

        boolean flag1 = false;
        boolean flag2 = false;

            if(metaD == 1 || metaD == 7 || metaD == 6 || metaD == 12)
            {
    			if(world.getBlockId(i + 1, j, k) == blockID && world.isBlockIndirectlyGettingPowered(i + 1, j, k))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i - 1, j, k) == blockID && world.isBlockIndirectlyGettingPowered(i - 1, j, k))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i, j, k + 1) == blockID && world.isBlockIndirectlyGettingPowered(i, j, k + 1))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i, j, k - 1) == blockID && world.isBlockIndirectlyGettingPowered(i, j, k - 1))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i - 1, j, k - 1) == blockID && world.isBlockIndirectlyGettingPowered(i - 1, j, k - 1))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i - 1, j, k + 1) == blockID && world.isBlockIndirectlyGettingPowered(i - 1, j, k + 1))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i + 1, j, k - 1) == blockID && world.isBlockIndirectlyGettingPowered(i + 1, j, k - 1))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i + 1, j, k + 1) == blockID && world.isBlockIndirectlyGettingPowered(i + 1, j, k + 1))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}
    		}else
    		if(metaD == 4 || metaD == 10 || metaD == 5 || metaD == 11)
    		{
    			if(world.getBlockId(i, j + 1, k) == blockID && world.isBlockIndirectlyGettingPowered(i, j + 1, k))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i, j - 1, k) == blockID && world.isBlockIndirectlyGettingPowered(i, j - 1, k))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i, j, k + 1) == blockID && world.isBlockIndirectlyGettingPowered(i, j, k + 1))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i, j, k - 1) == blockID && world.isBlockIndirectlyGettingPowered(i, j, k - 1))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i, j - 1, k - 1) == blockID && world.isBlockIndirectlyGettingPowered(i, j - 1, k - 1))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i, j - 1, k + 1) == blockID && world.isBlockIndirectlyGettingPowered(i, j - 1, k + 1))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i, j + 1, k - 1) == blockID && world.isBlockIndirectlyGettingPowered(i, j + 1, k - 1))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i, j + 1, k + 1) == blockID && world.isBlockIndirectlyGettingPowered(i, j + 1, k + 1))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}
    		}else
    		if(metaD == 2 || metaD == 8 || metaD == 3 || metaD == 9)
    		{
    			if(world.getBlockId(i + 1, j, k) == blockID && world.isBlockIndirectlyGettingPowered(i + 1, j, k))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i - 1, j, k) == blockID && world.isBlockIndirectlyGettingPowered(i - 1, j, k))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i, j + 1, k) == blockID && world.isBlockIndirectlyGettingPowered(i, j + 1, k))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i, j - 1, k) == blockID && world.isBlockIndirectlyGettingPowered(i, j - 1, k))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i - 1, j - 1, k) == blockID && world.isBlockIndirectlyGettingPowered(i - 1, j - 1, k))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i - 1, j + 1, k) == blockID && world.isBlockIndirectlyGettingPowered(i - 1, j + 1, k))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i + 1, j - 1, k) == blockID && world.isBlockIndirectlyGettingPowered(i + 1, j - 1, k))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}else
    			if(world.getBlockId(i + 1, j + 1, k) == blockID && world.isBlockIndirectlyGettingPowered(i + 1, j + 1, k))
    			{
    				world.setBlockMetadataWithNotify(i, j, k, bsm2);
    				flag1 = true;
    			}
    		}

        if(flag1)
        {
            world.markBlocksDirty(i, j, k, i, j, k);
        }else
        if(!flag1 && (world.isBlockIndirectlyGettingPowered(i, j, k) || world.isBlockIndirectlyGettingPowered(i, j + 1, k)))
        {
            if(metaD == bsm1)
            {
                world.setBlockMetadataWithNotify(i, j, k, bsm2);
                flag2 = true;
                world.markBlocksDirty(i, j, k, i, j, k);
            }
        }else
        if(!flag1)
        {
            if(metaD == bsm2)
            {
                world.setBlockMetadataWithNotify(i, j, k, bsm1);
                flag2 = true;
                world.markBlocksDirty(i, j, k, i, j, k);
            }
        }
        
        if(flag2)
        {
			if(metaD == 1 || metaD == 7 || metaD == 6 || metaD == 12)
			{
				world.scheduleBlockUpdate(i - 1, j, k, blockID, tickRate());
				world.scheduleBlockUpdate(i + 1, j, k, blockID, tickRate());
				world.scheduleBlockUpdate(i, j, k + 1, blockID, tickRate());
				world.scheduleBlockUpdate(i, j, k - 1, blockID, tickRate());
				world.scheduleBlockUpdate(i + 1, j, k - 1, blockID, tickRate());
				world.scheduleBlockUpdate(i + 1, j, k + 1, blockID, tickRate());
				world.scheduleBlockUpdate(i - 1, j, k - 1, blockID, tickRate());
				world.scheduleBlockUpdate(i - 1, j, k + 1, blockID, tickRate());
			}else
			if(metaD == 4 || metaD == 10 || metaD == 5 || metaD == 11)
			{
				world.scheduleBlockUpdate(i, j - 1, k, blockID, tickRate());
				world.scheduleBlockUpdate(i, j + 1, k, blockID, tickRate());
				world.scheduleBlockUpdate(i, j, k + 1, blockID, tickRate());
				world.scheduleBlockUpdate(i, j, k - 1, blockID, tickRate());
				world.scheduleBlockUpdate(i, j + 1, k - 1, blockID, tickRate());
				world.scheduleBlockUpdate(i, j + 1, k + 1, blockID, tickRate());
				world.scheduleBlockUpdate(i, j - 1, k - 1, blockID, tickRate());
				world.scheduleBlockUpdate(i, j - 1, k + 1, blockID, tickRate());
			}else
			if(metaD == 2 || metaD == 8 || metaD == 3 || metaD == 9)
			{
				world.scheduleBlockUpdate(i - 1, j, k, blockID, tickRate());
				world.scheduleBlockUpdate(i + 1, j, k, blockID, tickRate());
				world.scheduleBlockUpdate(i, j + 1, k, blockID, tickRate());
				world.scheduleBlockUpdate(i, j - 1, k, blockID, tickRate());
				world.scheduleBlockUpdate(i + 1, j - 1, k, blockID, tickRate());
				world.scheduleBlockUpdate(i + 1, j + 1, k, blockID, tickRate());
				world.scheduleBlockUpdate(i - 1, j - 1, k, blockID, tickRate());
				world.scheduleBlockUpdate(i - 1, j + 1, k, blockID, tickRate());
			}
        }
    }

    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity)
    {
        int metaD = world.getBlockMetadata(i, j, k);
        if(entity != null && !(entity instanceof EntityItem) && (metaD < 7)){
	    entity.attackEntityFrom(DamageSource.generic, 10);
        }
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l)
    {
        checkBlockCoordValid(world, i, j, k);
        if(l > 0 && Block.blocksList[l].canProvidePower())
        {
            boolean flag = world.isBlockIndirectlyGettingPowered(i, j, k) || world.isBlockIndirectlyGettingPowered(i, j + 1, k);
            if(flag)
            {
                world.scheduleBlockUpdate(i, j, k, blockID, tickRate());
                world.markBlocksDirty(i, j, k, i, j, k);
            }
        }
    }

    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer)
    {
	return false;
    }
}
