package net.minecraft.src;

import net.minecraft.client.Minecraft;
import java.util.Random;
import java.util.Map;
import java.util.Properties;
import java.io.*;
import java.net.URI;
import java.net.URL;


public class mod_Spike extends BaseMod
{

    public mod_Spike()
    {
        ModLoader.AddRecipe(new ItemStack(spike, 8), new Object[] {
            "X X", " X ", "XXX", Character.valueOf('X'), Item.ingotIron
        });
        spikeRenderID = ModLoader.getUniqueBlockModelID(this, false);
    }

    public void load()
    {
        
    }

    public String getVersion()
    {
        return "Spike 1.0";
    }

    private static void RegisterNames()
    {
         ModLoader.AddName(spike, "Iron Spikes");
    }

    public static void RegisterTextures()
    {
        itemindex1 = ModLoader.getUniqueSpriteIndex("/terrain.png");
        ModLoader.addOverride("/terrain.png", "/imgz/spike.png", itemindex1);
        itemindex2 = ModLoader.getUniqueSpriteIndex("/terrain.png");
        ModLoader.addOverride("/terrain.png", "/imgz/spiked.png", itemindex2);
    }

    private static void RegisterBlocks()
    {
        ModLoader.RegisterBlock(spike);
    }

    private static void LoadProperties()
    {
        Properties properties = new Properties();
        try
        {
            if(!propsFile.exists())
            {
                propsFile.getParentFile().mkdirs();
                if(propsFile.createNewFile())
                {
                    CreateProperties();
                } else
                {
                    return;
                }
            }
            if(!propsFile.canRead())
            {
                return;
            }
        }
        catch(Exception exception) { }

        try
        {
            String s = propsFile.getAbsolutePath();
            properties.load(new FileInputStream(s));
            String s1 = properties.getProperty("spikeID");
            spikeID = Integer.parseInt(s1.trim());
        }
        catch(Exception exception)
        {
            System.out.println("Error loading properties.");
            exception.printStackTrace();
        }
    }

    public static void CreateProperties()
    {
        //Properties properties = new Properties();
        try
        {
            //properties.put("speakerID", "117");
            FileOutputStream fileoutputstream = new FileOutputStream(propsFile);
            //properties.store(fileoutputstream, "");
            OutputStreamWriter output = new OutputStreamWriter(fileoutputstream, "UTF-8");
            output.write("# Spike block ID"); output.write('\n');
            output.write("# Default: 126"); output.write('\n');
            output.write("spikeID=126"); output.write('\n');
            output.close();
            fileoutputstream.close();
        }
        catch(Exception exception) { }
    }

    public boolean RenderWorldBlock(RenderBlocks renderblocks, IBlockAccess iblockaccess, int i, int j, int k, Block block, int l)
    {
        if(l == spikeRenderID)
        {
            Tessellator tessellator = Tessellator.instance;
            float f = block.getBlockBrightness(iblockaccess, i, j, k);
            tessellator.setColorOpaque_F(f, f, f);
            renderSpike(block, iblockaccess.getBlockMetadata(i, j, k), i, j, k, renderblocks.overrideBlockTexture);
            return true;
        }
        return false;
    }

    public static void renderSpike(Block block, int i, double d, double d1, double d2, int overrideBlockTexture)
    {
        Tessellator tessellator = Tessellator.instance;
        int j = block.getBlockTextureFromSideAndMetadata(0, i);
        if(overrideBlockTexture >= 0)
        {
            j = overrideBlockTexture;
        }
        int k = (j & 0xf) << 4;
        int l = j & 0xf0;
        double d3 = (float)k / 256F;
        double d4 = ((float)k + 15.99F) / 256F;
        double d5 = (float)l / 256F;
        double d6 = ((float)l + 15.99F) / 256F;
        if(i == 6 || i == 12 || i == 4 || i == 10 || i == 2 || i == 8)
        {
            double temp = 0F;
            temp = d3;
            d3 = d4;
            d4 = temp;
            temp = d5;
            d5 = d6;
            d6 = temp;
        }
        double d7 = (d + 0.5D) - 0.44999998807907104D;
        double d8 = d + 0.5D + 0.44999998807907104D;
        double d9 = (d2 + 0.5D) - 0.44999998807907104D;
        double d10 = d2 + 0.5D + 0.44999998807907104D;
        double d11 = d1 + 0.5D - 0.44999998807907104D;
        double d12 = d1 + 0.5D + 0.44999998807907104D;
        if(i == 1 || i == 6 || i == 7 || i == 12)
        {
        tessellator.addVertexWithUV(d7, d1 + 1.0D, d9, d3, d5);
        tessellator.addVertexWithUV(d7, d1 + 0.0D, d9, d3, d6);
        tessellator.addVertexWithUV(d8, d1 + 0.0D, d10, d4, d6);
        tessellator.addVertexWithUV(d8, d1 + 1.0D, d10, d4, d5);
        tessellator.addVertexWithUV(d8, d1 + 1.0D, d10, d3, d5);
        tessellator.addVertexWithUV(d8, d1 + 0.0D, d10, d3, d6);
        tessellator.addVertexWithUV(d7, d1 + 0.0D, d9, d4, d6);
        tessellator.addVertexWithUV(d7, d1 + 1.0D, d9, d4, d5);
        tessellator.addVertexWithUV(d7, d1 + 1.0D, d10, d3, d5);
        tessellator.addVertexWithUV(d7, d1 + 0.0D, d10, d3, d6);
        tessellator.addVertexWithUV(d8, d1 + 0.0D, d9, d4, d6);
        tessellator.addVertexWithUV(d8, d1 + 1.0D, d9, d4, d5);
        tessellator.addVertexWithUV(d8, d1 + 1.0D, d9, d3, d5);
        tessellator.addVertexWithUV(d8, d1 + 0.0D, d9, d3, d6);
        tessellator.addVertexWithUV(d7, d1 + 0.0D, d10, d4, d6);
        tessellator.addVertexWithUV(d7, d1 + 1.0D, d10, d4, d5);
        }else
        if(i == 4 || i == 10 || i == 5 || i == 11)
        {
        tessellator.addVertexWithUV(d + 1.0D, d11, d9, d3, d5);
        tessellator.addVertexWithUV(d + 0.0D, d11, d9, d3, d6);
        tessellator.addVertexWithUV(d + 0.0D, d12, d10, d4, d6);
        tessellator.addVertexWithUV(d + 1.0D, d12, d10, d4, d5);
        tessellator.addVertexWithUV(d + 1.0D, d12, d10, d3, d5);
        tessellator.addVertexWithUV(d + 0.0D, d12, d10, d3, d6);
        tessellator.addVertexWithUV(d + 0.0D, d11, d9, d4, d6);
        tessellator.addVertexWithUV(d + 1.0D, d11, d9, d4, d5);
        tessellator.addVertexWithUV(d + 1.0D, d11, d10, d3, d5);
        tessellator.addVertexWithUV(d + 0.0D, d11, d10, d3, d6);
        tessellator.addVertexWithUV(d + 0.0D, d12, d9, d4, d6);
        tessellator.addVertexWithUV(d + 1.0D, d12, d9, d4, d5);
        tessellator.addVertexWithUV(d + 1.0D, d12, d9, d3, d5);
        tessellator.addVertexWithUV(d + 0.0D, d12, d9, d3, d6);
        tessellator.addVertexWithUV(d + 0.0D, d11, d10, d4, d6);
        tessellator.addVertexWithUV(d + 1.0D, d11, d10, d4, d5);
        }else
        if(i == 2 || i == 8 || i == 3 || i == 9)
        {
        tessellator.addVertexWithUV(d7, d11, d2 + 1.0D, d3, d5);
        tessellator.addVertexWithUV(d7, d11, d2 + 0.0D, d3, d6);
        tessellator.addVertexWithUV(d8, d12, d2 + 0.0D, d4, d6);
        tessellator.addVertexWithUV(d8, d12, d2 + 1.0D, d4, d5);
        tessellator.addVertexWithUV(d8, d12, d2 + 1.0D, d3, d5);
        tessellator.addVertexWithUV(d8, d12, d2 + 0.0D, d3, d6);
        tessellator.addVertexWithUV(d7, d11, d2 + 0.0D, d4, d6);
        tessellator.addVertexWithUV(d7, d11, d2 + 1.0D, d4, d5);
        tessellator.addVertexWithUV(d7, d12, d2 + 1.0D, d3, d5);
        tessellator.addVertexWithUV(d7, d12, d2 + 0.0D, d3, d6);
        tessellator.addVertexWithUV(d8, d11, d2 + 0.0D, d4, d6);
        tessellator.addVertexWithUV(d8, d11, d2 + 1.0D, d4, d5);
        tessellator.addVertexWithUV(d8, d11, d2 + 1.0D, d3, d5);
        tessellator.addVertexWithUV(d8, d11, d2 + 0.0D, d3, d6);
        tessellator.addVertexWithUV(d7, d12, d2 + 0.0D, d4, d6);
        tessellator.addVertexWithUV(d7, d12, d2 + 1.0D, d4, d5);
        }
    }

    public static Block spike;
    public static int itemindex1;
    public static int itemindex2;
    public static int spikeID = 126;
    public static int spikeRenderID;
    public static final File propsFile = new File(Minecraft.getMinecraftDir(), "/mods/peronix/Spikes/Spikes.properties");

    static 
    {
        LoadProperties();
        RegisterTextures();
        spike = (new BlockSpike(spikeID)).setHardness(1.5F).setResistance(10F).setStepSound(Block.soundStoneFootstep).setBlockName("spikeBlock");
	RegisterNames();
        RegisterBlocks();
    }
}