package net.minecraft.src;

import java.util.*;
import net.minecraft.client.Minecraft;
import java.util.Properties;
import java.io.InputStream;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;

public class mod_Umbrella extends BaseMod
{


    public void load()
    {
        
    }

    public String getVersion()
    {
        return "Umbrella 1.0";
    }

    public mod_Umbrella()
    {
        instance = this;
        ModLoader.SetInGameHook(instance, true, false);
        ModLoader.AddRecipe(new ItemStack(umbrella, 1), new Object[] {
            "XXX", "XYX", "YY ", Character.valueOf('X'), Block.cloth, Character.valueOf('Y'), Item.ingotIron
        });

        try
        {
            int test = mod_MagicBoots.RenderIDheavyboots;
        }
        catch(Throwable t)
        {
            magicBootsLoaded = false;
        }
    }

    public static List getEffectsWithinAABB(AxisAlignedBB axisalignedbb)
    {
        if (fxLayers == null)
        {
            return null;
        }
        ArrayList arraylist = new ArrayList();
label0:
        for(int i = 0; i < 4; i++)
        {
            Iterator iterator = fxLayers[i].iterator();
            do
            {
                if(!iterator.hasNext())
                {
                    continue label0;
                }
                Object obj = iterator.next();
                Entity entity = (Entity)obj;
                if(axisalignedbb.minX <= entity.posX && axisalignedbb.maxX >= entity.posX && axisalignedbb.minY <= entity.posY && axisalignedbb.maxY >= entity.posY && axisalignedbb.minZ <= entity.posZ && axisalignedbb.maxZ >= entity.posZ)
                {
                    arraylist.add(entity);
                }
            } while(true);
        }

        return arraylist;
    }

    public void OnTickInGame(Minecraft minecraft)
    {
        if(fxLayers == null)
        {
            try
            {
                if(ModLoader.getMinecraftInstance().effectRenderer != null)
                {
                    fxLayers = (List[]) (ModLoader.getPrivateValue(EffectRenderer.class, mcInst.effectRenderer, 1));
                }
            }
            catch(java.lang.SecurityException exception)
            {
                System.out.println("Could not access effect renderer: access denied.");
                exception.printStackTrace();
            }
            catch(java.lang.IllegalArgumentException exception)
            {
                System.out.println("Illegal argument thrown.");
                exception.printStackTrace();
            }
            catch(java.lang.NoSuchFieldException exception)
            {
                System.out.println("No such field thrown.");
                exception.printStackTrace();
            }
            catch(java.lang.NullPointerException exception)
            {
                
            }
        }
        if(mcInst.thePlayer.motionY < -0.20000000000000001D && usingUmbrella() && System.currentTimeMillis() >= umbrellaTimer)
        {
            umbrellaTimer = System.currentTimeMillis() + 32L;
            mcInst.thePlayer.motionY = -0.20000000000000001D;
            mcInst.thePlayer.fallDistance = -0.20000000000000001F;
        }
    }

    public static boolean usingUmbrella()
    {
        boolean flag = false;
        if(mcInst.thePlayer.inventory.getCurrentItem()!= null && mcInst.thePlayer.inventory.getCurrentItem().itemID == umbrella.shiftedIndex)
        {
            flag = true;
        }
        if(magicBootsLoaded)
        {
            if(mod_MagicBoots.wearingHeavyBoots())
            {
                flag = false;
            }
        }
        return flag;
    }

    private static void RegisterNames()
    {
         ModLoader.AddName(umbrella, "Umbrella");
    }

    private static void LoadProperties()
    {
        Properties properties = new Properties();
        try
        {
            String s = (mod_Umbrella.class).getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            s = s.substring(0, s.lastIndexOf('/') + 1);
            s = (new StringBuilder()).append(s).append("Umbrella.properties").toString();
            properties.load(new FileInputStream(s));
            String s1 = properties.getProperty("umbrellaID");
            umbrellaID = Integer.parseInt(s1.trim());
        }
        catch(Exception exception)
        {
            System.out.println("Error loading properties.");
            exception.printStackTrace();
        }
    }

    public static void RegisterTextures()
    {
        itemindex1 = ModLoader.getUniqueSpriteIndex("/gui/items.png");
        ModLoader.addOverride("/gui/items.png", "/imgz/parasolo.png", itemindex1);
        itemindex2 = ModLoader.getUniqueSpriteIndex("/gui/items.png");
        ModLoader.addOverride("/gui/items.png", "/imgz/parasolc.png", itemindex2);
    }

    public static Item umbrella;
    public static int umbrellaID = 1302;
    public static int itemindex1;
    public static int itemindex2;
    public static mod_Umbrella instance;
    public static Minecraft mcInst = ModLoader.getMinecraftInstance();
    public long umbrellaTimer;
    public static boolean dualWieldingLoaded = true;
    public static boolean magicBootsLoaded = true;
    public static List fxLayers[];

    static 
    {
        LoadProperties();
        RegisterTextures();
	umbrella = (new ItemUmbrella(umbrellaID)).setItemName("umbrella");
	RegisterNames();
    }
}