/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blueprints;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class MappingRegistry {
    public HashMap<Block, Integer> blockToId = new HashMap();
    public ArrayList<Block> idToBlock = new ArrayList();
    public HashMap<Item, Integer> itemToId = new HashMap();
    public ArrayList<Item> idToItem = new ArrayList();
    public HashMap<Class<? extends Entity>, Integer> entityToId = new HashMap();
    public ArrayList<Class<? extends Entity>> idToEntity = new ArrayList();

    private void registerItem(Item item) {
        if (!this.itemToId.containsKey(item)) {
            this.idToItem.add(item);
            this.itemToId.put(item, this.idToItem.size() - 1);
        }
    }

    private void registerBlock(Block block) {
        if (!this.blockToId.containsKey(block)) {
            this.idToBlock.add(block);
            this.blockToId.put(block, this.idToBlock.size() - 1);
        }
    }

    private void registerEntity(Class<? extends Entity> entityClass) {
        if (!this.entityToId.containsKey(entityClass)) {
            this.idToEntity.add(entityClass);
            this.entityToId.put(entityClass, this.idToEntity.size() - 1);
        }
    }

    public Item getItemForId(int id) {
        if (id >= this.idToItem.size()) {
            return null;
        }
        return this.idToItem.get(id);
    }

    public int getIdForItem(Item item) {
        if (!this.itemToId.containsKey(item)) {
            this.registerItem(item);
        }
        return this.itemToId.get(item);
    }

    public int itemIdToRegistry(int id) {
        Item item = Item.func_150899_d((int)id);
        return this.getIdForItem(item);
    }

    public int itemIdToWorld(int id) {
        Item item = this.getItemForId(id);
        return Item.func_150891_b((Item)item);
    }

    public Block getBlockForId(int id) {
        if (id >= this.idToBlock.size()) {
            return null;
        }
        return this.idToBlock.get(id);
    }

    public int getIdForBlock(Block block) {
        if (!this.blockToId.containsKey(block)) {
            this.registerBlock(block);
        }
        return this.blockToId.get(block);
    }

    public int blockIdToRegistry(int id) {
        Block block = Block.func_149729_e((int)id);
        return this.getIdForBlock(block);
    }

    public int blockIdToWorld(int id) {
        Block block = this.getBlockForId(id);
        return Block.func_149682_b((Block)block);
    }

    public Class<? extends Entity> getEntityForId(int id) {
        if (id >= this.idToEntity.size()) {
            return null;
        }
        return this.idToEntity.get(id);
    }

    public int getIdForEntity(Class<? extends Entity> entity) {
        if (!this.entityToId.containsKey(entity)) {
            this.registerEntity(entity);
        }
        return this.entityToId.get(entity);
    }

    public void stackToRegistry(NBTTagCompound nbt) {
        Item item = Item.func_150899_d((int)nbt.func_74762_e("id"));
        nbt.func_74768_a("id", this.getIdForItem(item));
    }

    public void stackToWorld(NBTTagCompound nbt) {
        Item item = this.getItemForId(nbt.func_74762_e("id"));
        nbt.func_74768_a("id", Item.func_150891_b((Item)item));
    }

    public void inventoryToRegistry(NBTTagList nbt) {
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            this.stackToRegistry(nbt.func_150305_b(i));
        }
    }

    public void inventoryToWorld(NBTTagList nbt) {
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            this.stackToWorld(nbt.func_150305_b(i));
        }
    }

    public void write(NBTTagCompound nbt) {
        NBTTagList blocksMapping = new NBTTagList();
        for (Block b : this.idToBlock) {
            NBTTagCompound sub = new NBTTagCompound();
            sub.func_74778_a("name", Block.field_149771_c.func_148750_c((Object)b));
            blocksMapping.func_74742_a((NBTBase)sub);
        }
        nbt.func_74782_a("blocksMapping", (NBTBase)blocksMapping);
        NBTTagList itemsMapping = new NBTTagList();
        for (Item i : this.idToItem) {
            NBTTagCompound sub = new NBTTagCompound();
            sub.func_74778_a("name", Item.field_150901_e.func_148750_c((Object)i));
            itemsMapping.func_74742_a((NBTBase)sub);
        }
        nbt.func_74782_a("itemsMapping", (NBTBase)itemsMapping);
        NBTTagList entitiesMapping = new NBTTagList();
        for (Class<? extends Entity> e : this.idToEntity) {
            NBTTagCompound sub = new NBTTagCompound();
            sub.func_74778_a("name", e.getCanonicalName());
            entitiesMapping.func_74742_a((NBTBase)sub);
        }
        nbt.func_74782_a("entitiesMapping", (NBTBase)entitiesMapping);
    }

    public void read(NBTTagCompound nbt) {
        NBTTagList blocksMapping = nbt.func_150295_c("blocksMapping", 10);
        for (int i = 0; i < blocksMapping.func_74745_c(); ++i) {
            NBTTagCompound sub = blocksMapping.func_150305_b(i);
            String name = sub.func_74779_i("name");
            Block b = (Block)Block.field_149771_c.func_82594_a(name);
            this.registerBlock(b);
        }
        NBTTagList itemsMapping = nbt.func_150295_c("itemsMapping", 10);
        for (int i = 0; i < itemsMapping.func_74745_c(); ++i) {
            NBTTagCompound sub = itemsMapping.func_150305_b(i);
            String name = sub.func_74779_i("name");
            Item item = (Item)Item.field_150901_e.func_82594_a(name);
            this.registerItem(item);
        }
        NBTTagList entitiesMapping = nbt.func_150295_c("entitiesMapping", 10);
        for (int i = 0; i < entitiesMapping.func_74745_c(); ++i) {
            NBTTagCompound sub = entitiesMapping.func_150305_b(i);
            String name = sub.func_74779_i("name");
            Class<?> e = null;
            try {
                e = Class.forName(name);
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            this.registerEntity(e);
        }
    }
}

