/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blueprints;

import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.Translation;
import buildcraft.api.core.IInvSlot;
import java.util.LinkedList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class Schematic {
    public boolean isAlreadyBuilt(IBuilderContext context, int x, int y, int z) {
        return true;
    }

    public boolean doNotBuild() {
        return false;
    }

    public ItemStack useItem(IBuilderContext context, ItemStack req, IInvSlot slot) {
        ItemStack stack = slot.getStackInSlot();
        ItemStack result = stack.func_77946_l();
        if (stack.func_77984_f()) {
            if (req.func_77960_j() + stack.func_77960_j() <= stack.func_77958_k()) {
                stack.func_77964_b(req.func_77960_j() + stack.func_77960_j());
                result.func_77964_b(req.func_77960_j());
                req.field_77994_a = 0;
            }
            if (stack.func_77960_j() >= stack.func_77958_k()) {
                slot.decreaseStackInSlot();
            }
        } else if (stack.field_77994_a >= req.field_77994_a) {
            result.field_77994_a = req.field_77994_a;
            stack.field_77994_a -= req.field_77994_a;
            req.field_77994_a = 0;
        } else {
            req.field_77994_a -= stack.field_77994_a;
            stack.field_77994_a = 0;
        }
        if (stack.field_77994_a == 0 && stack.func_77973_b().func_77668_q() != null) {
            Item container = stack.func_77973_b().func_77668_q();
            ItemStack newStack = new ItemStack(container);
            slot.setStackInSlot(newStack);
        } else if (stack.field_77994_a == 0) {
            slot.setStackInSlot(null);
        }
        return result;
    }

    public void rotateLeft(IBuilderContext context) {
    }

    public void translateToSchematic(Translation transform) {
    }

    public void translateToWorld(Translation transform) {
    }

    public void idsToSchematic(MappingRegistry registry) {
    }

    public void idsToWorld(MappingRegistry registry) {
    }

    public void writeToWorld(IBuilderContext context, int x, int y, int z, LinkedList<ItemStack> stacks) {
    }

    public void writeToSchematic(IBuilderContext context, int x, int y, int z) {
    }

    public void postProcessing(IBuilderContext context, int x, int y, int z) {
    }

    public void writeRequirementsToSchematic(IBuilderContext context, int x, int y, int z) {
    }

    public void writeRequirementsToBuilder(IBuilderContext context, LinkedList<ItemStack> requirements) {
    }

    public void writeToNBT(NBTTagCompound nbt, MappingRegistry registry) {
    }

    public void readFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
    }

    public void inventorySlotsToSchematic(MappingRegistry registry, NBTTagCompound nbt, String nbtName) {
        if (!nbt.func_74764_b(nbtName)) {
            return;
        }
        registry.inventoryToRegistry(nbt.func_150295_c(nbtName, 10));
    }

    public void inventorySlotsToWorld(MappingRegistry registry, NBTTagCompound nbt, String nbtName) {
        if (!nbt.func_74764_b(nbtName)) {
            return;
        }
        registry.inventoryToWorld(nbt.func_150295_c(nbtName, 10));
    }

    public LinkedList<ItemStack> getStacksToDisplay(LinkedList<ItemStack> stackConsumed) {
        return stackConsumed;
    }

    public BuildingStage getBuildStage() {
        return BuildingStage.STANDALONE;
    }

    public BuildingPermission getBuildingPermission() {
        return BuildingPermission.ALL;
    }

    public double getEnergyRequirement(LinkedList<ItemStack> stacksUsed) {
        double result = 0.0;
        for (ItemStack s : stacksUsed) {
            result += (double)s.field_77994_a * 20.0;
        }
        return result;
    }

    public static enum BuildingStage {
        STANDALONE,
        SUPPORTED,
        EXPANDING;

    }
}

