/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blueprints;

import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.Schematic;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;

public abstract class SchematicFactory<S extends Schematic> {
    private static final HashMap<String, SchematicFactory> factories = new HashMap();
    private static final HashMap<Class<? extends Schematic>, SchematicFactory> schematicToFactory = new HashMap();

    protected abstract S loadSchematicFromWorldNBT(NBTTagCompound var1, MappingRegistry var2);

    public void saveSchematicToWorldNBT(NBTTagCompound nbt, S object, MappingRegistry registry) {
        nbt.func_74778_a("factoryID", this.getClass().getCanonicalName());
    }

    public static Schematic createSchematicFromWorldNBT(NBTTagCompound nbt, MappingRegistry registry) {
        String factoryName = nbt.func_74779_i("factoryID");
        if (factories.containsKey(factoryName)) {
            return factories.get(factoryName).loadSchematicFromWorldNBT(nbt, registry);
        }
        return null;
    }

    public static void registerSchematicFactory(Class<? extends Schematic> clas, SchematicFactory factory) {
        schematicToFactory.put(clas, factory);
        factories.put(factory.getClass().getCanonicalName(), factory);
    }

    public static SchematicFactory getFactory(Class<? extends Schematic> clas) {
        Class<? extends Schematic> superClass = clas.getSuperclass();
        if (schematicToFactory.containsKey(clas)) {
            return schematicToFactory.get(clas);
        }
        if (superClass != null) {
            return SchematicFactory.getFactory(superClass);
        }
        return null;
    }
}

