/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blueprints;

import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicEntity;
import buildcraft.api.blueprints.SchematicTile;
import buildcraft.api.core.JavaTools;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public final class SchematicRegistry {
    public static double BREAK_ENERGY = 10.0;
    public static final double BUILD_ENERGY = 20.0;
    private static final HashSet<Block> explicitSchematicBlocks = new HashSet();
    private static final HashMap<Block, SchematicConstructor> schematicBlocks = new HashMap();
    private static final HashMap<Class<? extends Entity>, SchematicConstructor> schematicEntities = new HashMap();
    private static final HashSet<String> modsSupporting = new HashSet();
    private static final HashSet<String> modsForbidden = new HashSet();
    private static final HashSet<String> blocksForbidden = new HashSet();

    private SchematicRegistry() {
    }

    public static void registerSchematicBlock(Block block, Class clas, Object ... params) {
        explicitSchematicBlocks.add(block);
        SchematicRegistry.internalRegisterSchematicBlock(block, clas, params);
    }

    private static void internalRegisterSchematicBlock(Block block, Class clas, Object ... params) {
        SchematicConstructor c = new SchematicConstructor();
        c.clas = clas;
        c.params = params;
        schematicBlocks.put(block, c);
    }

    public static void registerSchematicEntity(Class<? extends Entity> entityClass, Class<? extends SchematicEntity> schematicClass, Object ... params) {
        SchematicConstructor c = new SchematicConstructor();
        c.clas = schematicClass;
        c.params = params;
        schematicEntities.put(entityClass, c);
    }

    public static SchematicBlock newSchematicBlock(Block block) {
        if (block == Blocks.field_150350_a) {
            return null;
        }
        if (!schematicBlocks.containsKey(block)) {
            if (block instanceof ITileEntityProvider) {
                SchematicRegistry.internalRegisterSchematicBlock(block, SchematicTile.class, new Object[0]);
            } else {
                SchematicRegistry.internalRegisterSchematicBlock(block, SchematicBlock.class, new Object[0]);
            }
        }
        try {
            SchematicConstructor c = schematicBlocks.get(block);
            SchematicBlock s = (SchematicBlock)c.clas.getConstructors()[0].newInstance(c.params);
            s.block = block;
            return s;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static SchematicEntity newSchematicEntity(Class<? extends Entity> entityClass) {
        if (!schematicEntities.containsKey(entityClass)) {
            return null;
        }
        try {
            SchematicConstructor c = schematicEntities.get(entityClass);
            SchematicEntity s = (SchematicEntity)c.clas.getConstructors()[0].newInstance(c.params);
            s.entity = entityClass;
            return s;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void declareBlueprintSupport(String modid) {
        modsSupporting.add(modid);
    }

    public static boolean isExplicitlySupported(Block block) {
        String modid = Block.field_149771_c.func_148750_c((Object)block).split(":")[0];
        return explicitSchematicBlocks.contains(block) || modsSupporting.contains(modid);
    }

    public static boolean isAllowedForBuilding(Block block) {
        String name = Block.field_149771_c.func_148750_c((Object)block);
        String modid = name.split(":")[0];
        return !modsForbidden.contains(modid) && !blocksForbidden.contains(name);
    }

    public static void readConfiguration(Configuration conf) {
        String strippedId;
        Property excludedMods = conf.get("general", "builder.excludedMods", new String[0], "mods that should be excluded from the builder.");
        Property excludedBlocks = conf.get("general", "builder.excludedBlocks", new String[0], "blocks that should be excluded from the builder.");
        for (String id : excludedMods.getStringList()) {
            strippedId = JavaTools.stripSurroundingQuotes(id.trim());
            if (strippedId.length() <= 0) continue;
            modsForbidden.add(strippedId);
        }
        for (String id : excludedBlocks.getStringList()) {
            strippedId = JavaTools.stripSurroundingQuotes(id.trim());
            if (strippedId.length() <= 0) continue;
            blocksForbidden.add(strippedId);
        }
    }

    static {
        modsSupporting.add("minecraft");
    }

    private static class SchematicConstructor {
        Class<? extends SchematicEntity> clas;
        Object[] params;

        private SchematicConstructor() {
        }
    }
}

