/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blueprints;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.core.JavaTools;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class SchematicTile
extends SchematicBlock {
    public NBTTagCompound cpt = new NBTTagCompound();

    @Override
    public void idsToSchematic(MappingRegistry registry) {
        this.inventorySlotsToSchematic(registry, this.cpt, "Items");
    }

    @Override
    public void idsToWorld(MappingRegistry registry) {
        this.inventorySlotsToWorld(registry, this.cpt, "Items");
    }

    @Override
    public void writeToWorld(IBuilderContext context, int x, int y, int z, LinkedList<ItemStack> stacks) {
        super.writeToWorld(context, x, y, z, stacks);
        if (this.block.hasTileEntity(this.meta)) {
            TileEntity tile = context.world().func_147438_o(x, y, z);
            this.cpt.func_74768_a("x", x);
            this.cpt.func_74768_a("y", y);
            this.cpt.func_74768_a("z", z);
            if (tile != null) {
                tile.func_145839_a(this.cpt);
            }
        }
    }

    @Override
    public void writeToSchematic(IBuilderContext context, int x, int y, int z) {
        TileEntity tile;
        super.writeToSchematic(context, x, y, z);
        if (this.block.hasTileEntity(this.meta) && (tile = context.world().func_147438_o(x, y, z)) != null) {
            tile.func_145841_b(this.cpt);
        }
    }

    @Override
    public void writeRequirementsToSchematic(IBuilderContext context, int x, int y, int z) {
        TileEntity tile;
        super.writeRequirementsToSchematic(context, x, y, z);
        if (this.block.hasTileEntity(this.meta) && (tile = context.world().func_147438_o(x, y, z)) instanceof IInventory) {
            IInventory inv = (IInventory)tile;
            ArrayList<ItemStack> rqs = new ArrayList<ItemStack>();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i) == null) continue;
                rqs.add(inv.func_70301_a(i));
            }
            this.storedRequirements = JavaTools.concat(this.storedRequirements, rqs.toArray(new ItemStack[rqs.size()]));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.writeToNBT(nbt, registry);
        nbt.func_74782_a("blockCpt", (NBTBase)this.cpt);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.readFromNBT(nbt, registry);
        this.cpt = nbt.func_74775_l("blockCpt");
    }
}

