/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.mj;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.JavaTools;
import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.mj.MjBattery;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.logging.Level;
import net.minecraftforge.common.util.ForgeDirection;

public class BatteryObject
implements IBatteryObject {
    protected Field energyStored;
    protected Object obj;
    protected MjBattery batteryData;

    @Override
    public double getEnergyRequested() {
        try {
            return JavaTools.bounds(this.batteryData.maxCapacity() - this.energyStored.getDouble(this.obj), this.batteryData.minimumConsumption(), this.batteryData.maxReceivedPerCycle());
        }
        catch (IllegalAccessException e) {
            BCLog.logger.log(Level.WARNING, "can't get energy requested", e);
            return 0.0;
        }
    }

    @Override
    public double addEnergy(double mj) {
        return this.addEnergy(mj, false);
    }

    @Override
    public double addEnergy(double mj, boolean ignoreCycleLimit) {
        try {
            double used;
            double contained = this.energyStored.getDouble(this.obj);
            double maxAccepted = this.batteryData.maxCapacity() - contained + this.batteryData.minimumConsumption();
            if (!ignoreCycleLimit && maxAccepted > this.batteryData.maxReceivedPerCycle()) {
                maxAccepted = this.batteryData.maxReceivedPerCycle();
            }
            if ((used = Math.min(maxAccepted, mj)) > 0.0) {
                this.energyStored.setDouble(this.obj, Math.min(contained + used, this.batteryData.maxCapacity()));
                return used;
            }
        }
        catch (IllegalAccessException e) {
            BCLog.logger.log(Level.WARNING, "can't add energy", e);
        }
        return 0.0;
    }

    @Override
    public double getEnergyStored() {
        try {
            return this.energyStored.getDouble(this.obj);
        }
        catch (IllegalAccessException e) {
            BCLog.logger.log(Level.WARNING, "can't get return energy stored", e);
            return 0.0;
        }
    }

    @Override
    public void setEnergyStored(double mj) {
        try {
            this.energyStored.setDouble(this.obj, mj);
        }
        catch (IllegalAccessException e) {
            BCLog.logger.log(Level.WARNING, "can't set energy stored", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public double maxCapacity() {
        return this.batteryData.maxCapacity();
    }

    @Override
    public double minimumConsumption() {
        return this.batteryData.minimumConsumption();
    }

    @Override
    public double maxReceivedPerCycle() {
        return this.batteryData.maxReceivedPerCycle();
    }

    @Override
    public BatteryObject reconfigure(final double maxCapacity, final double maxReceivedPerCycle, final double minimumConsumption) {
        ForgeDirection[] forgeDirectionArray;
        if (this.batteryData != null) {
            forgeDirectionArray = this.batteryData.sides();
        } else {
            ForgeDirection[] forgeDirectionArray2 = new ForgeDirection[1];
            forgeDirectionArray = forgeDirectionArray2;
            forgeDirectionArray2[0] = ForgeDirection.UNKNOWN;
        }
        final ForgeDirection[] sides = forgeDirectionArray;
        this.batteryData = new MjBattery(){

            @Override
            public double maxCapacity() {
                return maxCapacity;
            }

            @Override
            public double maxReceivedPerCycle() {
                return maxReceivedPerCycle;
            }

            @Override
            public double minimumConsumption() {
                return minimumConsumption;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return MjBattery.class;
            }

            @Override
            public String kind() {
                return "buildcraft.kinesis";
            }

            @Override
            public ForgeDirection[] sides() {
                return sides;
            }
        };
        return this;
    }

    @Override
    public String kind() {
        return this.batteryData.kind();
    }
}

