/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.mj;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.JavaTools;
import buildcraft.api.mj.BatteryObject;
import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.mj.IBatteryProvider;
import buildcraft.api.mj.ISidedBatteryProvider;
import buildcraft.api.mj.MjBattery;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.minecraftforge.common.util.ForgeDirection;

public final class MjAPI {
    public static final String DEFAULT_POWER_FRAMEWORK = "buildcraft.kinesis";
    private static Map<BatteryHolder, BatteryField> mjBatteries = new HashMap<BatteryHolder, BatteryField>();
    private static Map<String, Class<? extends BatteryObject>> mjBatteryKinds = new HashMap<String, Class<? extends BatteryObject>>();
    private static final BatteryField invalidBatteryField = new BatteryField();

    private MjAPI() {
    }

    public static IBatteryObject getMjBattery(Object o) {
        return MjAPI.getMjBattery(o, DEFAULT_POWER_FRAMEWORK);
    }

    public static IBatteryObject getMjBattery(Object o, String kind) {
        return MjAPI.getMjBattery(o, kind, ForgeDirection.UNKNOWN);
    }

    public static IBatteryObject getMjBattery(Object o, String kind, ForgeDirection side) {
        BatteryField f;
        if (o == null) {
            return null;
        }
        if (o instanceof IBatteryProvider) {
            IBatteryObject battery;
            if (o instanceof ISidedBatteryProvider) {
                battery = ((ISidedBatteryProvider)o).getMjBattery(kind, side);
                if (battery == null && side != ForgeDirection.UNKNOWN) {
                    battery = ((ISidedBatteryProvider)o).getMjBattery(kind, ForgeDirection.UNKNOWN);
                }
            } else {
                battery = ((IBatteryProvider)o).getMjBattery(kind);
            }
            if (battery != null) {
                return battery;
            }
        }
        if ((f = MjAPI.getMjBatteryField(o.getClass(), kind, side)) == null && side != ForgeDirection.UNKNOWN) {
            f = MjAPI.getMjBatteryField(o.getClass(), kind, ForgeDirection.UNKNOWN);
        }
        if (f == null) {
            return null;
        }
        if (!mjBatteryKinds.containsKey(kind)) {
            return null;
        }
        if (f.kind == BatteryKind.Value) {
            try {
                BatteryObject obj = mjBatteryKinds.get(kind).newInstance();
                obj.obj = o;
                obj.energyStored = f.field;
                obj.batteryData = f.battery;
                return obj;
            }
            catch (InstantiationException e) {
                BCLog.logger.log(Level.WARNING, "can't instantiate class for energy kind \"" + kind + "\"");
                return null;
            }
            catch (IllegalAccessException e) {
                BCLog.logger.log(Level.WARNING, "can't instantiate class for energy kind \"" + kind + "\"");
                return null;
            }
        }
        try {
            return MjAPI.getMjBattery(f.field.get(o), kind, side);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IBatteryObject[] getAllMjBatteries(Object o) {
        return MjAPI.getAllMjBatteries(o, ForgeDirection.UNKNOWN);
    }

    public static IBatteryObject[] getAllMjBatteries(Object o, ForgeDirection direction) {
        IBatteryObject[] result = new IBatteryObject[mjBatteries.size()];
        int id = 0;
        for (String kind : mjBatteryKinds.keySet()) {
            result[id] = MjAPI.getMjBattery(o, kind, direction);
            if (result[id] == null) continue;
            ++id;
        }
        return Arrays.copyOfRange(result, 0, id);
    }

    public static void registerMJBatteryKind(String kind, Class<? extends BatteryObject> clas) {
        if (!mjBatteryKinds.containsKey(kind)) {
            mjBatteryKinds.put(kind, clas);
        } else {
            BCLog.logger.log(Level.WARNING, "energy kind \"" + kind + "\" already registered with " + clas.getCanonicalName());
        }
    }

    private static BatteryField getMjBatteryField(Class c, String kind, ForgeDirection side) {
        BatteryHolder holder = new BatteryHolder();
        holder.clazz = c;
        holder.kind = kind;
        holder.side = side;
        BatteryField bField = mjBatteries.get(holder);
        if (bField == null) {
            for (Field f : JavaTools.getAllFields(c)) {
                MjBattery battery = f.getAnnotation(MjBattery.class);
                if (battery == null || !kind.equals(battery.kind()) || !MjAPI.contains(battery.sides(), side) && !MjAPI.contains(battery.sides(), ForgeDirection.UNKNOWN)) continue;
                f.setAccessible(true);
                bField = new BatteryField();
                bField.field = f;
                bField.battery = battery;
                if (Double.TYPE.equals(f.getType())) {
                    bField.kind = BatteryKind.Value;
                } else {
                    if (f.getType().isPrimitive()) {
                        throw new RuntimeException("MJ battery needs to be object or double type");
                    }
                    bField.kind = BatteryKind.Container;
                }
                mjBatteries.put(holder, bField);
                return bField;
            }
            mjBatteries.put(holder, invalidBatteryField);
        }
        return bField == invalidBatteryField ? null : bField;
    }

    private static <T> boolean contains(T[] array, T value) {
        for (T t : array) {
            if (t != value) continue;
            return true;
        }
        return false;
    }

    static {
        mjBatteryKinds.put(DEFAULT_POWER_FRAMEWORK, BatteryObject.class);
    }

    private static class BatteryField {
        public Field field;
        public MjBattery battery;
        public BatteryKind kind;

        private BatteryField() {
        }
    }

    private static final class BatteryHolder {
        private String kind;
        private ForgeDirection side;
        private Class clazz;

        private BatteryHolder() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BatteryHolder that = (BatteryHolder)o;
            return this.kind.equals(that.kind) && this.clazz.equals(that.clazz) && this.side.equals((Object)that.side);
        }

        public int hashCode() {
            int result = this.kind.hashCode();
            result = 31 * result + this.clazz.hashCode();
            result = 31 * result + this.side.hashCode();
            return result;
        }
    }

    private static enum BatteryKind {
        Value,
        Container;

    }
}

