/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.remoteio.client.render;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLLog;
import dmillerw.remoteio.lib.DimensionalCoords;
import dmillerw.remoteio.lib.VisualState;
import dmillerw.remoteio.tile.TileRemoteInterface;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class RenderTileRemoteInterface
extends TileEntitySpecialRenderer {
    private RenderBlocks renderBlocks;

    public static boolean shouldRender(VisualState state) {
        return state == VisualState.CAMOUFLAGE_REMOTE || state == VisualState.CAMOUFLAGE_BOTH;
    }

    public void renderRemoteInterfaceAt(TileRemoteInterface tile, double x, double y, double z, float partial) {
        if (tile.remotePosition != null && tile.remotePosition.inWorld(tile.func_145831_w()) && RenderTileRemoteInterface.shouldRender(tile.visualState)) {
            WorldClient worldClient = FMLClientHandler.instance().getWorldClient();
            DimensionalCoords there = tile.remotePosition;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
            GL11.glRotated((double)(90 * tile.rotationY), (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
            Block remote = there.getBlock((IBlockAccess)worldClient);
            TileEntity remoteTile = there.getTileEntity((IBlockAccess)worldClient);
            if (tile.visualState == VisualState.CAMOUFLAGE_REMOTE) {
                GL11.glDisable((int)2896);
                Tessellator.field_78398_a.func_78382_b();
                Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
                Tessellator.field_78398_a.func_78373_b((double)(-tile.field_145851_c), (double)(-tile.field_145848_d), (double)(-tile.field_145849_e));
                Tessellator.field_78398_a.func_78372_c((float)(-(there.x - tile.field_145851_c)), (float)(-(there.y - tile.field_145848_d)), (float)(-(there.z - tile.field_145849_e)));
                for (int i = 0; i < 2; ++i) {
                    if (i == 1) {
                        OpenGlHelper.func_148821_a((int)770, (int)771, (int)0, (int)1);
                        GL11.glEnable((int)3042);
                    }
                    if (remote.canRenderInPass(i)) {
                        this.renderBlocks.func_147805_b(remote, there.x, there.y, there.z);
                    }
                    if (i != 1) continue;
                    GL11.glDisable((int)3042);
                }
                Tessellator.field_78398_a.func_78373_b(0.0, 0.0, 0.0);
                Tessellator.field_78398_a.func_78381_a();
                GL11.glEnable((int)2896);
            }
            if (remoteTile != null) {
                try {
                    TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile.remotePosition.getTileEntity((IBlockAccess)worldClient), 0.0, 0.0, 0.0, partial);
                }
                catch (Exception ex) {
                    FMLLog.warning((String)("Failed to render " + tile.remotePosition.getTileEntity((IBlockAccess)worldClient).getClass().getSimpleName() + ". Reason: " + ex.getLocalizedMessage()), (Object[])new Object[0]);
                    tile.markForRenderUpdate();
                }
            }
            GL11.glPopMatrix();
        }
    }

    public void func_147500_a(TileEntity var1, double var2, double var4, double var6, float var8) {
        this.renderRemoteInterfaceAt((TileRemoteInterface)var1, var2, var4, var6, var8);
    }

    public void func_147496_a(World world) {
        this.renderBlocks = new RenderBlocks((IBlockAccess)world);
    }
}

