/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.remoteio.lib;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DimensionalCoords {
    public int dimensionID;
    public int x;
    public int y;
    public int z;

    public static DimensionalCoords create(TileEntity tile) {
        return new DimensionalCoords(tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    public static DimensionalCoords create(EntityLivingBase entity) {
        return new DimensionalCoords(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public static DimensionalCoords fromNBT(NBTTagCompound nbt) {
        return new DimensionalCoords(nbt.func_74762_e("dimension"), nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
    }

    public DimensionalCoords(World world, int x, int y, int z) {
        this(world.field_73011_w.field_76574_g, x, y, z);
    }

    public DimensionalCoords(World world, double x, double y, double z) {
        this(world.field_73011_w.field_76574_g, x, y, z);
    }

    public DimensionalCoords(int dimensionID, double x, double y, double z) {
        this(dimensionID, (int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
    }

    public DimensionalCoords(int dimensionID, int x, int y, int z) {
        this.dimensionID = dimensionID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean withinRange(DimensionalCoords coords, int range) {
        int xRange = Math.abs(this.x - coords.x);
        int yRange = Math.abs(this.y - coords.y);
        int zRange = Math.abs(this.z - coords.z);
        return xRange <= range && yRange <= range && zRange <= range;
    }

    public boolean inWorld(World world) {
        return world.field_73011_w.field_76574_g == this.dimensionID;
    }

    public World getWorld() {
        return MinecraftServer.func_71276_C().func_71218_a(this.dimensionID);
    }

    public boolean blockExists() {
        return this.getBlock() != null && !this.getBlock().isAir((IBlockAccess)this.getWorld(), this.x, this.y, this.z);
    }

    public boolean blockExists(World world) {
        return this.getBlock((IBlockAccess)world) != null && !this.getBlock().isAir((IBlockAccess)world, this.x, this.y, this.z);
    }

    public Block getBlock() {
        return this.getWorld().func_147439_a(this.x, this.y, this.z);
    }

    public int getMeta() {
        return this.getWorld().func_72805_g(this.x, this.y, this.z);
    }

    public TileEntity getTileEntity() {
        return this.getWorld().func_147438_o(this.x, this.y, this.z);
    }

    public Block getBlock(IBlockAccess world) {
        return world.func_147439_a(this.x, this.y, this.z);
    }

    public int getMeta(IBlockAccess world) {
        return world.func_72805_g(this.x, this.y, this.z);
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        return world.func_147438_o(this.x, this.y, this.z);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("dimension", this.dimensionID);
        nbt.func_74768_a("x", this.x);
        nbt.func_74768_a("y", this.y);
        nbt.func_74768_a("z", this.z);
    }

    public int hashCode() {
        return this.dimensionID & this.x & this.y & this.z;
    }

    public DimensionalCoords copy() {
        return new DimensionalCoords(this.dimensionID, this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DimensionalCoords)) {
            return false;
        }
        return this.equals(obj);
    }

    public boolean equals(DimensionalCoords coords) {
        return this.dimensionID == coords.dimensionID && this.x == coords.x && this.y == coords.y && this.z == coords.z;
    }

    public String toString() {
        return "[" + this.dimensionID + " : " + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

