/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.remoteio.tile;

import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.mj.IBatteryProvider;
import buildcraft.api.mj.MjAPI;
import cpw.mods.fml.common.eventhandler.Event;
import dmillerw.remoteio.core.TransferType;
import dmillerw.remoteio.core.helper.ArrayHelper;
import dmillerw.remoteio.core.helper.RotationHelper;
import dmillerw.remoteio.core.tracker.BlockTracker;
import dmillerw.remoteio.lib.DimensionalCoords;
import dmillerw.remoteio.lib.VisualState;
import dmillerw.remoteio.tile.core.TileIOCore;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IWrenchable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.wands.IWandable;

public class TileRemoteInterface
extends TileIOCore
implements BlockTracker.ITrackerCallback,
IInventory,
ISidedInventory,
IFluidHandler,
IAspectContainer,
IAspectSource,
IEssentiaTransport,
IEnergySource,
IEnergySink,
IBatteryProvider,
IWandable,
IWrenchable {
    public DimensionalCoords remotePosition;
    private IBatteryObject mjBatteryCache;
    public int rotationY = 0;
    private boolean registeredWithIC2 = false;
    private boolean missingUpgrade = false;
    private boolean tracking = false;

    @Override
    public void callback(IBlockAccess world, int x, int y, int z) {
        this.updateVisualState();
        this.updateNeighbors();
    }

    @Override
    public void callback(IInventory inventory) {
        if (!this.func_145830_o() || this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.hasTransferChip(11)) {
            this.mjBatteryCache = MjAPI.getMjBattery(this.remotePosition.getTileEntity());
        }
        if (this.registeredWithIC2) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.registeredWithIC2 = false;
        }
        if (!this.registeredWithIC2 && this.hasTransferChip(10) && this.remotePosition != null && this.remotePosition.getTileEntity() != null && this.remotePosition.getTileEntity() instanceof IEnergyTile) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.registeredWithIC2 = true;
        }
        this.missingUpgrade = false;
        this.updateVisualState();
        this.updateNeighbors();
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        if (this.remotePosition != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.remotePosition.writeToNBT(tag);
            nbt.func_74782_a("position", (NBTBase)tag);
        }
        nbt.func_74768_a("axisY", this.rotationY);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("position")) {
            this.remotePosition = DimensionalCoords.fromNBT(nbt.func_74775_l("position"));
        } else {
            this.tracking = true;
        }
        this.rotationY = nbt.func_74762_e("axisY");
    }

    @Override
    public void onClientUpdate(NBTTagCompound nbt) {
        super.onClientUpdate(nbt);
        if (nbt.func_74764_b("position")) {
            this.remotePosition = DimensionalCoords.fromNBT(nbt.func_74775_l("position"));
        } else if (nbt.func_74764_b("position_null")) {
            this.remotePosition = null;
        }
        if (nbt.func_74764_b("axisY")) {
            this.rotationY = nbt.func_74762_e("axisY");
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && !this.tracking) {
            BlockTracker.INSTANCE.startTracking(this.remotePosition, this);
            this.tracking = true;
        }
    }

    public void onChunkUnload() {
        if (this.registeredWithIC2) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.registeredWithIC2 = false;
        }
        BlockTracker.INSTANCE.stopTracking(this.remotePosition);
        this.mjBatteryCache = null;
    }

    public void func_145843_s() {
        if (this.registeredWithIC2) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.registeredWithIC2 = false;
        }
        BlockTracker.INSTANCE.stopTracking(this.remotePosition);
        this.mjBatteryCache = null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void updateRemotePosition() {
        this.sendRemotePosition(this.remotePosition);
    }

    public void sendRemotePosition(DimensionalCoords coords) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (coords != null) {
            NBTTagCompound tag = new NBTTagCompound();
            coords.writeToNBT(tag);
            nbt.func_74782_a("position", (NBTBase)tag);
        } else {
            nbt.func_74757_a("position_null", true);
        }
        this.sendClientUpdate(nbt);
    }

    public void updateRotation(int modification) {
        this.rotationY += modification;
        if (this.rotationY > 3) {
            this.rotationY = 0;
        } else if (this.rotationY < 0) {
            this.rotationY = 3;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("axisY", this.rotationY);
        this.sendClientUpdate(nbt);
    }

    @Override
    public VisualState calculateVisualState() {
        if (this.remotePosition == null) {
            return VisualState.INACTIVE;
        }
        if (this.remotePosition != null && !this.remotePosition.blockExists()) {
            return VisualState.INACTIVE_BLINK;
        }
        boolean simple = this.hasUpgradeChip(2);
        boolean remote = this.hasUpgradeChip(0);
        if (simple && !remote) {
            return VisualState.CAMOUFLAGE_SIMPLE;
        }
        if (!simple && remote) {
            return VisualState.CAMOUFLAGE_REMOTE;
        }
        if (simple && remote) {
            return VisualState.CAMOUFLAGE_BOTH;
        }
        return this.missingUpgrade ? VisualState.ACTIVE_BLINK : VisualState.ACTIVE;
    }

    @Override
    public void sendVisualState(VisualState visualState) {
        super.sendVisualState(visualState);
        if (visualState == VisualState.CAMOUFLAGE_REMOTE || visualState == VisualState.CAMOUFLAGE_BOTH) {
            this.updateRemotePosition();
        }
    }

    public void setRemotePosition(DimensionalCoords coords) {
        if (this.registeredWithIC2) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.registeredWithIC2 = false;
        }
        BlockTracker.INSTANCE.stopTracking(this.remotePosition);
        this.remotePosition = coords;
        BlockTracker.INSTANCE.startTracking(this.remotePosition, this);
        if (this.hasTransferChip(11)) {
            this.mjBatteryCache = MjAPI.getMjBattery(this.remotePosition.getTileEntity());
        }
        if (!this.registeredWithIC2 && this.hasTransferChip(10) && this.remotePosition.getTileEntity() instanceof IEnergyTile) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.registeredWithIC2 = true;
        }
        this.markForUpdate();
    }

    public Object getUpgradeImplementation(Class cls) {
        return this.getUpgradeImplementation(cls, -1);
    }

    public Object getUpgradeImplementation(Class cls, int upgradeType) {
        if (this.remotePosition == null) {
            return null;
        }
        if (!this.remotePosition.blockExists()) {
            return null;
        }
        TileEntity remote = this.remotePosition.getTileEntity();
        if (remote != null ? !cls.isInstance(remote) : !cls.isInstance(this.remotePosition.getBlock())) {
            return null;
        }
        if (upgradeType != -1 && !this.hasUpgradeChip(upgradeType)) {
            return null;
        }
        return cls.cast(remote);
    }

    public Object getTransferImplementation(Class cls) {
        return this.getTransferImplementation(cls, true);
    }

    public Object getTransferImplementation(Class cls, boolean requiresChip) {
        if (this.remotePosition == null) {
            return null;
        }
        if (!this.remotePosition.blockExists()) {
            return null;
        }
        TileEntity remote = this.remotePosition.getTileEntity();
        if (remote != null ? !cls.isInstance(remote) : !cls.isInstance(this.remotePosition.getBlock())) {
            return null;
        }
        if (requiresChip && !this.hasTransferChip(TransferType.getTypeForInterface(cls))) {
            this.missingUpgrade = false;
            if (false) {
                this.missingUpgrade = true;
                this.updateVisualState();
            }
            return null;
        }
        return cls.cast(remote);
    }

    public ForgeDirection getAdjustedSide(ForgeDirection side) {
        return ForgeDirection.getOrientation((int)RotationHelper.getRotatedSide(0, this.rotationY, 0, side.ordinal()));
    }

    public int getAdjustedSide(int side) {
        return RotationHelper.getRotatedSide(0, this.rotationY, 0, side);
    }

    public int func_70302_i_() {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null ? inventory.func_70302_i_() : 0;
    }

    public ItemStack func_70301_a(int slot) {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null ? inventory.func_70301_a(slot) : null;
    }

    public ItemStack func_70298_a(int slot, int amt) {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null ? inventory.func_70298_a(slot, amt) : null;
    }

    public ItemStack func_70304_b(int slot) {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null ? inventory.func_70304_b(slot) : null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        if (inventory != null) {
            inventory.func_70299_a(slot, stack);
        }
    }

    public String func_145825_b() {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null ? inventory.func_145825_b() : null;
    }

    public boolean func_145818_k_() {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null ? inventory.func_145818_k_() : false;
    }

    public int func_70297_j_() {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null ? inventory.func_70297_j_() : 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null ? inventory.func_70300_a(player) : false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null ? inventory.func_94041_b(slot, stack) : false;
    }

    public int[] func_94128_d(int side) {
        ISidedInventory sidedInventory = (ISidedInventory)this.getTransferImplementation(ISidedInventory.class);
        if (sidedInventory != null) {
            return sidedInventory.func_94128_d(this.getAdjustedSide(side));
        }
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        if (inventory != null) {
            return ArrayHelper.getIncrementalArray(0, inventory.func_70302_i_(), 1);
        }
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        ISidedInventory sidedInventory = (ISidedInventory)this.getTransferImplementation(ISidedInventory.class);
        if (sidedInventory != null) {
            return sidedInventory.func_102007_a(slot, stack, this.getAdjustedSide(side));
        }
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        if (inventory != null) {
            return inventory.func_94041_b(slot, stack);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        ISidedInventory sidedInventory = (ISidedInventory)this.getTransferImplementation(ISidedInventory.class);
        if (sidedInventory != null) {
            return sidedInventory.func_102008_b(slot, stack, this.getAdjustedSide(side));
        }
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        IFluidHandler fluidHandler = (IFluidHandler)this.getTransferImplementation(IFluidHandler.class);
        return fluidHandler != null ? fluidHandler.fill(this.getAdjustedSide(from), resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        IFluidHandler fluidHandler = (IFluidHandler)this.getTransferImplementation(IFluidHandler.class);
        return fluidHandler != null ? fluidHandler.drain(this.getAdjustedSide(from), resource, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        IFluidHandler fluidHandler = (IFluidHandler)this.getTransferImplementation(IFluidHandler.class);
        return fluidHandler != null ? fluidHandler.drain(this.getAdjustedSide(from), maxDrain, doDrain) : null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        IFluidHandler fluidHandler = (IFluidHandler)this.getTransferImplementation(IFluidHandler.class);
        return fluidHandler != null ? fluidHandler.canFill(this.getAdjustedSide(from), fluid) : false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        IFluidHandler fluidHandler = (IFluidHandler)this.getTransferImplementation(IFluidHandler.class);
        return fluidHandler != null ? fluidHandler.canDrain(this.getAdjustedSide(from), fluid) : false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        IFluidHandler fluidHandler = (IFluidHandler)this.getTransferImplementation(IFluidHandler.class);
        return fluidHandler != null ? fluidHandler.getTankInfo(this.getAdjustedSide(from)) : new FluidTankInfo[]{};
    }

    @Override
    public AspectList getAspects() {
        IAspectContainer aspectContainer = (IAspectContainer)this.getTransferImplementation(IAspectContainer.class);
        return aspectContainer != null ? aspectContainer.getAspects() : new AspectList();
    }

    @Override
    public void setAspects(AspectList aspects) {
        IAspectContainer aspectContainer = (IAspectContainer)this.getTransferImplementation(IAspectContainer.class);
        if (aspectContainer != null) {
            aspectContainer.setAspects(aspects);
        }
    }

    @Override
    public boolean doesContainerAccept(Aspect tag) {
        IAspectContainer aspectContainer = (IAspectContainer)this.getTransferImplementation(IAspectContainer.class);
        return aspectContainer != null ? aspectContainer.doesContainerAccept(tag) : false;
    }

    @Override
    public int addToContainer(Aspect tag, int amount) {
        IAspectContainer aspectContainer = (IAspectContainer)this.getTransferImplementation(IAspectContainer.class);
        return aspectContainer != null ? aspectContainer.addToContainer(tag, amount) : amount;
    }

    @Override
    public boolean takeFromContainer(Aspect tag, int amount) {
        IAspectContainer aspectContainer = (IAspectContainer)this.getTransferImplementation(IAspectContainer.class);
        return aspectContainer != null ? aspectContainer.takeFromContainer(tag, amount) : false;
    }

    @Override
    public boolean takeFromContainer(AspectList ot) {
        IAspectContainer aspectContainer = (IAspectContainer)this.getTransferImplementation(IAspectContainer.class);
        return aspectContainer != null ? aspectContainer.takeFromContainer(ot) : false;
    }

    @Override
    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        IAspectContainer aspectContainer = (IAspectContainer)this.getTransferImplementation(IAspectContainer.class);
        return aspectContainer != null ? aspectContainer.doesContainerContainAmount(tag, amount) : false;
    }

    @Override
    public boolean doesContainerContain(AspectList ot) {
        IAspectContainer aspectContainer = (IAspectContainer)this.getTransferImplementation(IAspectContainer.class);
        return aspectContainer != null ? aspectContainer.doesContainerContain(ot) : false;
    }

    @Override
    public int containerContains(Aspect tag) {
        IAspectContainer aspectContainer = (IAspectContainer)this.getTransferImplementation(IAspectContainer.class);
        return aspectContainer != null ? aspectContainer.containerContains(tag) : 0;
    }

    @Override
    public boolean isConnectable(ForgeDirection face) {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null ? essentiaTransport.isConnectable(this.getAdjustedSide(face)) : false;
    }

    @Override
    public boolean canInputFrom(ForgeDirection face) {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null ? essentiaTransport.canInputFrom(this.getAdjustedSide(face)) : false;
    }

    @Override
    public boolean canOutputTo(ForgeDirection face) {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null ? essentiaTransport.canOutputTo(this.getAdjustedSide(face)) : false;
    }

    @Override
    public void setSuction(Aspect aspect, int amount) {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        if (essentiaTransport != null) {
            essentiaTransport.setSuction(aspect, amount);
        }
    }

    @Override
    public Aspect getSuctionType(ForgeDirection face) {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null ? essentiaTransport.getSuctionType(this.getAdjustedSide(face)) : null;
    }

    @Override
    public int getSuctionAmount(ForgeDirection face) {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null ? essentiaTransport.getSuctionAmount(this.getAdjustedSide(face)) : 0;
    }

    @Override
    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null ? essentiaTransport.takeEssentia(aspect, amount, this.getAdjustedSide(face)) : 0;
    }

    @Override
    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null ? essentiaTransport.addEssentia(aspect, amount, this.getAdjustedSide(face)) : 0;
    }

    @Override
    public Aspect getEssentiaType(ForgeDirection face) {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null ? essentiaTransport.getEssentiaType(this.getAdjustedSide(face)) : null;
    }

    @Override
    public int getEssentiaAmount(ForgeDirection face) {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null ? essentiaTransport.getEssentiaAmount(this.getAdjustedSide(face)) : 0;
    }

    @Override
    public int getMinimumSuction() {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null ? essentiaTransport.getMinimumSuction() : 0;
    }

    @Override
    public boolean renderExtendedTube() {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null ? essentiaTransport.renderExtendedTube() : false;
    }

    @Override
    public double getOfferedEnergy() {
        IEnergySource energySource = (IEnergySource)this.getTransferImplementation(IEnergySource.class);
        return energySource != null ? energySource.getOfferedEnergy() : 0.0;
    }

    @Override
    public void drawEnergy(double amount) {
        IEnergySource energySource = (IEnergySource)this.getTransferImplementation(IEnergySource.class);
        if (energySource != null) {
            energySource.drawEnergy(amount);
        }
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        IEnergySource energySource = (IEnergySource)this.getTransferImplementation(IEnergySource.class);
        return energySource != null ? energySource.emitsEnergyTo(receiver, this.getAdjustedSide(direction)) : false;
    }

    @Override
    public double demandedEnergyUnits() {
        IEnergySink energySink = (IEnergySink)this.getTransferImplementation(IEnergySink.class);
        return energySink != null ? energySink.demandedEnergyUnits() : 0.0;
    }

    @Override
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        IEnergySink energySink = (IEnergySink)this.getTransferImplementation(IEnergySink.class);
        return energySink != null ? energySink.injectEnergyUnits(directionFrom, amount) : 0.0;
    }

    @Override
    public int getMaxSafeInput() {
        IEnergySink energySink = (IEnergySink)this.getTransferImplementation(IEnergySink.class);
        return energySink != null ? energySink.getMaxSafeInput() : Integer.MAX_VALUE;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        IEnergySink energySink = (IEnergySink)this.getTransferImplementation(IEnergySink.class);
        return energySink != null ? energySink.acceptsEnergyFrom(emitter, this.getAdjustedSide(direction)) : false;
    }

    @Override
    public IBatteryObject getMjBattery(String kind) {
        return this.mjBatteryCache;
    }

    @Override
    public int onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, int x, int y, int z, int side, int md) {
        IWandable wandable = (IWandable)this.getUpgradeImplementation(IWandable.class, 1);
        return wandable != null ? wandable.onWandRightClick(world, wandstack, player, x, y, z, this.getAdjustedSide(ForgeDirection.getOrientation((int)side)).ordinal(), md) : -1;
    }

    @Override
    public ItemStack onWandRightClick(World world, ItemStack wandstack, EntityPlayer player) {
        IWandable wandable = (IWandable)this.getUpgradeImplementation(IWandable.class, 1);
        return wandable != null ? wandable.onWandRightClick(world, wandstack, player) : wandstack;
    }

    @Override
    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
        IWandable wandable = (IWandable)this.getUpgradeImplementation(IWandable.class, 1);
        if (wandable != null) {
            wandable.onUsingWandTick(wandstack, player, count);
        }
    }

    @Override
    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
        IWandable wandable = (IWandable)this.getUpgradeImplementation(IWandable.class, 1);
        if (wandable != null) {
            wandable.onWandStoppedUsing(wandstack, world, player, count);
        }
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        IWrenchable wrenchable = (IWrenchable)this.getUpgradeImplementation(IWrenchable.class, 1);
        return wrenchable != null ? wrenchable.wrenchCanSetFacing(entityPlayer, side) : false;
    }

    @Override
    public short getFacing() {
        IWrenchable wrenchable = (IWrenchable)this.getUpgradeImplementation(IWrenchable.class, 1);
        return wrenchable != null ? wrenchable.getFacing() : (short)0;
    }

    @Override
    public void setFacing(short facing) {
        IWrenchable wrenchable = (IWrenchable)this.getUpgradeImplementation(IWrenchable.class, 1);
        if (wrenchable != null) {
            wrenchable.setFacing(facing);
        }
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    public float getWrenchDropRate() {
        return 0.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return null;
    }
}

