/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.remoteio.tile.core;

import dmillerw.remoteio.core.helper.InventoryHelper;
import dmillerw.remoteio.inventory.InventoryItem;
import dmillerw.remoteio.inventory.InventoryNBT;
import dmillerw.remoteio.item.HandlerItem;
import dmillerw.remoteio.lib.VisualState;
import dmillerw.remoteio.tile.core.TileCore;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileIOCore
extends TileCore
implements InventoryNBT.IInventoryCallback {
    public ItemStack simpleCamo;
    public VisualState visualState = VisualState.INACTIVE;
    public InventoryNBT transferChips = new InventoryNBT(this, 9, 1);
    public InventoryNBT upgradeChips = new InventoryNBT(this, 9, 1);

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.transferChips.writeToNBT("TransferChips", nbt);
        this.upgradeChips.writeToNBT("UpgradeChips", nbt);
        if (this.simpleCamo != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.simpleCamo.func_77955_b(tag);
            nbt.func_74782_a("simple", (NBTBase)tag);
        }
        nbt.func_74774_a("state", (byte)this.visualState.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.transferChips.readFromNBT("TransferChips", nbt);
        this.upgradeChips.readFromNBT("UpgradeChips", nbt);
        this.simpleCamo = nbt.func_74764_b("simple") ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("simple")) : null;
        this.visualState = VisualState.values()[nbt.func_74771_c("state")];
    }

    @Override
    public void onClientUpdate(NBTTagCompound nbt) {
        if (nbt.func_74764_b("state")) {
            this.visualState = VisualState.values()[nbt.func_74771_c("state")];
        }
        if (nbt.func_74764_b("simple")) {
            this.simpleCamo = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("simple"));
        } else if (nbt.func_74764_b("simple_null")) {
            this.simpleCamo = null;
        }
    }

    public boolean hasTransferChip(int type) {
        return InventoryHelper.containsStack((IInventory)this.transferChips, new ItemStack(HandlerItem.transferChip, 1, type), true, false);
    }

    public boolean hasUpgradeChip(int type) {
        return InventoryHelper.containsStack((IInventory)this.upgradeChips, new ItemStack(HandlerItem.upgradeChip, 1, type), true, false);
    }

    public void updateSimpleCamouflage() {
        for (ItemStack stack1 : InventoryHelper.toArray((IInventory)this.upgradeChips)) {
            ItemStack stack;
            if (stack1 == null || stack1.func_77960_j() != 2 || (stack = new InventoryItem(stack1, 1).func_70301_a(0)) == null) continue;
            this.simpleCamo = stack;
            this.sendSimpleCamouflage(stack);
            break;
        }
    }

    public void sendSimpleCamouflage(ItemStack stack) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (stack != null) {
            NBTTagCompound tag = new NBTTagCompound();
            stack.func_77955_b(tag);
            nbt.func_74782_a("simple", (NBTBase)tag);
        } else {
            nbt.func_74757_a("simple_null", true);
        }
        this.sendClientUpdate(nbt);
    }

    public abstract VisualState calculateVisualState();

    public void updateVisualState() {
        VisualState state;
        this.visualState = state = this.calculateVisualState();
        this.sendVisualState(state);
    }

    public void sendVisualState(VisualState visualState) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("state", (byte)visualState.ordinal());
        this.sendClientUpdate(nbt);
        if (visualState == VisualState.CAMOUFLAGE_SIMPLE || visualState == VisualState.CAMOUFLAGE_BOTH) {
            this.updateSimpleCamouflage();
        }
    }
}

