/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.renderer.block;

import net.malisis.core.renderer.BaseRenderer;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.Vertex;
import net.malisis.core.renderer.preset.ShapePreset;
import net.malisis.doors.block.Door;
import net.malisis.doors.entity.MixedBlockTileEntity;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class MixedBlockRenderer
extends BaseRenderer {
    public static int renderId;
    public Door block;
    private static int currentPass;

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (!item.func_77942_o()) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)2903);
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        this.prepare(3, new double[0]);
        Block b1 = Block.func_149729_e((int)item.func_77978_p().func_74762_e("block1"));
        Block b2 = Block.func_149729_e((int)item.func_77978_p().func_74762_e("block2"));
        int metadata1 = item.func_77978_p().func_74762_e("metadata1");
        int metadata2 = item.func_77978_p().func_74762_e("metadata2");
        this.set(b1, metadata1);
        this.drawShape(ShapePreset.Cube());
        this.set(b2, metadata2);
        this.drawSecondPass(ForgeDirection.WEST);
        this.clean();
        GL11.glPopMatrix();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int metadata = world.func_72805_g(x, y, z);
        this.set(world, block, x, y, z, metadata);
        MixedBlockTileEntity te = (MixedBlockTileEntity)world.func_147438_o(x, y, z);
        if (te == null) {
            return false;
        }
        this.prepare(1, new double[0]);
        if (renderer.func_147744_b()) {
            RenderParameters rp = RenderParameters.setDefault();
            rp.icon = renderer.field_147840_d;
            this.drawShape(ShapePreset.Cube(), rp);
        } else if (currentPass == 0 && te.block1 != null) {
            this.set(te.block1, te.metadata1);
            this.drawShape(ShapePreset.Cube());
        } else if (te.block2 != null) {
            GL11.glAlphaFunc((int)516, (float)0.0f);
            this.set(te.block2, te.metadata2);
            this.drawSecondPass(ForgeDirection.getOrientation((int)metadata));
        }
        this.clean();
        return true;
    }

    private void drawSecondPass(ForgeDirection dir) {
        RenderParameters rp = RenderParameters.setDefault();
        rp.usePerVertexAlpha = true;
        Shape cube = ShapePreset.Cube();
        for (Face f : cube.getFaces()) {
            for (Vertex v : f.getVertexes()) {
                if (!v.name().toLowerCase().contains(dir.name().toLowerCase())) continue;
                v.setAlpha(0);
            }
        }
        this.drawShape(cube, rp);
    }

    public static void setRenderPass(int pass) {
        currentPass = pass;
    }
}

