/*
 * Decompiled with CFR 0.152.
 */
package net.row.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.row.helpers.RotationHelper;
import net.row.registry.RoWBlocks;
import net.row.tileentity.TileEntityPointer;
import net.row.tileentity.TileEntityRailNormal;

public class BlockPointer
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] ico;
    private final boolean islit;

    public BlockPointer(Material material, boolean p) {
        super(material);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.func_149663_c("row.blockPointer");
        this.islit = p;
        if (this.islit) {
            this.func_149715_a(0.5f);
            this.func_149663_c("row.blockPointer_lit");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int p1, int p2) {
        return this.ico[p2 % 2];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.ico = new IIcon[2];
        this.ico[0] = p_149651_1_.func_94245_a("row:pointer");
        this.ico[1] = p_149651_1_.func_94245_a("row:pointer_mod");
    }

    public int func_149738_a(World p_149738_1_) {
        return 30;
    }

    public void func_149726_b(World w, int i, int j, int k) {
        if (!w.field_72995_K) {
            w.func_147464_a(i, j, k, (Block)this, 4);
        }
    }

    public void func_149695_a(World w, int i, int j, int k, Block p_149695_5_) {
        if (!w.field_72995_K) {
            w.func_147464_a(i, j, k, (Block)this, 4);
        }
    }

    public void func_149674_a(World w, int i, int j, int k, Random r) {
        if (!w.field_72995_K) {
            int mtd = w.func_72805_g(i, j, k);
            TileEntityPointer tile = (TileEntityPointer)w.func_147438_o(i, j, k);
            int dir = tile.dir;
            boolean act = tile.activated;
            boolean inv = tile.inverted;
            if (mtd == 1 && !this.islit) {
                w.func_147465_d(i, j, k, RoWBlocks.pointer_lit, mtd, 3);
            }
            if (mtd == 0 && this.islit) {
                w.func_147465_d(i, j, k, RoWBlocks.pointer, mtd, 3);
            }
            tile = (TileEntityPointer)w.func_147438_o(i, j, k);
            tile.dir = dir;
            tile.activated = act;
            tile.inverted = inv;
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        TileEntityRailNormal tiler;
        TileEntityPointer tile = (TileEntityPointer)world.func_147438_o(x, y, z);
        tile.activated = !tile.activated;
        int[] s = RotationHelper.rotateXZByDir(tile.inverted ? 2 : -2, 0, tile.dir);
        if (world.func_147439_a(x + s[0], y, z + s[1]) == RoWBlocks.railNormal && (tiler = (TileEntityRailNormal)world.func_147438_o(x + s[0], y, z + s[1])) != null) {
            tiler.activated = tile.activated;
        }
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemstack) {
        TileEntityRailNormal tiler;
        world.func_72921_c(x, y, z, itemstack.func_77960_j(), 3);
        int dir = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int[] s = RotationHelper.rotateXZByDir(2, 0, dir);
        int[] s2 = RotationHelper.rotateXZByDir(-2, 0, dir);
        TileEntityPointer tile = (TileEntityPointer)world.func_147438_o(x, y, z);
        tile.dir = dir;
        if (world.func_147439_a(x + s[0], y, z + s[1]) == RoWBlocks.railNormal) {
            TileEntityRailNormal tiler2 = (TileEntityRailNormal)world.func_147438_o(x + s[0], y, z + s[1]);
            if (tiler2 != null && (tiler2.mId == 5 || tiler2.mId == 6 || tiler2.mId == 9 || tiler2.mId == 10 || tiler2.mId == 11)) {
                tile.activated = tiler2.activated;
                tile.inverted = true;
            }
        } else if (world.func_147439_a(x + s2[0], y, z + s2[1]) == RoWBlocks.railNormal && (tiler = (TileEntityRailNormal)world.func_147438_o(x + s2[0], y, z + s2[1])) != null && (tiler.mId == 5 || tiler.mId == 6 || tiler.mId == 9 || tiler.mId == 10 || tiler.mId == 11)) {
            tile.activated = tiler.activated;
        }
    }

    public boolean func_149742_c(World par1World, int par2, int par3, int par4) {
        Block block = par1World.func_147439_a(par2, par3, par4);
        return (block == null || block.isReplaceable((IBlockAccess)par1World, par2, par3, par4)) && par1World.isSideSolid(par2, par3 - 1, par4, ForgeDirection.UP);
    }

    public void func_149749_a(World world, int i, int j, int k, Block p_149749_5_, int p_149749_6_) {
        world.func_147475_p(i, j, k);
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149646_a(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public TileEntity func_149915_a(World world, int par2) {
        return new TileEntityPointer();
    }
}

