/*
 * Decompiled with CFR 0.152.
 */
package tennox.planetoid;

import tennox.planetoid.Planetoid;
import tennox.planetoid.PlanetoidGeneratorInfo;

public enum Option {
    MIN_RADIUS("planetoid.gui.minradius", 1, 128),
    MAX_RADIUS("planetoid.gui.maxradius", 1, 128),
    SPAWNTRIES("planetoid.gui.spawntries", 1, 100);

    private String name;
    private int min;
    private int max;

    public static void defaults(PlanetoidGeneratorInfo info) {
        MIN_RADIUS.setValue(info, 5);
        MAX_RADIUS.setValue(info, 15);
        SPAWNTRIES.setValue(info, 16);
    }

    public void updateValue(PlanetoidGeneratorInfo info, float sliderValue) {
        this.setValue(info, this.getRealValue(sliderValue));
    }

    public void setValue(PlanetoidGeneratorInfo info, int v) {
        int value = v;
        if (v < this.min) {
            value = this.min;
        } else if (v > this.max) {
            value = this.max;
        }
        switch (this) {
            case MIN_RADIUS: {
                info.min_radius = value;
                break;
            }
            case MAX_RADIUS: {
                info.max_radius = value;
                break;
            }
            case SPAWNTRIES: {
                info.spawntries = value;
            }
        }
    }

    public int getValue(PlanetoidGeneratorInfo info) {
        switch (this) {
            case MIN_RADIUS: {
                return info.min_radius;
            }
            case MAX_RADIUS: {
                return info.max_radius;
            }
            case SPAWNTRIES: {
                return info.spawntries;
            }
        }
        return 0;
    }

    public String getDisplayString(float sliderValue) {
        return Planetoid.translate(this.name) + ": " + this.getRealValue(sliderValue);
    }

    public int getRealValue(float sliderValue) {
        return this.min + (int)((float)Math.round(this.max - this.min) * sliderValue);
    }

    public float getSliderValue(PlanetoidGeneratorInfo info) {
        return (float)(this.getValue(info) - this.min) / ((float)this.max - (float)this.min);
    }

    public static void checkValues(PlanetoidGeneratorInfo info) {
        if (MIN_RADIUS.getValue(info) > MAX_RADIUS.getValue(info)) {
            MIN_RADIUS.setValue(info, MAX_RADIUS.getValue(info));
        }
        if (MAX_RADIUS.getValue(info) < MIN_RADIUS.getValue(info)) {
            MAX_RADIUS.setValue(info, MIN_RADIUS.getValue(info));
        }
    }

    private Option(String name, int min, int max) {
        this.name = name;
        this.min = min;
        this.max = max;
    }
}

