/*
 * Decompiled with CFR 0.152.
 */
package tennox.planetoid;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import tennox.planetoid.PlanetType;
import tennox.planetoid.PlanetoidChunkManager;
import tennox.planetoid.TimeAnalyzer;

public class Planet {
    static PlanetType DIRT = new PlanetType(Blocks.field_150346_d, 20, "Dirt").setTopBlock((Block)Blocks.field_150349_c);
    static PlanetType WOOD = new PlanetType((Block)Blocks.field_150362_t, Blocks.field_150364_r, 10, "Wood");
    static PlanetType WATER = new PlanetType(Blocks.field_150359_w, Blocks.field_150355_j, 5, "Water");
    static PlanetType SAND = new PlanetType(Blocks.field_150354_m, 10, "Sand").setBottomBlock(Blocks.field_150322_A);
    static PlanetType GLOWSTONE = new PlanetType(Blocks.field_150426_aN, 3, "Glowstone");
    static PlanetType STONE = new PlanetType(Blocks.field_150348_b, 20, "Stone");
    static PlanetType GRAVEL = new PlanetType(Blocks.field_150348_b, Blocks.field_150351_n, 40, "Gravel");
    static PlanetType COBBLESTONE = new PlanetType(Blocks.field_150348_b, Blocks.field_150347_e, 60, "Cobblestone");
    static PlanetType LAVA = new PlanetType(Blocks.field_150348_b, Blocks.field_150353_l, 60, "Lava");
    static PlanetType COAL = new PlanetType(Blocks.field_150348_b, Blocks.field_150365_q, 60, "Coal");
    static PlanetType IRON = new PlanetType(Blocks.field_150348_b, Blocks.field_150366_p, 60, "Iron");
    static PlanetType GOLD = new PlanetType(Blocks.field_150348_b, Blocks.field_150352_o, 30, "Gold");
    static PlanetType REDSTONE = new PlanetType(Blocks.field_150348_b, Blocks.field_150450_ax, 30, "Redstone");
    static PlanetType LAPISLAZULI = new PlanetType(Blocks.field_150348_b, Blocks.field_150369_x, 15, "Lapislazuli");
    static PlanetType TNT = new PlanetType(Blocks.field_150348_b, Blocks.field_150335_W, 2, "TNT");
    static PlanetType DIAMOND = new PlanetType(Blocks.field_150348_b, Blocks.field_150482_ag, 2, "Diamond");
    static PlanetType EMERALD = new PlanetType(Blocks.field_150348_b, Blocks.field_150412_bA, 1, "Emerald");
    static ArrayList<PlanetType> stonetypes = new ArrayList();
    static ArrayList<PlanetType> types = Planet.initTypes();
    Random rand = new Random();
    PlanetoidChunkManager chunkManager;
    World world2;
    int x;
    int y;
    int z;
    int radius;
    PlanetType type;
    ArrayList<Point> unfinished = new ArrayList();
    ArrayList<Point> finished = new ArrayList();

    public Planet(PlanetoidChunkManager cm, World w, int x, int y, int z, int r) {
        this.chunkManager = cm;
        this.world2 = w;
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = r;
        this.type = this.getRandomPlanet();
    }

    private static ArrayList<PlanetType> initTypes() {
        ArrayList<PlanetType> list = new ArrayList<PlanetType>();
        list.add(DIRT);
        list.add(WOOD);
        list.add(WATER);
        list.add(SAND);
        list.add(GLOWSTONE);
        list.add(STONE);
        stonetypes.add(GRAVEL);
        stonetypes.add(COBBLESTONE);
        stonetypes.add(LAVA);
        stonetypes.add(COAL);
        stonetypes.add(IRON);
        stonetypes.add(GOLD);
        stonetypes.add(REDSTONE);
        stonetypes.add(LAPISLAZULI);
        stonetypes.add(TNT);
        stonetypes.add(DIAMOND);
        stonetypes.add(EMERALD);
        return list;
    }

    public Planet(PlanetoidChunkManager cm, World w, double x, double y, double z, double r) {
        this(cm, w, Planet.round(x), Planet.round(y), Planet.round(z), Planet.round(r));
    }

    public static void print() {
        System.out.println("---PREGENERATION: ---");
        for (PlanetType p : types) {
            System.out.println(p.name + ":\t" + p.total);
        }
        for (PlanetType p : stonetypes) {
            System.out.println("-" + p.name + ":\t" + p.total);
        }
        System.out.println("---PREGENERATION END---");
    }

    public PlanetType getRandomPlanet() {
        this.rand.setSeed((long)this.x * 341873128712L + (long)this.z * 132897987541L);
        ArrayList<PlanetType> list = new ArrayList<PlanetType>();
        list.addAll(types);
        PlanetType type = (PlanetType)WeightedRandom.func_76271_a((Random)this.rand, list);
        if (type == STONE) {
            list.clear();
            list.addAll(stonetypes);
            type = (PlanetType)WeightedRandom.func_76271_a((Random)this.rand, list);
        }
        ++type.total;
        if (type.out == Blocks.field_150348_b) {
            ++Planet.STONE.total;
        }
        return type;
    }

    public void generateChunk(int chunkX, int chunkZ, Block[] ablock, byte[] ameta) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        TimeAnalyzer.start("generateChunk");
        for (int x2 = Math.max(chunkX * 16, this.x - this.radius); x2 <= Math.min(chunkX * 16 + 15, this.x + this.radius); ++x2) {
            for (int y2 = this.y - this.radius; y2 <= this.y + this.radius; ++y2) {
                for (int z2 = Math.max(chunkZ * 16, this.z - this.radius); z2 <= Math.min(chunkZ * 16 + 15, this.z + this.radius); ++z2) {
                    int d = Planet.round(Planet.distance(this.x, this.y, this.z, x2, y2, z2));
                    if (d == this.radius) {
                        if (this.isBottomBlock(x2, y2, z2)) {
                            Planet.setBlock(x2, y2, z2, this.type.getBottomBlock(), 0, ablock, ameta);
                        } else if (this.isTopBlock(x2, y2, z2)) {
                            Planet.setBlock(x2, y2, z2, this.type.getTopBlock(), 0, ablock, ameta);
                        } else {
                            Planet.setBlock(x2, y2, z2, this.type.out, 0, ablock, ameta);
                        }
                    } else if (d < this.radius) {
                        Planet.setBlock(x2, y2, z2, this.type.in, 0, ablock, ameta);
                    }
                    this.generateSpecial(x2, y2, z2, ablock, ameta);
                }
            }
        }
        if (!this.finished.contains(new Point(chunkX, chunkZ))) {
            this.finished.add(new Point(chunkX, chunkZ));
        }
        if (this.unfinished.contains(new Point(chunkX, chunkZ))) {
            this.unfinished.remove(new Point(chunkX, chunkZ));
        }
        TimeAnalyzer.end("generateChunk");
    }

    public void decorateChunk(World world, int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        TimeAnalyzer.start("decorateChunk");
        for (int x2 = Math.max(chunkX * 16, this.x - this.radius); x2 <= Math.min(chunkX * 16 + 15, this.x + this.radius); ++x2) {
            for (int y2 = this.y - this.radius; y2 <= this.y + this.radius; ++y2) {
                for (int z2 = Math.max(chunkZ * 16, this.z - this.radius); z2 <= Math.min(chunkZ * 16 + 15, this.z + this.radius); ++z2) {
                    int i;
                    if (this.isTopBlock(x2, y2, z2)) {
                        int i2;
                        boolean flag2;
                        if (this.type == SAND && this.rand.nextDouble() <= 0.05 && Blocks.field_150434_aF.func_149742_c(world, x2, y2 + 1, z2)) {
                            for (i = 1; i <= 1 + this.rand.nextInt(3); ++i) {
                                world.func_147449_b(x2, y2 + i, z2, Blocks.field_150434_aF);
                            }
                            continue;
                        }
                        if (this.type != DIRT) continue;
                        if (this.rand.nextDouble() <= 0.1 && Blocks.field_150329_H.func_149742_c(world, x2, y2 + 1, z2)) {
                            world.func_147465_d(x2, y2 + 1, z2, (Block)Blocks.field_150329_H, 1, 3);
                            continue;
                        }
                        if (!(this.rand.nextDouble() <= 0.004)) continue;
                        boolean flag1 = world.func_147439_a(x2 + 1, y2, z2) == Blocks.field_150349_c && world.func_147439_a(x2 - 1, y2, z2) == Blocks.field_150349_c && world.func_147439_a(x2, y2, z2 + 1) == Blocks.field_150349_c && world.func_147439_a(x2, y2, z2 - 1) == Blocks.field_150349_c;
                        boolean bl = flag2 = world.func_147439_a(x2 + 1, y2 + 1, z2) == Blocks.field_150350_a && world.func_147439_a(x2 - 1, y2 + 1, z2) == Blocks.field_150350_a && world.func_147439_a(x2, y2 + 1, z2 + 1) == Blocks.field_150350_a && world.func_147439_a(x2, y2 + 1, z2 - 1) == Blocks.field_150350_a;
                        if (!flag1 || !flag2) continue;
                        world.func_147449_b(x2, y2, z2, Blocks.field_150355_j);
                        for (i2 = 1; i2 <= 1 + this.rand.nextInt(3); ++i2) {
                            world.func_147449_b(x2 + 1, y2 + i2, z2, Blocks.field_150436_aH);
                        }
                        for (i2 = 1; i2 <= 1 + this.rand.nextInt(3); ++i2) {
                            world.func_147449_b(x2 - 1, y2 + i2, z2, Blocks.field_150436_aH);
                        }
                        for (i2 = 1; i2 <= 1 + this.rand.nextInt(3); ++i2) {
                            world.func_147449_b(x2, y2 + i2, z2 + 1, Blocks.field_150436_aH);
                        }
                        for (i2 = 1; i2 <= 1 + this.rand.nextInt(3); ++i2) {
                            world.func_147449_b(x2, y2 + i2, z2 - 1, Blocks.field_150436_aH);
                        }
                        continue;
                    }
                    if (!this.isBottomBlock(x2, y2, z2) || this.type != WATER) continue;
                    if (x2 == this.x && z2 == this.z) {
                        world.func_147468_f(x2, y2, z2);
                        continue;
                    }
                    if (world.func_147439_a(x2, y2 + 1, z2) == Blocks.field_150355_j || world.func_147439_a(x2, y2 + 1, z2) == Blocks.field_150358_i) {
                        for (i = 1; i <= 1 + this.rand.nextInt(2); ++i) {
                            world.func_147449_b(x2, y2 + i, z2, Blocks.field_150435_aG);
                        }
                        continue;
                    }
                    if (world.func_147439_a(x2, y2 + 2, z2) != Blocks.field_150355_j && world.func_147439_a(x2, y2 + 2, z2) != Blocks.field_150358_i) continue;
                    for (i = 2; i <= 2 + this.rand.nextInt(2); ++i) {
                        world.func_147449_b(x2, y2 + i, z2, Blocks.field_150435_aG);
                    }
                }
            }
        }
        TimeAnalyzer.end("decorateChunk");
    }

    private void generateSpecial(int x, int y, int z, Block[] ablock, byte[] data) {
    }

    private boolean isTopBlock(int x2, int y2, int z2) {
        return Planet.round(Planet.distance(this.x, this.y, this.z, x2, y2, z2)) == this.radius && Planet.round(Planet.distance(this.x, this.y, this.z, x2, y2 + 1, z2)) > this.radius;
    }

    private boolean isBottomBlock(int x2, int y2, int z2) {
        return Planet.round(Planet.distance(this.x, this.y, this.z, x2, y2, z2)) == this.radius && Planet.round(Planet.distance(this.x, this.y, this.z, x2, y2 - 1, z2)) > this.radius;
    }

    public boolean shouldFinishChunk(int cx, int cz) {
        return this.unfinished.contains(new Point(cx, cz));
    }

    public boolean shouldDecorateChunk(int cx, int cz) {
        return this.finished.contains(new Point(cx, cz));
    }

    public boolean isAreaClear() {
        for (Planet p : this.chunkManager.unfinished) {
            if (!p.intersects(this)) continue;
            return false;
        }
        for (Planet p : this.chunkManager.finished) {
            if (!p.intersects(this)) continue;
            return false;
        }
        return true;
    }

    private boolean intersects(Planet planet) {
        return Planet.distance(planet.x, planet.y, planet.z, this.x, this.y, this.z) <= (double)(planet.radius + this.radius + 1);
    }

    public boolean isFinished() {
        return this.unfinished.size() == 0;
    }

    public static int getBlockNum(int x, int y, int z) {
        if (x < 0) {
            x = 16 + x;
        }
        if (z < 0) {
            z = 16 + z;
        }
        return y + z * 256 + x * 256 * 16;
    }

    public static void setBlock(int x, int y, int z, Block block, int meta, Block[] ablock, byte[] ameta) {
        if (y < 0 || y >= 256) {
            return;
        }
        ablock[Planet.getBlockNum((int)(x % 16), (int)y, (int)(z % 16))] = block;
        ameta[Planet.getBlockNum((int)(x % 16), (int)y, (int)(z % 16))] = (byte)meta;
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2));
    }

    public static int round(double d) {
        return (int)Math.round(d);
    }
}

