/*
 * Decompiled with CFR 0.152.
 */
package tennox.planetoid;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import tennox.planetoid.Option;
import tennox.planetoid.Planet;
import tennox.planetoid.Planetoid;
import tennox.planetoid.PlanetoidGeneratorInfo;
import tennox.planetoid.TimeAnalyzer;

public class PlanetoidChunkManager
extends WorldChunkManager
implements IChunkProvider {
    Random rand = new Random();
    long seed;
    World world;
    boolean mapFeaturesEnabled;
    private double[] noiseField;
    ArrayList<Planet> finished = new ArrayList();
    ArrayList<Planet> unfinished = new ArrayList();
    ArrayList<Point> pregen = new ArrayList();
    int pregenChunkSize = 4;
    PlanetoidGeneratorInfo generatorInfo;
    ChunkProviderGenerate defaultProvider;
    private MapGenBase caveGenerator = new MapGenCaves();
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private MapGenVillage villageGenerator = new MapGenVillage();
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private MapGenScatteredFeature scatteredFeatureGenerator = new MapGenScatteredFeature();
    private MapGenBase ravineGenerator = new MapGenRavine();
    private BiomeGenBase[] biomesForGeneration;

    public PlanetoidChunkManager(World w) {
        this(w, w.func_72905_C(), true, w.func_72912_H().func_82571_y());
    }

    public PlanetoidChunkManager(World w, long s, boolean mapfeatures, String generatorOptions) {
        super(w);
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)this.strongholdGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)this.villageGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)this.mineshaftGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)this.scatteredFeatureGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.world = w;
        this.seed = s;
        this.mapFeaturesEnabled = mapfeatures;
        this.defaultProvider = new ChunkProviderGenerate(w, w.func_72905_C(), mapfeatures);
        this.generatorInfo = PlanetoidGeneratorInfo.createGeneratorFromString(generatorOptions);
        if (!generatorOptions.equals("")) {
            Planetoid.logger.info("PlanetoidChunkManager initialized with these settings: \"" + this.generatorInfo.toString() + "\"");
        }
    }

    public boolean func_73149_a(int i, int j) {
        return true;
    }

    public Chunk func_73154_d(int par1, int par2) {
        TimeAnalyzer.start("provideChunk");
        this.rand.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        this.preGenerate(par1, par2);
        Block[] ablock = new Block[65536];
        byte[] abyte = new byte[65536];
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b((BiomeGenBase[])null, par1 * 16, par2 * 16, 16, 16);
        this.generatePlanetoid(par1, par2, ablock, abyte);
        TimeAnalyzer.start("provide_default");
        this.caveGenerator.func_151539_a((IChunkProvider)this, this.world, par1, par2, ablock);
        if (this.mapFeaturesEnabled) {
            this.villageGenerator.func_151539_a((IChunkProvider)this, this.world, par1, par2, ablock);
            this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.world, par1, par2, ablock);
            this.scatteredFeatureGenerator.func_151539_a((IChunkProvider)this, this.world, par1, par2, ablock);
        }
        TimeAnalyzer.end("provide_default");
        Chunk chunk = new Chunk(this.world, ablock, abyte, par1, par2);
        byte[] abyte1 = chunk.func_76605_m();
        for (int k = 0; k < abyte1.length; ++k) {
            abyte1[k] = (byte)this.biomesForGeneration[k].field_76756_M;
        }
        chunk.func_76603_b();
        TimeAnalyzer.end("provideChunk");
        return chunk;
    }

    public void preGenerate(int cx, int cz) {
        TimeAnalyzer.start("pregenerate");
        int x = PlanetoidChunkManager.round(cx / this.pregenChunkSize);
        int z = PlanetoidChunkManager.round(cz / this.pregenChunkSize);
        this.preGenerate2(x - 1, z - 1);
        this.preGenerate2(x - 1, z);
        this.preGenerate2(x - 1, z + 1);
        this.preGenerate2(x, z - 1);
        this.preGenerate2(x, z);
        this.preGenerate2(x, z + 1);
        this.preGenerate2(x + 1, z - 1);
        this.preGenerate2(x + 1, z);
        this.preGenerate2(x + 1, z + 1);
        TimeAnalyzer.end("pregenerate");
    }

    private void preGenerate2(int x, int z) {
        if (!this.pregen.contains(new Point(x, z))) {
            this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
            int x2 = x * this.pregenChunkSize * 16;
            int z2 = z * this.pregenChunkSize * 16;
            this.preGenerate_do(x2, z2, x2 + this.pregenChunkSize * 16, z2 + this.pregenChunkSize * 16);
            this.pregen.add(new Point(x, z));
        }
    }

    private void preGenerate_do(int x1, int z1, int x2, int z2) {
        TimeAnalyzer.start("pregenerate_do");
        for (int l = 0; l < Option.SPAWNTRIES.getValue(this.generatorInfo); ++l) {
            double z;
            double y;
            double min = Option.MIN_RADIUS.getValue(this.generatorInfo);
            double max = Option.MAX_RADIUS.getValue(this.generatorInfo);
            double r = PlanetoidChunkManager.round(this.rand.nextDouble() * (max - min) + min);
            double x = x1 + this.rand.nextInt(x2 - x1);
            Planet p = new Planet(this, this.world, x, y = (double)PlanetoidChunkManager.round(r + (256.0 - 2.0 * r) * this.rand.nextDouble()), z = (double)(z1 + this.rand.nextInt(z2 - z1)), (double)PlanetoidChunkManager.round(r));
            if (!p.isAreaClear()) continue;
            for (int i = PlanetoidChunkManager.round(x) - PlanetoidChunkManager.round(r); i <= PlanetoidChunkManager.round(x) + PlanetoidChunkManager.round(r); ++i) {
                for (int k = PlanetoidChunkManager.round(z) - PlanetoidChunkManager.round(r); k <= PlanetoidChunkManager.round(z) + PlanetoidChunkManager.round(r); ++k) {
                    int cz;
                    int cx = (int)Math.floor((double)i / 16.0);
                    if (p.unfinished.contains(new Point(cx, cz = (int)Math.floor((double)k / 16.0)))) continue;
                    p.unfinished.add(new Point(cx, cz));
                }
            }
            this.unfinished.add(p);
        }
        TimeAnalyzer.end("pregenerate_do");
    }

    public void generatePlanetoid(int chunkX, int chunkZ, Block[] ablock, byte[] ameta) {
        TimeAnalyzer.start("generate");
        TimeAnalyzer.start("finishPlanets");
        for (int i = 0; i < this.unfinished.size(); ++i) {
            Planet p = this.unfinished.get(i);
            if (p.shouldFinishChunk(chunkX, chunkZ)) {
                p.generateChunk(chunkX, chunkZ, ablock, ameta);
            }
            if (!p.isFinished()) continue;
            this.unfinished.remove(p);
            this.finished.add(p);
            --i;
        }
        TimeAnalyzer.end("finishPlanets");
        TimeAnalyzer.start("generateWater");
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 16; ++z) {
                    Planet.setBlock(x, y, z, y == 0 ? Blocks.field_150357_h : Blocks.field_150355_j, 0, ablock, ameta);
                }
            }
        }
        TimeAnalyzer.end("generateWater");
        TimeAnalyzer.end("generate");
    }

    public Chunk func_73158_c(int par1, int par2) {
        return this.func_73154_d(par1, par2);
    }

    public void func_73153_a(IChunkProvider ichunkprovider, int x, int z) {
        Planet p;
        int i;
        TimeAnalyzer.start("populate");
        for (i = 0; i < this.unfinished.size(); ++i) {
            p = this.unfinished.get(i);
            if (!p.shouldDecorateChunk(x, z)) continue;
            p.decorateChunk(this.world, x, z);
        }
        for (i = 0; i < this.finished.size(); ++i) {
            p = this.finished.get(i);
            if (!p.shouldDecorateChunk(x, z)) continue;
            p.decorateChunk(this.world, x, z);
        }
        TimeAnalyzer.start("populate2");
        if (this.generatorInfo.defaultGeneration) {
            this.defaultProvider.func_73153_a(ichunkprovider, x, z);
        }
        int k = x * 16;
        int l = z * 16;
        BiomeGenBase biomegenbase = this.world.func_72807_a(k + 16, l + 16);
        for (int s = 0; s < 0; ++s) {
            SpawnerAnimals.func_77191_a((World)this.world, (BiomeGenBase)biomegenbase, (int)(k + 8), (int)(l + 8), (int)16, (int)16, (Random)this.rand);
        }
        TimeAnalyzer.end("populate2");
        Chunk c = this.world.func_72964_e(x, z);
        c.func_76603_b();
        c.func_76594_o();
        TimeAnalyzer.end("populate");
    }

    public boolean func_73151_a(boolean flag, IProgressUpdate iprogressupdate) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "Planetoid";
    }

    public List<BiomeGenBase.SpawnListEntry> func_73155_a(EnumCreatureType type, int i, int j, int k) {
        ArrayList<BiomeGenBase.SpawnListEntry> list = new ArrayList<BiomeGenBase.SpawnListEntry>();
        if (type == EnumCreatureType.monster) {
            list.add(new BiomeGenBase.SpawnListEntry(EntitySpider.class, 10, 4, 4));
            list.add(new BiomeGenBase.SpawnListEntry(EntityZombie.class, 10, 4, 4));
            list.add(new BiomeGenBase.SpawnListEntry(EntitySkeleton.class, 10, 4, 4));
            list.add(new BiomeGenBase.SpawnListEntry(EntityCreeper.class, 10, 4, 4));
            list.add(new BiomeGenBase.SpawnListEntry(EntitySlime.class, 10, 4, 4));
            list.add(new BiomeGenBase.SpawnListEntry(EntityEnderman.class, 1, 1, 4));
        } else if (type == EnumCreatureType.creature) {
            list.add(new BiomeGenBase.SpawnListEntry(EntitySheep.class, 12, 4, 4));
        } else if (type == EnumCreatureType.waterCreature) {
            list.add(new BiomeGenBase.SpawnListEntry(EntitySquid.class, 10, 4, 4));
        }
        return list;
    }

    public ChunkPosition func_147416_a(World world, String s, int i, int j, int k) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int i, int j) {
    }

    public void func_76938_b() {
    }

    public static int round(double d) {
        return (int)Math.round(d);
    }

    public void func_104112_b() {
    }
}

