/*
 * Decompiled with CFR 0.152.
 */
package tennox.planetoid;

import tennox.planetoid.Option;

public class PlanetoidGeneratorInfo {
    boolean defaultGeneration;
    int min_radius;
    int max_radius;
    int spawntries;

    public static PlanetoidGeneratorInfo getDefaultGenerator() {
        PlanetoidGeneratorInfo info = new PlanetoidGeneratorInfo();
        info.defaultGeneration = true;
        info.min_radius = 5;
        info.max_radius = 15;
        info.spawntries = 15;
        return info;
    }

    public static PlanetoidGeneratorInfo createGeneratorFromString(String string) {
        String[] arr;
        PlanetoidGeneratorInfo info = PlanetoidGeneratorInfo.getDefaultGenerator();
        if (string.length() == 0) {
            return info;
        }
        for (String str : arr = string.split(";")) {
            String key = str.split("=")[0];
            String val = str.split("=")[1];
            if (key.equals("defgen")) {
                try {
                    info.defaultGeneration = Integer.parseInt(val) == 1;
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (key.equals("minrad")) {
                try {
                    Option.MIN_RADIUS.setValue(info, Integer.parseInt(val));
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (key.equals("maxrad")) {
                try {
                    Option.MAX_RADIUS.setValue(info, Integer.parseInt(val));
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (!key.equals("tries")) continue;
            try {
                Option.SPAWNTRIES.setValue(info, Integer.parseInt(val));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        Option.checkValues(info);
        return info;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("v=").append(1);
        builder.append(";defgen=").append(this.defaultGeneration ? 1 : 0);
        builder.append(";minrad=").append(this.min_radius);
        builder.append(";maxrad=").append(this.max_radius);
        builder.append(";tries=").append(this.spawntries);
        return builder.toString();
    }
}

