/*
 * Decompiled with CFR 0.152.
 */
package tennox.planetoid;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TimeAnalyzer {
    private static HashMap<String, Long> all = new HashMap();
    private static HashMap<String, Long> count = new HashMap();
    private static HashMap<String, Long> start = new HashMap();
    private static HashMap<String, Integer> max = new HashMap();
    static Lock lock = new ReentrantLock();

    public static void start(String s) {
        lock.lock();
        if (!all.containsKey(s)) {
            all.put(s, 0L);
            count.put(s, 1L);
        } else {
            if (!count.containsKey(s)) {
                count.put(s, 1L);
            }
            long co = count.get(s);
            count.remove(s);
            count.put(s, co + 1L);
        }
        start.put(s, System.currentTimeMillis());
        lock.unlock();
    }

    public static void end(String s) {
        lock.lock();
        if (!start.containsKey(s)) {
            lock.unlock();
            return;
        }
        long t = System.currentTimeMillis() - start.get(s);
        if (!count.containsKey(s)) {
            count.put(s, 1L);
        }
        long a = all.get(s);
        all.remove(s);
        all.put(s, a + t);
        if (!max.containsKey(s) || (long)max.get(s).intValue() < t) {
            max.put(s, (int)t);
        }
        start.remove(s);
        lock.unlock();
    }

    public static void print() {
        if (all.size() == 0) {
            System.out.println("----TimeAnalyzer EMPTY----");
            return;
        }
        System.out.println("----TimeAnalyzer----");
        Iterator<Map.Entry<String, Long>> iter = all.entrySet().iterator();
        while (iter.hasNext()) {
            String s = iter.next().getKey();
            System.out.println("TA: Section=" + s + "\tTime=" + all.get(s) + "ms\tCount=" + count.get(s) + "\tMax=" + max.get(s) + "ms\tAverage=" + TimeAnalyzer.getAverage(s) + "ms");
        }
        System.out.println("----TimeAnalyzer----");
    }

    public static void reset() {
        try {
            all.clear();
            count.clear();
            start.clear();
            max.clear();
        }
        catch (Exception e) {
            System.err.println("TA: wuaaat! " + e);
        }
    }

    public static double getAverage(String s) {
        double a = all.get(s).longValue();
        double c = count.get(s).longValue();
        return a / c;
    }
}

