/*
 * Decompiled with CFR 0.152.
 */
package universalcoins;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import universalcoins.UCItemPricer;
import universalcoins.UCTileEntity;
import universalcoins.UniversalCoins;

class BlockTradeStation
extends BlockContainer {
    private IIcon[] icons;

    public BlockTradeStation() {
        super(new Material(MapColor.field_151665_m));
        this.func_149711_c(3.0f);
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.setHarvestLevel("pickaxe", 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.icons = new IIcon[2];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = register.func_94245_a("universalcoins:" + this.func_149739_a().substring(5) + i);
        }
    }

    public IIcon func_149691_a(int par1, int par2) {
        if (par1 == 0 || par1 == 1) {
            return this.icons[1];
        }
        return this.icons[0];
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity == null || player.func_70093_af()) {
            return false;
        }
        player.openGui((Object)UniversalCoins.instance, 0, world, x, y, z);
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        this.dropItems(world, x, y, z);
        this.throwCoins(world, x, y, z);
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    private void throwCoins(World world, int x, int y, int z) {
        Random rand = new Random();
        UCTileEntity tileEntity = (UCTileEntity)world.func_147438_o(x, y, z);
        if (tileEntity == null) {
            return;
        }
        int sumLeft = tileEntity.coinSum;
        while (sumLeft > 0) {
            if (sumLeft <= 46656) {
                this.dropStack(world, x, y, z, UCItemPricer.getRevenueStack(sumLeft), rand);
                sumLeft = 0;
                continue;
            }
            this.dropStack(world, x, y, z, new ItemStack(UniversalCoins.itemCoinHeap, 64), rand);
            sumLeft -= 46656;
        }
    }

    private void dropStack(World world, int x, int y, int z, ItemStack item, Random rand) {
        float rx = rand.nextFloat() * 0.8f + 0.1f;
        float ry = rand.nextFloat() * 0.8f + 0.1f;
        float rz = rand.nextFloat() * 0.8f + 0.1f;
        EntityItem entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
        if (item.func_77942_o()) {
            entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
        }
        float factor = 0.05f;
        entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
        entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
        entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
        world.func_72838_d((Entity)entityItem);
        item.field_77994_a = 0;
    }

    private void dropItems(World world, int x, int y, int z) {
        Random rand = new Random();
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item == null || item.field_77994_a <= 0) continue;
            this.dropStack(world, x, y, z, item, rand);
        }
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new UCTileEntity();
    }
}

