/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests;

import aroma1997.betterchests.Upgrade;
import aroma1997.betterchests.UpgradeHelper;
import aroma1997.betterchests.api.IBetterChest;
import aroma1997.betterchests.api.IUpgrade;
import aroma1997.core.client.inventories.GUIContainer;
import aroma1997.core.inventories.ContainerBasic;
import aroma1997.core.inventories.ContainerItem;
import aroma1997.core.inventories.IAdvancedInventory;
import aroma1997.core.inventories.ISpecialInventory;
import aroma1997.core.util.FileUtil;
import aroma1997.core.util.ItemUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class BagInventory
implements IBetterChest,
IAdvancedInventory,
ISpecialInventory {
    private final ItemStack item;
    private long longTick = 0L;
    private ItemStack[] items;
    private String customName;
    private ArrayList<ItemStack> upgrades = new ArrayList();
    private int tick = new Random().nextInt(64);
    private EntityPlayer player;
    private static HashMap<ItemStack, BagInventory> invs = new HashMap();

    public BagInventory(ItemStack item) {
        this.item = item;
        if (item.func_77978_p() == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        this.readFromNBT(item.field_77990_d);
    }

    public ItemStack func_70301_a(int par1) {
        if (par1 >= this.items.length || par1 < 0 || this.isUpgradeInstalled(Upgrade.VOID.getItem())) {
            return null;
        }
        return this.items[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.items[par1] != null) {
            if (this.items[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.items[par1];
                this.items[par1] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.items[par1].func_77979_a(par2);
            if (this.items[par1].field_77994_a == 0) {
                this.items[par1] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.items[par1] != null) {
            ItemStack itemstack = this.items[par1];
            this.items[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.setStackInSlotWithoutNotify(par1, par2ItemStack);
        this.func_70296_d();
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "inv.betterchests:bag.name";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public int func_70302_i_() {
        return this.getAmountUpgrade(Upgrade.SLOT.getItem()) * 9 + 27;
    }

    public Slot getSlot(int slot, int index, int x, int y) {
        return new Slot((IInventory)this, index, x, y);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawGuiContainerForegroundLayer(GUIContainer gui, ContainerBasic container, int par1, int par2) {
        for (ItemStack item : this.upgrades) {
            if (UpgradeHelper.isUpgrade(item)) continue;
            ((IUpgrade)item.func_77973_b()).drawGuiContainerForegroundLayer((GuiContainer)gui, (Container)container, par1, par2, item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawGuiContainerBackgroundLayer(GUIContainer gui, ContainerBasic container, float f, int i, int j) {
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound nbttagcompound;
        for (Upgrade upgrade : Upgrade.values()) {
            int amount = nbt.func_74762_e(upgrade.toString());
            if (amount == 0) continue;
            this.setAmountUpgradeWithoutNotify(upgrade.getItem(), amount);
            nbt.func_82580_o(upgrade.toString());
        }
        NBTTagList list = nbt.func_150295_c("upgrades", (int)new NBTTagCompound().func_74732_a());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound upgradenbt = list.func_150305_b(i);
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)upgradenbt);
            this.upgrades.add(item);
        }
        if (nbt.func_74764_b("display") && (nbttagcompound = nbt.func_74775_l("display")).func_74764_b("Name")) {
            this.customName = nbttagcompound.func_74779_i("Name");
        }
        this.items = new ItemStack[this.func_70302_i_()];
        FileUtil.readFromNBT((IInventory)this, (NBTTagCompound)nbt);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        FileUtil.writeToNBT((IInventory)this, (NBTTagCompound)nbt);
        NBTTagList list = new NBTTagList();
        for (ItemStack item : this.upgrades) {
            NBTTagCompound upgradesbt = new NBTTagCompound();
            item.func_77955_b(upgradesbt);
            list.func_74742_a((NBTBase)upgradesbt);
        }
        nbt.func_74782_a("upgrades", (NBTBase)list);
    }

    public ContainerBasic getContainer(EntityPlayer player, int i) {
        return new ContainerItem(player.field_71071_by, (ISpecialInventory)this, i);
    }

    @Override
    public int getAmountUpgrade(ItemStack upgrade) {
        if (!UpgradeHelper.isUpgrade(upgrade)) {
            return 0;
        }
        for (ItemStack item : this.upgrades) {
            if (!ItemUtil.areItemsSameMatching((ItemStack)item, (ItemStack)upgrade, (ItemUtil.ItemMatchCriteria[])new ItemUtil.ItemMatchCriteria[]{ItemUtil.ItemMatchCriteria.ID, ItemUtil.ItemMatchCriteria.DAMAGE})) continue;
            return item.field_77994_a;
        }
        return 0;
    }

    @Override
    public boolean isUpgradeInstalled(ItemStack upgrade) {
        return this.getAmountUpgrade(upgrade) > 0;
    }

    @Override
    public void setAmountUpgrade(ItemStack upgrade, int amount) {
        this.setAmountUpgradeWithoutNotify(upgrade, amount);
        this.func_70296_d();
    }

    public void setAmountUpgradeWithoutNotify(ItemStack upgrade, int amount) {
        for (ItemStack item : this.upgrades) {
            if (!ItemUtil.areItemsSameMatching((ItemStack)item, (ItemStack)upgrade, (ItemUtil.ItemMatchCriteria[])new ItemUtil.ItemMatchCriteria[]{ItemUtil.ItemMatchCriteria.ID, ItemUtil.ItemMatchCriteria.DAMAGE, ItemUtil.ItemMatchCriteria.NBT})) continue;
            if (amount <= 0) {
                this.upgrades.remove(item);
                return;
            }
            item.field_77994_a = amount;
            return;
        }
        upgrade = upgrade.func_77946_l();
        upgrade.field_77994_a = amount;
        this.upgrades.add(upgrade);
    }

    @Override
    public boolean hasEnergy() {
        return this.isUpgradeInstalled(Upgrade.ENERGY.getItem());
    }

    public void onUpdate(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            // empty if block
        }
        if (this.tick-- <= 0) {
            this.tick = 64;
        }
        this.player = player;
        UpgradeHelper.updateChest(this, this.tick, player.field_70170_p);
    }

    public static BagInventory getInvForItem(ItemStack item) {
        if (!invs.containsKey(item)) {
            BagInventory inv = new BagInventory(item);
            invs.put(item, inv);
            return inv;
        }
        return invs.get(item);
    }

    public void setStackInSlotWithoutNotify(int slot, ItemStack item) {
        if (this.isUpgradeInstalled(Upgrade.VOID.getItem())) {
            return;
        }
        this.items[slot] = item;
        if (item != null && item.field_77994_a > this.func_70297_j_()) {
            item.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public double getXPos() {
        return this.player.field_70165_t;
    }

    @Override
    public double getYPos() {
        return this.player.field_70163_u + 1.0;
    }

    @Override
    public double getZPos() {
        return this.player.field_70161_v;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public ArrayList<ItemStack> getUpgrades() {
        return (ArrayList)this.upgrades.clone();
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void func_70296_d() {
        this.writeToNBT(this.item.field_77990_d);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public int getAmountUpgradeExact(ItemStack upgrade) {
        if (!UpgradeHelper.isUpgrade(upgrade)) {
            return 0;
        }
        for (ItemStack item : this.upgrades) {
            if (!ItemUtil.areItemsSameMatching((ItemStack)item, (ItemStack)upgrade, (ItemUtil.ItemMatchCriteria[])new ItemUtil.ItemMatchCriteria[]{ItemUtil.ItemMatchCriteria.ID, ItemUtil.ItemMatchCriteria.DAMAGE, ItemUtil.ItemMatchCriteria.NBT})) continue;
            return item.field_77994_a;
        }
        return 0;
    }

    @Override
    public long getLongTick() {
        return this.longTick;
    }

    @Override
    public int getXCoord() {
        return (int)this.getXPos();
    }

    @Override
    public int getYCoord() {
        return (int)this.getYPos();
    }

    @Override
    public int getZCoord() {
        return (int)this.getZPos();
    }

    @Override
    public boolean isUpgradeDisabled(ItemStack stack) {
        for (ItemStack item : this.upgrades) {
            if (!ItemUtil.areItemsSameMatching((ItemStack)item, (ItemStack)stack, (ItemUtil.ItemMatchCriteria[])new ItemUtil.ItemMatchCriteria[]{ItemUtil.ItemMatchCriteria.ID, ItemUtil.ItemMatchCriteria.DAMAGE})) continue;
            return item.func_77942_o() && item.field_77990_d.func_74764_b("disabled");
        }
        return false;
    }

    @Override
    public void setUpgradeDisabled(ItemStack stack, boolean value) {
        if (this.isUpgradeInstalled(stack)) {
            for (ItemStack item : this.upgrades) {
                if (!ItemUtil.areItemsSameMatching((ItemStack)item, (ItemStack)stack, (ItemUtil.ItemMatchCriteria[])new ItemUtil.ItemMatchCriteria[]{ItemUtil.ItemMatchCriteria.ID, ItemUtil.ItemMatchCriteria.DAMAGE})) continue;
                if (value) {
                    if (!item.func_77942_o()) {
                        item.func_77982_d(new NBTTagCompound());
                    }
                    item.field_77990_d.func_74757_a("disabled", true);
                    this.func_70296_d();
                    return;
                }
                if (item.func_77942_o() && item.field_77990_d.func_74764_b("disabled")) {
                    item.field_77990_d.func_82580_o("disabled");
                    if (item.field_77990_d.func_82582_d()) {
                        item.field_77990_d = null;
                    }
                }
                this.func_70296_d();
                return;
            }
        }
    }
}

