/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests;

import aroma1997.betterchests.BetterChests;
import aroma1997.betterchests.ContainerUpgrades;
import aroma1997.betterchests.Upgrade;
import aroma1997.betterchests.UpgradeHelper;
import aroma1997.betterchests.api.IBetterChest;
import aroma1997.betterchests.api.IUpgrade;
import aroma1997.core.client.inventories.GUIContainer;
import aroma1997.core.inventories.AromaContainer;
import aroma1997.core.inventories.ContainerBasic;
import aroma1997.core.inventories.IAdvancedInventory;
import aroma1997.core.inventories.ISpecialInventory;
import aroma1997.core.inventories.Inventories;
import aroma1997.core.items.wrench.IAromaWrenchable;
import aroma1997.core.util.FileUtil;
import aroma1997.core.util.ItemUtil;
import aroma1997.core.util.ServerUtil;
import aroma1997.core.util.Util;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBChest
extends TileEntity
implements IBetterChest,
ISpecialInventory,
IAromaWrenchable,
IAdvancedInventory {
    UUID player;
    private int tick;
    private long longTick;
    private EntityPlayer fplayer;
    private int ticksSinceSync = -1;
    private ArrayList<ItemStack> upgrades = new ArrayList();
    private boolean firstTick = true;
    private int numUsingPlayers;
    public float prevLidAngle;
    public float lidAngle;
    private ItemStack[] items;

    public TileEntityBChest() {
        this.tick = new Random().nextInt(64);
        this.items = new ItemStack[27];
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 0 || slot >= this.items.length) {
            return null;
        }
        return this.items[slot];
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.doNormalChestUpdate();
        if (this.firstTick) {
            if (!this.field_145850_b.field_72995_K) {
                this.fplayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)new GameProfile(null, "Aroma1997BetterChests"));
                this.fplayer.field_70165_t = this.field_145851_c;
                this.fplayer.field_70163_u = this.field_145848_d;
                this.fplayer.field_70161_v = this.field_145849_e;
            }
            this.firstTick = false;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        UpgradeHelper.updateChest(this, this.tick, this.field_145850_b);
        ++this.longTick;
        if (this.tick-- <= 0) {
            this.tick = 64;
            this.func_70296_d();
        }
        if (this.isUpgradeInstalled(Upgrade.TICKING.getItem()) && this.tick % 8 == 0) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                ItemStack item = this.func_70301_a(i);
                if (item == null || item.func_77973_b() == null) continue;
                this.fplayer.field_71071_by.field_70462_a[0] = this.func_70301_a(i);
                this.fplayer.field_71071_by.func_70296_d();
                item.func_77973_b().func_77663_a(item, this.field_145850_b, (Entity)this.fplayer, 0, false);
                this.func_70296_d();
            }
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        S35PacketUpdateTileEntity packet = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g, nbt);
        return packet;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public int func_70302_i_() {
        return this.getAmountUpgrade(Upgrade.SLOT.getItem()) * 9 + 27;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        if (!this.isUpgradeInstalled(Upgrade.PLAYER.getItem()) || par1EntityPlayer == null) {
            return true;
        }
        if (par1EntityPlayer.field_70170_p.field_72995_K) {
            return false;
        }
        if (!MinecraftServer.func_71276_C().func_71262_S() && par1EntityPlayer.func_70005_c_().equalsIgnoreCase(Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
            return true;
        }
        return ServerUtil.isPlayerAdmin((String)par1EntityPlayer.func_70005_c_()) || this.player != null && this.player.equals(par1EntityPlayer.func_110124_au());
    }

    public boolean upgrade(EntityPlayer player) {
        if (player == null || !this.func_70300_a(player)) {
            return false;
        }
        ItemStack itemUpgrade = player.func_70694_bm();
        if (itemUpgrade == null || !UpgradeHelper.isUpgrade(itemUpgrade)) {
            return false;
        }
        if (!UpgradeHelper.areRequirementsInstalled(this, itemUpgrade)) {
            return false;
        }
        IUpgrade upgrade = (IUpgrade)itemUpgrade.func_77973_b();
        if (upgrade.canChestTakeUpgrade(itemUpgrade) && UpgradeHelper.areRequirementsInstalled(this, itemUpgrade) && upgrade.getMaxUpgrades(itemUpgrade) > this.getAmountUpgrade(itemUpgrade)) {
            this.setAmountUpgrade(itemUpgrade, this.getAmountUpgrade(itemUpgrade) + 1);
            if (ItemUtil.areItemsSameMatching((ItemStack)itemUpgrade, (ItemStack)Upgrade.PLAYER.getItem(), (ItemUtil.ItemMatchCriteria[])new ItemUtil.ItemMatchCriteria[]{ItemUtil.ItemMatchCriteria.ID, ItemUtil.ItemMatchCriteria.DAMAGE})) {
                this.player = player.func_110124_au();
            }
            this.onUpgradeInserted(player);
            return true;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.upgrades.clear();
        for (Upgrade upgrade : Upgrade.values()) {
            int amount = nbt.func_74762_e(upgrade.toString());
            if (amount == 0) continue;
            this.setAmountUpgrade(upgrade.getItem(), amount);
        }
        NBTTagList list = nbt.func_150295_c("upgrades", (int)new NBTTagCompound().func_74732_a());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound upgradenbt = list.func_150305_b(i);
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)upgradenbt);
            this.upgrades.add(item);
        }
        this.items = new ItemStack[this.func_70302_i_()];
        FileUtil.readFromNBT((IInventory)this, (NBTTagCompound)nbt);
        if (nbt.func_74781_a("player") != null && nbt.func_74781_a("player") instanceof NBTTagString) {
            this.player = Util.getUUID((String)nbt.func_74779_i("player"));
        }
        this.player = UUID.fromString(nbt.func_74779_i("playerUUID"));
        super.func_145839_a(nbt);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74778_a("playerUUID", this.player.toString());
        FileUtil.writeToNBT((IInventory)this, (NBTTagCompound)nbt);
        NBTTagList list = new NBTTagList();
        for (ItemStack item : this.upgrades) {
            NBTTagCompound upgradesbt = new NBTTagCompound();
            item.func_77955_b(upgradesbt);
            list.func_74742_a((NBTBase)upgradesbt);
        }
        nbt.func_74782_a("upgrades", (NBTBase)list);
    }

    private void onUpgradeInserted(EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            --player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].field_77994_a;
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        this.func_145839_a(nbttagcompound);
        this.func_70296_d();
    }

    public int getLightValue() {
        return this.isUpgradeInstalled(Upgrade.LIGHT.getItem()) ? 15 : 0;
    }

    public int getComparatorOutput() {
        if (!this.isUpgradeInstalled(Upgrade.COMPARATOR.getItem())) {
            return 0;
        }
        return Container.func_94526_b((IInventory)this);
    }

    public ItemStack[] getItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            list.add(this.func_70301_a(i));
        }
        return list.toArray(new ItemStack[list.size()]);
    }

    @Override
    public boolean hasEnergy() {
        return this.isUpgradeInstalled(Upgrade.ENERGY.getItem());
    }

    @Override
    public double getXPos() {
        return (float)this.field_145851_c + 0.5f;
    }

    @Override
    public double getYPos() {
        return (float)this.field_145848_d + 0.5f;
    }

    @Override
    public double getZPos() {
        return (float)this.field_145849_e + 0.5f;
    }

    public int getRedstoneOutput() {
        return MathHelper.func_76125_a((int)this.numUsingPlayers, (int)0, (int)15);
    }

    private void doNormalChestUpdate() {
        float f;
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.numUsingPlayers != 0 && (this.ticksSinceSync + this.field_145851_c + this.field_145848_d + this.field_145849_e) % 200 == 0) {
            this.numUsingPlayers = 0;
            f = 5.0f;
            List list = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - f), (double)((float)this.field_145848_d - f), (double)((float)this.field_145849_e - f), (double)((float)(this.field_145851_c + 1) + f), (double)((float)(this.field_145848_d + 1) + f), (double)((float)(this.field_145849_e + 1) + f)));
            for (EntityPlayer entityplayer : list) {
                ISpecialInventory iinventory;
                if (!(entityplayer.field_71070_bA instanceof ContainerBasic) || (iinventory = ((ContainerBasic)entityplayer.field_71070_bA).inv) != this) continue;
                ++this.numUsingPlayers;
            }
        }
        this.prevLidAngle = this.lidAngle;
        f = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)this.field_145851_c + 0.5;
            double d2 = (double)this.field_145849_e + 0.5;
            this.field_145850_b.func_72908_a(d1, (double)this.field_145848_d + 0.5, d2, "betterchests:chest.bchestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                double d2 = (double)this.field_145851_c + 0.5;
                double d0 = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(d2, (double)this.field_145848_d + 0.5, d0, "betterchests:chest.bchestclose", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.items[par1] != null) {
            if (this.items[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.items[par1];
                this.items[par1] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.items[par1].func_77979_a(par2);
            if (this.items[par1].field_77994_a == 0) {
                this.items[par1] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (i < 0 || i >= this.items.length || this.isUpgradeInstalled(Upgrade.VOID.getItem())) {
            return null;
        }
        return this.items[i];
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.setStackInSlotWithoutNotify(i, itemstack);
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public boolean func_145842_c(int par1, int par2) {
        if (par1 == 1) {
            this.numUsingPlayers = par2;
            return true;
        }
        return super.func_145842_c(par1, par2);
    }

    @Override
    public int getAmountUpgrade(ItemStack upgrade) {
        if (!UpgradeHelper.isUpgrade(upgrade)) {
            return 0;
        }
        for (ItemStack item : this.upgrades) {
            if (!ItemUtil.areItemsSameMatching((ItemStack)item, (ItemStack)upgrade, (ItemUtil.ItemMatchCriteria[])new ItemUtil.ItemMatchCriteria[]{ItemUtil.ItemMatchCriteria.ID, ItemUtil.ItemMatchCriteria.DAMAGE})) continue;
            return item.field_77994_a;
        }
        return 0;
    }

    @Override
    public boolean isUpgradeInstalled(ItemStack upgrade) {
        return this.getAmountUpgrade(upgrade) > 0;
    }

    @Override
    public void setAmountUpgrade(ItemStack upgrade, int amount) {
        for (ItemStack item : this.upgrades) {
            if (!ItemUtil.areItemsSameMatching((ItemStack)item, (ItemStack)upgrade, (ItemUtil.ItemMatchCriteria[])new ItemUtil.ItemMatchCriteria[]{ItemUtil.ItemMatchCriteria.ID, ItemUtil.ItemMatchCriteria.DAMAGE, ItemUtil.ItemMatchCriteria.NBT})) continue;
            if (amount <= 0) {
                this.upgrades.remove(item);
                return;
            }
            item.field_77994_a = amount;
            return;
        }
        upgrade = upgrade.func_77946_l();
        upgrade.field_77994_a = amount;
        this.upgrades.add(upgrade);
    }

    public Slot getSlot(int slot, int index, int x, int y) {
        return new Slot((IInventory)this, index, x, y);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawGuiContainerForegroundLayer(GUIContainer gui, ContainerBasic container, int par1, int par2) {
        for (ItemStack item : this.upgrades) {
            if (!UpgradeHelper.isUpgrade(item)) continue;
            ((IUpgrade)item.func_77973_b()).drawGuiContainerForegroundLayer((GuiContainer)gui, (Container)container, par1, par2, item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawGuiContainerBackgroundLayer(GUIContainer gui, ContainerBasic container, float f, int i, int j) {
    }

    public ItemStack getDroppedFullItem() {
        ItemStack item = new ItemStack((Block)BetterChests.chest);
        item.func_77982_d(new NBTTagCompound());
        this.func_145841_b(item.field_77990_d);
        return item;
    }

    public static TileEntityBChest loadTEFromNBT(NBTTagCompound nbt) {
        TileEntityBChest te = new TileEntityBChest();
        te.func_145839_a(nbt);
        return te;
    }

    public AromaContainer getContainer(EntityPlayer player, int i) {
        if (i == Inventories.ID_GUI_BLOCK) {
            return new ContainerBasic(player.field_71071_by, (ISpecialInventory)this);
        }
        return new ContainerUpgrades(this, player);
    }

    @Override
    public ArrayList<ItemStack> getUpgrades() {
        return (ArrayList)this.upgrades.clone();
    }

    public String func_145825_b() {
        return "inv.betterchests:chest.name";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
        ++this.numUsingPlayers;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
    }

    public void func_70305_f() {
        --this.numUsingPlayers;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
    }

    public boolean onWrenchUsed(ItemStack wrench, EntityPlayer player, ForgeDirection side) {
        Inventories.openContainerTileEntity((EntityPlayer)player, (TileEntity)this, (boolean)false);
        return true;
    }

    public boolean canPickup(ItemStack wrench, EntityPlayer player, ForgeDirection side) {
        return true;
    }

    @Override
    public int getAmountUpgradeExact(ItemStack upgrade) {
        if (!UpgradeHelper.isUpgrade(upgrade)) {
            return 0;
        }
        for (ItemStack item : this.upgrades) {
            if (!ItemUtil.areItemsSameMatching((ItemStack)item, (ItemStack)upgrade, (ItemUtil.ItemMatchCriteria[])new ItemUtil.ItemMatchCriteria[]{ItemUtil.ItemMatchCriteria.ID, ItemUtil.ItemMatchCriteria.DAMAGE, ItemUtil.ItemMatchCriteria.NBT})) continue;
            return item.field_77994_a;
        }
        return 0;
    }

    @Override
    public long getLongTick() {
        return this.longTick;
    }

    @Override
    public int getXCoord() {
        return this.field_145851_c;
    }

    @Override
    public int getYCoord() {
        return this.field_145848_d;
    }

    @Override
    public int getZCoord() {
        return this.field_145849_e;
    }

    public ItemStack shouldBeExact() {
        return null;
    }

    @Override
    public boolean isUpgradeDisabled(ItemStack stack) {
        for (ItemStack item : this.upgrades) {
            if (!ItemUtil.areItemsSameMatching((ItemStack)item, (ItemStack)stack, (ItemUtil.ItemMatchCriteria[])new ItemUtil.ItemMatchCriteria[]{ItemUtil.ItemMatchCriteria.ID, ItemUtil.ItemMatchCriteria.DAMAGE})) continue;
            return item.func_77942_o() && item.field_77990_d.func_74764_b("disabled");
        }
        return false;
    }

    @Override
    public void setUpgradeDisabled(ItemStack stack, boolean value) {
        if (this.isUpgradeInstalled(stack)) {
            for (ItemStack item : this.upgrades) {
                if (!ItemUtil.areItemsSameMatching((ItemStack)item, (ItemStack)stack, (ItemUtil.ItemMatchCriteria[])new ItemUtil.ItemMatchCriteria[]{ItemUtil.ItemMatchCriteria.ID, ItemUtil.ItemMatchCriteria.DAMAGE})) continue;
                if (value) {
                    if (!item.func_77942_o()) {
                        item.func_77982_d(new NBTTagCompound());
                    }
                    item.field_77990_d.func_74757_a("disabled", true);
                    this.func_70296_d();
                    return;
                }
                if (item.func_77942_o() && item.field_77990_d.func_74764_b("disabled")) {
                    item.field_77990_d.func_82580_o("disabled");
                    if (item.field_77990_d.func_82582_d()) {
                        item.field_77990_d = null;
                    }
                }
                this.func_70296_d();
                return;
            }
        }
    }

    public void setStackInSlotWithoutNotify(int i, ItemStack itemstack) {
        if (i < 0 || i >= this.items.length || this.isUpgradeInstalled(Upgrade.VOID.getItem())) {
            return;
        }
        this.items[i] = itemstack;
    }
}

