/*
 * Decompiled with CFR 0.152.
 */
package fr.elias.fakeores.common;

import fr.elias.fakeores.common.EntityDangerousPlant;
import fr.elias.fakeores.common.EntityRegenEgg;
import fr.elias.fakeores.common.FakeOres;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityNopeGrenade
extends EntityItem {
    protected double bounceFactor = 0.15;
    protected double bounceSlowFactor = 0.8;
    protected int fuse;
    protected boolean exploded;
    protected double initialVelocity = 1.0;
    protected static final int FUSE_LENGTH = 50;
    protected static final double MIN_BOUNCE_SOUND_VELOCITY = 0.1;
    private static final int MAX_DIAMETER_TIME = 250;
    private static final double MAX_DIAMETER = 8.0;
    public int smokedTime;
    public ItemStack item;

    public EntityNopeGrenade(World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
        this.exploded = false;
        this.fuse = 80;
        this.field_70129_M = 0.0f;
        this.smokedTime = 500;
        this.item = new ItemStack(FakeOres.nopeGrenade);
    }

    public ItemStack func_92059_d() {
        return this.item;
    }

    public EntityNopeGrenade(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1, d2);
    }

    public EntityNopeGrenade(World world, EntityLivingBase entityliving) {
        this(world);
        this.func_70082_c(entityliving.field_70177_z, 0.0f);
        double d = -MathHelper.func_76126_a((float)(entityliving.field_70177_z * (float)Math.PI / 180.0f));
        double d1 = MathHelper.func_76134_b((float)(entityliving.field_70177_z * (float)Math.PI / 180.0f));
        this.field_70159_w = this.initialVelocity * d * (double)MathHelper.func_76134_b((float)(entityliving.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -this.initialVelocity * (double)MathHelper.func_76126_a((float)(entityliving.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = this.initialVelocity * d1 * (double)MathHelper.func_76134_b((float)(entityliving.field_70125_A / 180.0f * (float)Math.PI));
        if (entityliving.field_70154_o != null && entityliving.field_70154_o instanceof EntityLiving) {
            entityliving = (EntityLiving)entityliving.field_70154_o;
        }
        this.field_70159_w += entityliving.field_70159_w;
        this.field_70181_x += entityliving.field_70122_E ? 0.0 : entityliving.field_70181_x;
        this.field_70179_y += entityliving.field_70179_y;
        this.func_70107_b(entityliving.field_70165_t + d * 0.8, entityliving.field_70163_u + (double)entityliving.func_70047_e(), entityliving.field_70161_v + d1 * 0.8);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
    }

    public boolean func_70112_a(double d) {
        return true;
    }

    public void func_70071_h_() {
        double d = this.field_70159_w;
        double d1 = this.field_70181_x;
        double d2 = this.field_70179_y;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        boolean flag = false;
        List list = this.field_70170_p.func_72872_a(EntityCreature.class, AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)(this.field_70165_t + 1.0), (double)(this.field_70163_u + 1.0), (double)(this.field_70161_v + 1.0)).func_72314_b(1.0, 1.0, 1.0));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(list.isEmpty() || entity instanceof EntityPlayer || entity instanceof EntityDangerousPlant || entity instanceof EntityRegenEgg)) {
                entity.func_70078_a((Entity)this);
                entity.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                entity.field_70177_z = this.getRandom(0, 360);
                entity.field_70125_A = this.getRandom(0, 180);
            }
            this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t + (double)this.field_70146_Z.nextInt(2), this.field_70163_u + (double)this.field_70146_Z.nextInt(2), this.field_70161_v + (double)this.field_70146_Z.nextInt(2), 0.0, 0.0, 0.0);
        }
        if (this.field_70159_w == 0.0 && d != 0.0) {
            this.field_70159_w = -this.bounceFactor * d;
            this.field_70181_x = this.bounceSlowFactor * d1;
            this.field_70179_y = this.bounceSlowFactor * d2;
            if (Math.abs(d) > 0.1) {
                flag = true;
            }
        }
        if (this.field_70181_x == 0.0 && d1 != 0.0) {
            this.field_70159_w = this.bounceSlowFactor * d;
            this.field_70181_x = -this.bounceFactor * d1;
            this.field_70179_y = this.bounceSlowFactor * d2;
            if (Math.abs(d1) > 0.1) {
                flag = true;
            }
        }
        if (this.field_70179_y == 0.0 && d2 != 0.0) {
            this.field_70159_w = this.bounceSlowFactor * d;
            this.field_70181_x = this.bounceSlowFactor * d1;
            this.field_70179_y = -this.bounceFactor * d2;
            if (Math.abs(d2) > 0.1) {
                flag = true;
            }
        }
        if (flag) {
            this.handleBounce();
        }
        this.field_70181_x -= 0.04;
        this.field_70159_w *= 0.99;
        this.field_70181_x *= 0.99;
        this.field_70179_y *= 0.99;
        if (this.smokedTime > 0) {
            --this.smokedTime;
        }
        this.part(this.field_70170_p, this);
        this.handleExplode();
    }

    public int getRandom(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    protected void handleBounce() {
        this.field_70170_p.func_72956_a((Entity)this, "mob.villager.hit", 0.25f, 1.0f / (this.field_70146_Z.nextFloat() * 0.1f + 0.95f));
    }

    protected void handleExplode() {
        if (this.fuse-- <= 0) {
            this.explode();
        }
    }

    protected void part(World worldObj, EntityNopeGrenade entity) {
        for (int i = 0; i < 20; ++i) {
            double d = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d3 = 10.0;
            if (this.smokedTime <= 0 || !worldObj.field_72995_K || this.field_70146_Z.nextInt(10) != 0) continue;
            FakeOres.proxy.spawnParticle(worldObj, "nope", entity.field_70165_t + (double)(this.field_70146_Z.nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N - d * d3, entity.field_70163_u + (double)(this.field_70146_Z.nextFloat() * entity.field_70131_O) - d1 * d3, entity.field_70161_v + (double)(this.field_70146_Z.nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N - d2 * d3);
        }
    }

    protected void explode() {
        if (!this.exploded) {
            this.exploded = true;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.85f, true);
            }
            this.func_70106_y();
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74774_a("Fuse", (byte)this.fuse);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.fuse = nbttagcompound.func_74771_c("Fuse");
    }

    public void func_70100_b_(EntityPlayer entityplayer) {
        entityplayer.field_70181_x += 0.1;
    }

    public float func_70047_e() {
        return this.field_70131_O;
    }
}

