/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.multimine.common;

import atomicstryker.ForgePacketWrapper;
import atomicstryker.multimine.common.MultiMine;
import atomicstryker.multimine.common.PartiallyMinedBlock;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.server.MinecraftServer;

public class MultiMineServer {
    private static MultiMineServer instance;
    private static MinecraftServer serverInstance;
    private HashMap partiallyMinedBlocksListByDimension = Maps.newHashMap();
    private HashSet registeredMultiMineUsers = Sets.newHashSet();
    private BlockRegenQueue blockRegenQueue;

    public MultiMineServer() {
        instance = this;
        this.blockRegenQueue = new BlockRegenQueue(30, new BlockAgeComparator());
        serverInstance = FMLCommonHandler.instance().getMinecraftServerInstance();
        TickRegistry.registerTickHandler((ITickHandler)new ServerTickHandler(), (Side)Side.SERVER);
    }

    public static MultiMineServer instance() {
        return instance;
    }

    public void onClientSentPartialBlockPacket(qx player, int x, int y, int z, int dim) {
        int dimension = player.aq;
        List partiallyMinedBlocks = this.getPartiallyMinedBlocksForDimension(dimension);
        if (partiallyMinedBlocks == null) {
            partiallyMinedBlocks = Lists.newArrayList();
            this.partiallyMinedBlocksListByDimension.put(dimension, partiallyMinedBlocks);
        }
        PartiallyMinedBlock newblock = new PartiallyMinedBlock(x, y, z, dimension);
        newblock.setLastTimeMined(System.currentTimeMillis() + MultiMine.instance().getInitialBlockRegenDelay());
        for (int i = 0; i < partiallyMinedBlocks.size(); ++i) {
            PartiallyMinedBlock iterBlock = (PartiallyMinedBlock)partiallyMinedBlocks.get(i);
            if (!iterBlock.equals(newblock)) continue;
            iterBlock.advanceProgress();
            iterBlock.setLastTimeMined(System.currentTimeMillis() + MultiMine.instance().getInitialBlockRegenDelay());
            this.sendPartiallyMinedBlockUpdateToAllPlayers(iterBlock);
            if (iterBlock.isFinished()) {
                player.p.g(player.k, x, y, z, -1);
                int blockID = player.p.a(x, y, z);
                PacketDispatcher.sendPacketToAllAround((double)x, (double)y, (double)z, (double)30.0, (int)dimension, (ef)new fi(x, y, z, player.p));
                amq block = amq.p[blockID];
                if (block != null) {
                    int meta = player.p.h(x, y, z);
                    if (block.removeBlockByPlayer(player.p, player, x, y, z)) {
                        block.c(player.p, x, y, z, meta);
                        this.onBlockMineFinishedDamagePlayerItem(player, blockID, x, y, z);
                        if (block.canHarvestBlock(player, meta)) {
                            block.a(player.p, player, x, y, z, meta);
                        }
                    }
                }
                partiallyMinedBlocks.remove(iterBlock);
                this.blockRegenQueue.remove(iterBlock);
            }
            this.blockRegenQueue.offer(iterBlock);
            return;
        }
        if (partiallyMinedBlocks.size() > 29) {
            PartiallyMinedBlock old = (PartiallyMinedBlock)partiallyMinedBlocks.get(0);
            this.sendPartiallyMinedBlockDeleteCommandToAllPlayers(old);
            partiallyMinedBlocks.remove(old);
            this.blockRegenQueue.remove(old);
        }
        partiallyMinedBlocks.add(newblock);
        this.blockRegenQueue.offer(newblock);
        this.sendPartiallyMinedBlockUpdateToAllPlayers(newblock);
    }

    private void onBlockMineFinishedDamagePlayerItem(qx player, int blockID, int x, int y, int z) {
        ur itemStack = player.bS();
        if (itemStack != null) {
            itemStack.a(player.p, blockID, x, y, z, player);
            if (itemStack.a == 0) {
                player.bT();
            }
        }
    }

    private void sendPartiallyMinedBlockDeleteCommandToAllPlayers(PartiallyMinedBlock block) {
        Object[] toSend = new Object[]{block.getX(), block.getY(), block.getZ(), block.getProgress()};
        PacketDispatcher.sendPacketToAllAround((double)block.getX(), (double)block.getY(), (double)block.getZ(), (double)30.0, (int)block.getDimension(), (ef)ForgePacketWrapper.createPacket("AS_MM", 2, toSend));
    }

    public void onPlayerLoggedIn(Player player) {
        int dimension = ((qx)player).p.K().j();
        List partiallyMinedBlocks = this.getPartiallyMinedBlocksForDimension(dimension);
        this.registeredMultiMineUsers.add(((qx)player).k);
        if (partiallyMinedBlocks != null) {
            for (PartiallyMinedBlock block : partiallyMinedBlocks) {
                this.sendPartiallyMinedBlockToPlayer(player, block);
            }
        }
        Object[] toSend = new Object[]{MultiMine.instance().getExcludedBlocksString()};
        PacketDispatcher.sendPacketToPlayer((ef)ForgePacketWrapper.createPacket("AS_MM", 3, toSend), (Player)player);
        Object[] toSend2 = new Object[]{MultiMine.instance().getExcludedItemssString()};
        PacketDispatcher.sendPacketToPlayer((ef)ForgePacketWrapper.createPacket("AS_MM", 4, toSend2), (Player)player);
    }

    private List getPartiallyMinedBlocksForDimension(int dim) {
        return (List)this.partiallyMinedBlocksListByDimension.get(dim);
    }

    private void sendPartiallyMinedBlockUpdateToAllPlayers(PartiallyMinedBlock block) {
        Object[] toSend = new Object[]{block.getX(), block.getY(), block.getZ(), block.getProgress()};
        PacketDispatcher.sendPacketToAllAround((double)block.getX(), (double)block.getY(), (double)block.getZ(), (double)30.0, (int)block.getDimension(), (ef)ForgePacketWrapper.createPacket("AS_MM", 1, toSend));
    }

    private void sendPartiallyMinedBlockToPlayer(Player p, PartiallyMinedBlock block) {
        Object[] toSend = new Object[]{block.getX(), block.getY(), block.getZ(), block.getProgress()};
        PacketDispatcher.sendPacketToPlayer((ef)ForgePacketWrapper.createPacket("AS_MM", 1, toSend), (Player)p);
    }

    public boolean getShouldIgnoreBlockDigPacket(int playerId, ei packet) {
        return false;
    }

    public void unRegisterMultiMineClient(int playerId) {
        if (this.registeredMultiMineUsers.contains(playerId)) {
            this.registeredMultiMineUsers.remove(playerId);
        }
    }

    private class BlockAgeComparator
    implements Comparator {
        private BlockAgeComparator() {
        }

        public int compare(PartiallyMinedBlock b1, PartiallyMinedBlock b2) {
            if (b1.getLastTimeMined() < b2.getLastTimeMined()) {
                return -1;
            }
            return 1;
        }
    }

    private class BlockRegenQueue
    extends PriorityQueue {
        public BlockRegenQueue(int initialSize, Comparator comparator) {
            super(initialSize, comparator);
        }

        @Override
        public boolean offer(PartiallyMinedBlock block) {
            if (this.contains(block)) {
                this.remove(block);
            }
            return super.offer(block);
        }
    }

    private class ServerTickHandler
    implements ITickHandler {
        private final EnumSet tickTypes = EnumSet.of(TickType.WORLD);

        private ServerTickHandler() {
        }

        public void tickStart(EnumSet type, Object ... tickData) {
        }

        public void tickEnd(EnumSet type, Object ... tickData) {
            if (MultiMineServer.this.blockRegenQueue.isEmpty()) {
                return;
            }
            PartiallyMinedBlock block = null;
            Iterator iter = MultiMineServer.this.blockRegenQueue.iterator();
            while (iter.hasNext()) {
                block = (PartiallyMinedBlock)iter.next();
                if (!this.isBlockGone(block)) continue;
                MultiMineServer.this.sendPartiallyMinedBlockDeleteCommandToAllPlayers(block);
                MultiMineServer.this.getPartiallyMinedBlocksForDimension(block.getDimension()).remove(block);
                iter.remove();
            }
            if (MultiMineServer.this.blockRegenQueue.isEmpty() || !MultiMine.instance().getBlockRegenEnabled()) {
                return;
            }
            long curTime = System.currentTimeMillis();
            if (((PartiallyMinedBlock)MultiMineServer.this.blockRegenQueue.peek()).getLastTimeMined() + MultiMine.instance().getBlockRegenInterval() < curTime) {
                block = (PartiallyMinedBlock)MultiMineServer.this.blockRegenQueue.poll();
                block.setProgress(block.getProgress() - 1);
                block.setLastTimeMined(curTime);
                if (block.getProgress() < 1) {
                    MultiMineServer.this.sendPartiallyMinedBlockDeleteCommandToAllPlayers(block);
                    MultiMineServer.this.getPartiallyMinedBlocksForDimension(block.getDimension()).remove(block);
                } else {
                    MultiMineServer.this.sendPartiallyMinedBlockUpdateToAllPlayers(block);
                    MultiMineServer.this.blockRegenQueue.add(block);
                }
            }
        }

        private boolean isBlockGone(PartiallyMinedBlock block) {
            return serverInstance.a(block.getDimension()).a(block.getX(), block.getY(), block.getZ()) == 0;
        }

        public EnumSet ticks() {
            return this.tickTypes;
        }

        public String getLabel() {
            return "MultiMine";
        }
    }
}

