/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.plugin.Block;

import java.io.IOException;
import java.util.ArrayList;
import net.modmaker.Export.Export;
import net.modmaker.IO.SaveManager;
import net.modmaker.Mod.Mod;
import net.modmaker.Utils.BufferedImageSeri;
import net.modmaker.Utils.Unique;
import net.modmaker.plugin.BlockBase;
import net.modmaker.plugin.PanelBase;
import net.modmaker.plugin.Plugin;
import net.modmaker.plugin.SaveBase;

public class Block
extends BlockBase {
    public int lightOpacity = 0;
    public int lightValue = 0;
    public int tickRate = 10;
    public boolean canBlockGrass = true;
    public boolean unbreakable = false;
    public boolean tickRandomly = false;
    public boolean isOpaqueCube = true;
    public boolean alpha = false;
    public String stepSound = "Grass";
    public String material = "<none>";
    public float particleGravity = 1.0f;
    public float slipperiness = 0.6f;
    public float hardness = 0.6f;
    public float resistance = 0.0f;
    public boolean multiTextures = true;
    public BufferedImageSeri textureTop = null;
    public BufferedImageSeri textureLeft = null;
    public BufferedImageSeri textureRight = null;
    public BufferedImageSeri textureBack = null;
    public BufferedImageSeri textureBottom = null;
    public int flammability = 0;
    public int fireSpread = 0;
    public boolean worldGen = false;
    public int amountChunk = 0;
    public int percentChunks = 0;
    public int minHeight = 0;
    public int maxHeight = 64;

    public Block(Plugin plugin, Mod mod) {
        super(plugin, mod);
        if (mod != null) {
            this.setName(Unique.getBlockName((String)"Block", (Mod)mod));
        }
    }

    public void Load(String line) {
        if (line.startsWith("Name:")) {
            this.setName(line.substring("name:".length()));
        } else if (line.startsWith("Id:")) {
            this.setId(Integer.parseInt(line.substring("Id:".length())));
        } else if (line.startsWith("Material:")) {
            this.material = line.substring("Material:".length());
        } else if (line.startsWith("StepSound:")) {
            this.stepSound = line.substring("StepSound:".length());
        } else if (line.startsWith("Hardness:")) {
            this.hardness = Float.parseFloat(line.substring("Hardness:".length()));
        } else if (line.startsWith("Resistance:")) {
            this.resistance = Float.parseFloat(line.substring("Resistance:".length()));
        } else if (line.startsWith("Light:")) {
            this.lightOpacity = Integer.parseInt(line.substring("Light:".length()));
        } else if (line.startsWith("Luminance:")) {
            this.lightValue = Integer.parseInt(line.substring("Luminance:".length()));
        } else if (line.startsWith("Unbreakable:")) {
            this.unbreakable = Boolean.parseBoolean(line.substring("Unbreakable:".length()));
        } else if (line.startsWith("alpha:")) {
            this.alpha = Boolean.parseBoolean(line.substring("alpha:".length()));
        } else if (line.startsWith("canBlockGrass:")) {
            this.canBlockGrass = Boolean.parseBoolean(line.substring("canBlockGrass:".length()));
        } else if (line.startsWith("isOpaqueCube:")) {
            this.isOpaqueCube = Boolean.parseBoolean(line.substring("isOpaqueCube:".length()));
        } else if (line.startsWith("particleGravity:")) {
            this.particleGravity = Float.parseFloat(line.substring("particleGravity:".length()));
        } else if (line.startsWith("tickRandomly:")) {
            this.tickRandomly = Boolean.parseBoolean(line.substring("tickRandomly:".length()));
        } else if (line.startsWith("tickRate:")) {
            this.tickRate = Integer.parseInt(line.substring("tickRate:".length()));
        } else if (line.startsWith("slipperiness:")) {
            this.slipperiness = Float.parseFloat(line.substring("slipperiness:".length()));
        } else if (line.startsWith("flammability:")) {
            this.flammability = Integer.parseInt(line.substring("flammability:".length()));
        } else if (line.startsWith("fireSpread:")) {
            this.fireSpread = Integer.parseInt(line.substring("fireSpread:".length()));
        } else if (line.startsWith("MultiTextures:")) {
            this.multiTextures = Boolean.parseBoolean(line.substring("MultiTextures:".length()));
        } else if (line.startsWith("Texture:")) {
            this.setTexture(new BufferedImageSeri(line.substring("Texture:".length())));
        } else if (line.startsWith("Top:")) {
            this.textureTop = new BufferedImageSeri(line.substring("Top:".length()));
        } else if (line.startsWith("Back:")) {
            this.textureBack = new BufferedImageSeri(line.substring("Back:".length()));
        } else if (line.startsWith("Bottom:")) {
            this.textureBottom = new BufferedImageSeri(line.substring("Bottom:".length()));
        } else if (line.startsWith("Left:")) {
            this.textureLeft = new BufferedImageSeri(line.substring("Left:".length()));
        } else if (line.startsWith("Right:")) {
            this.textureRight = new BufferedImageSeri(line.substring("Right:".length()));
        } else if (line.startsWith("WorldGen:")) {
            this.worldGen = Boolean.parseBoolean(line.substring("WorldGen:".length()));
        } else if (line.startsWith("AmountChunk:")) {
            this.amountChunk = Integer.parseInt(line.substring("AmountChunk:".length()));
        } else if (line.startsWith("PercentChunk:")) {
            this.percentChunks = Integer.parseInt(line.substring("PercentChunk:".length()));
        } else if (line.startsWith("MinHeight:")) {
            this.minHeight = Integer.parseInt(line.substring("MinHeight:".length()));
        } else if (line.startsWith("MaxHeight:")) {
            this.maxHeight = Integer.parseInt(line.substring("MaxHeight:".length()));
        } else if (line.startsWith("CustomCode_")) {
            int i = Integer.parseInt(line.substring("CustomCode_".length(), "CustomCode_".length() + 1));
            String code = line.substring("CustomCode_a:".length());
            if (this.getCustomCode() == null) {
                ArrayList<String> cc = new ArrayList<String>();
                cc.add(i, code.replace("<br>", "\n"));
                this.setCustomCode(cc);
            } else {
                ArrayList cc = this.getCustomCode();
                cc.add(i, code.replace("<br>", "\n"));
                this.setCustomCode(cc);
            }
        }
    }

    public void Save(SaveManager.BufWriter bf) throws IOException {
        bf.writeLine("Name:" + this.getName());
        bf.writeLine("Id:" + this.getId());
        bf.writeLine("Material:" + this.material);
        bf.writeLine("StepSound:" + this.stepSound);
        bf.writeLine("Hardness:" + this.hardness);
        bf.writeLine("Resistance:" + this.resistance);
        bf.writeLine("Light:" + this.lightOpacity);
        bf.writeLine("Luminance:" + this.lightValue);
        bf.writeLine("Unbreakable:" + this.unbreakable);
        bf.writeLine("alpha:" + this.alpha);
        bf.writeLine("canBlockGrass:" + this.canBlockGrass);
        bf.writeLine("isOpaqueCube:" + this.isOpaqueCube);
        bf.writeLine("particleGravity:" + this.particleGravity);
        bf.writeLine("slipperiness:" + this.slipperiness);
        bf.writeLine("tickRandomly:" + this.tickRandomly);
        bf.writeLine("tickRate:" + this.tickRate);
        bf.writeLine("flammability:" + this.flammability);
        bf.writeLine("fireSpread:" + this.fireSpread);
        bf.writeLine("MultiTextures:" + this.multiTextures);
        if (this.getTexture() != null) {
            bf.writeLine("Texture:" + this.getTexture().toString());
        }
        if (this.textureTop != null) {
            bf.writeLine("Top:" + this.textureTop.toString());
        }
        if (this.textureBack != null) {
            bf.writeLine("Back:" + this.textureBack.toString());
        }
        if (this.textureBottom != null) {
            bf.writeLine("Bottom:" + this.textureBottom.toString());
        }
        if (this.textureLeft != null) {
            bf.writeLine("Left:" + this.textureLeft.toString());
        }
        if (this.textureRight != null) {
            bf.writeLine("Right:" + this.textureRight.toString());
        }
        bf.writeLine("WorldGen:" + this.worldGen);
        bf.writeLine("AmountChunk:" + this.amountChunk);
        bf.writeLine("PercentChunk:" + this.percentChunks);
        bf.writeLine("MinHeight:" + this.minHeight);
        bf.writeLine("MaxHeight:" + this.maxHeight);
        if (this.getCustomCode() != null) {
            for (int a = 0; a < this.getCustomCode().size(); ++a) {
                if (this.getCustomCode().get(a) == null && !"".equals(this.getCustomCode().get(a))) continue;
                bf.writeLine("CustomCode_" + a + ":" + ((String)this.getCustomCode().get(a)).replace("\n", "<br>"));
            }
        }
    }

    public void Check(ArrayList<String> log) {
        String error = Export.ContainsError((String)this.getName());
        if (error != null) {
            log.add("Block " + this.getName() + ": " + error);
        }
        if (this.getTexture() == null) {
            log.add("Block " + this.getName() + ": Invalid Texture");
        } else if (this.getTexture().getImage() == null) {
            log.add("Block " + this.getName() + ": Invalid Texture");
        }
        if (this.multiTextures) {
            if (this.textureBack == null) {
                log.add("Block " + this.getName() + ": Invalid Back Texture");
            } else if (this.textureBack.getImage() == null) {
                log.add("Block " + this.getName() + ": Invalid Back Texture");
            }
            if (this.textureTop == null) {
                log.add("Block " + this.getName() + ": Invalid Top Texture");
            } else if (this.textureTop.getImage() == null) {
                log.add("Block " + this.getName() + ": Invalid Top Texture");
            }
            if (this.textureRight == null) {
                log.add("Block " + this.getName() + ": Invalid Right Texture");
            } else if (this.textureRight.getImage() == null) {
                log.add("Block " + this.getName() + ": Invalid Right Texture");
            }
            if (this.textureLeft == null) {
                log.add("Block " + this.getName() + ": Invalid Left Texture");
            } else if (this.textureLeft.getImage() == null) {
                log.add("Block " + this.getName() + ": Invalid Left Texture");
            }
            if (this.textureBottom == null) {
                log.add("Block " + this.getName() + ": Invalid Bottom Texture");
            } else if (this.textureBottom.getImage() == null) {
                log.add("Block " + this.getName() + ": Invalid Bottom Texture");
            }
        }
        if (this.getId() < 158) {
            log.add("Block " + this.getName() + ": Id must be higher than 158");
        } else if (this.getId() > 4096) {
            log.add("Block " + this.getName() + ": Id must be lower than 4096");
        }
        if (this.material == null || this.material.equals("")) {
            log.add("Block " + this.getName() + ": Invalid Materials");
        }
        if (this.hardness < 0.0f) {
            log.add("Block " + this.getName() + ": Hardness < 0");
        }
        if (this.resistance < 0.0f) {
            log.add("Block " + this.getName() + ": Resistance < 0");
        }
        if (this.stepSound == null || this.stepSound.equals("")) {
            log.add("Block " + this.getName() + ": No StepSound");
        }
        if (this.lightOpacity < 0) {
            log.add("Block " + this.getName() + ": Light Opacity < 0");
        }
        if (this.lightValue < 0) {
            log.add("Block " + this.getName() + ": LightValue < 0");
        }
        if (this.worldGen) {
            if (this.amountChunk < 0) {
                log.add("Block " + this.getName() + ": Amount per Chunk < 0");
            }
            if (this.percentChunks < 0) {
                log.add("Block " + this.getName() + ": Percent Chunks < 0");
            }
            if (this.percentChunks > 100) {
                log.add("Block " + this.getName() + ": Percent Chunks > 100");
            }
            if (this.minHeight > this.maxHeight) {
                log.add("Block " + this.getName() + ": Min Height > Max Height");
            }
            if (this.minHeight > 256 || this.minHeight < 0) {
                log.add("Block " + this.getName() + ": Min Height must be between 0 - 256");
            }
            if (this.maxHeight > 256 || this.maxHeight < 0) {
                log.add("Block " + this.getName() + ": Max Height must be between 0 - 256");
            }
        }
    }

    public SaveBase getNewChild() {
        return null;
    }

    public PanelBase getNewChildPanel(SaveBase child) {
        return null;
    }

    public String getJavaName() {
        return this.getName().replace(" ", "_");
    }
}

