/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.plugin.Block;

import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import net.modmaker.Console.Console;
import net.modmaker.Export.Client;
import net.modmaker.Export.Export;
import net.modmaker.Export.Server;
import net.modmaker.MinecraftEvents.EventBase;
import net.modmaker.Mod.Mod;
import net.modmaker.Utils.DropData;
import net.modmaker.plugin.Block.Block;
import net.modmaker.plugin.Plugin;
import net.modmaker.plugin.SaveBase;

public class ExportScript {
    private static Export.ExportHint exportBlock;
    private static Export.ExportHint exportClientBlock;
    private static Export.ExportHint exportServerBlock;
    private static Export.ExportHint exportDmeApi;
    private static Export.ExportTextureHint exportTexture;

    public static void Enable(Plugin plugin) {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("mods.DmeUtils.RenderFallingBlock");
        exportDmeApi = new Export.ExportHint(new ArrayList(), plugin){

            public void onExporting(BufferedWriter writer, Mod mod, File root) throws IOException {
                byte[] buffer = new byte[1024];
                int i = 0;
                File f = new File(root + "/RenderFallingBlock.java");
                f.getParentFile().mkdirs();
                String url = "/net/modmaker/DmeApi/RenderFallingBlock.java.res";
                InputStream in = ExportScript.class.getResourceAsStream(url);
                if (in == null) {
                    throw new IOException("Could extract from resources: " + url);
                }
                FileOutputStream out = new FileOutputStream(f);
                while ((i = in.read(buffer)) > -1) {
                    out.write(buffer, 0, i);
                }
                in.close();
                out.close();
            }
        };
        exportBlock = new Export.ExportHint(new ArrayList(), plugin){

            public void onExporting(BufferedWriter bf, Mod mod, File root) throws IOException {
                for (SaveBase sb : mod.object) {
                    try {
                        if (!(sb instanceof Block)) continue;
                        Block block = (Block)sb;
                        bf.write("    public static final Block_" + block.getJavaName() + " " + block.getJavaName() + " = new Block_" + block.getJavaName() + "();");
                        bf.newLine();
                        ExportScript.exportBlockClass(block, root);
                    }
                    catch (Exception e) {
                        Console.Err((Throwable)e);
                    }
                }
            }
        };
        exportServerBlock = new Export.ExportHint(new ArrayList(), plugin){

            public void onExporting(BufferedWriter bf, Mod mod, File root) throws IOException {
                for (SaveBase sb : mod.object) {
                    try {
                        if (!(sb instanceof Block)) continue;
                        Block block = (Block)sb;
                        bf.write("        GameRegistry.registerBlock(" + block.getJavaName() + ");");
                        bf.newLine();
                        if (!block.worldGen) continue;
                        bf.write("        GameRegistry.registerWorldGenerator(" + block.getJavaName() + ");");
                        bf.newLine();
                    }
                    catch (Exception e) {
                        Console.Err((Throwable)e);
                    }
                }
            }
        };
        exportClientBlock = new Export.ExportHint(imports, plugin){

            public void onExporting(BufferedWriter bf, Mod mod, File root) throws IOException {
                bf.write("        RenderingRegistry.instance().registerEntityRenderingHandler(EntityFallingSand.class, new RenderFallingBlock());");
                bf.newLine();
                for (SaveBase sb : mod.object) {
                    try {
                        if (!(sb instanceof Block)) continue;
                        Block block = (Block)sb;
                        bf.write("        LanguageRegistry.addName(" + block.getJavaName() + ", \"" + block.getName() + "\");");
                        bf.newLine();
                    }
                    catch (Exception e) {
                        Console.Err((Throwable)e);
                    }
                }
            }
        };
        exportTexture = new Export.ExportTextureHint(){

            public void onExportTextureHint(Mod mod, File parent) throws IOException {
                for (SaveBase sb : mod.object) {
                    try {
                        if (!(sb instanceof Block)) continue;
                        Block block = (Block)sb;
                        ExportScript.exportTextures(block, parent);
                    }
                    catch (Exception e) {
                        Console.Err((Throwable)e);
                    }
                }
            }
        };
        Server.addVariables((Export.ExportHint)exportBlock);
        Server.addRenderInfo((Export.ExportHint)exportServerBlock);
        Client.addRenderInfo((Export.ExportHint)exportClientBlock);
        Export.addExportDmeApiHint((Export.ExportHint)exportDmeApi);
        Export.addExportTextureHint((Export.ExportTextureHint)exportTexture);
    }

    public static void Disable() {
        if (exportBlock != null) {
            Server.removeVariables((Export.ExportHint)exportBlock);
        }
        if (exportClientBlock != null) {
            Client.removeRenderInfo((Export.ExportHint)exportBlock);
        }
        if (exportServerBlock != null) {
            Server.removeRenderInfo((Export.ExportHint)exportServerBlock);
        }
        if (exportDmeApi != null) {
            Export.removeExportDmeApiHint((Export.ExportHint)exportDmeApi);
        }
        if (exportTexture != null) {
            Export.removeExportTextureHint((Export.ExportTextureHint)exportTexture);
        }
    }

    private static void exportTextures(Block block, File root) throws IOException {
        File tRoot = new File(root.getPath() + "/blocks");
        tRoot.mkdirs();
        ImageIO.write((RenderedImage)block.getTexture().getImage(), "PNG", new File(tRoot + "/" + block.getJavaName() + "_front.png"));
        if (block.multiTextures) {
            ImageIO.write((RenderedImage)block.textureBack.getImage(), "PNG", new File(tRoot + "/" + block.getJavaName() + "_back.png"));
            ImageIO.write((RenderedImage)block.textureBottom.getImage(), "PNG", new File(tRoot + "/" + block.getJavaName() + "_bottom.png"));
            ImageIO.write((RenderedImage)block.textureLeft.getImage(), "PNG", new File(tRoot + "/" + block.getJavaName() + "_left.png"));
            ImageIO.write((RenderedImage)block.textureRight.getImage(), "PNG", new File(tRoot + "/" + block.getJavaName() + "_right.png"));
            ImageIO.write((RenderedImage)block.textureTop.getImage(), "PNG", new File(tRoot + "/" + block.getJavaName() + "_top.png"));
        }
    }

    private static void exportBlockClass(Block block, File root) throws IOException {
        DropData dd;
        BufferedWriter bf = new BufferedWriter(new FileWriter(root.getPath() + "/Block_" + block.getJavaName() + ".java"));
        bf.write("package mods." + block.getMod().name.replace(" ", "_") + ";");
        bf.newLine();
        bf.newLine();
        bf.write("import net.minecraft.util.Icon;");
        bf.newLine();
        bf.write("import net.minecraft.client.renderer.texture.IconRegister;");
        bf.newLine();
        bf.write("import cpw.mods.fml.relauncher.Side;");
        bf.newLine();
        bf.write("import cpw.mods.fml.relauncher.SideOnly;");
        bf.newLine();
        bf.write("import net.minecraft.src.*;");
        bf.newLine();
        bf.write("import net.minecraft.world.World;");
        bf.newLine();
        bf.write("import net.minecraft.world.chunk.IChunkProvider;");
        bf.newLine();
        bf.write("import net.minecraft.world.gen.feature.WorldGenMinable;");
        bf.newLine();
        bf.write("import net.minecraft.block.*;");
        bf.newLine();
        bf.write("import net.minecraft.block.material.Material;");
        bf.newLine();
        bf.write("import net.minecraft.item.*;");
        bf.newLine();
        bf.write("import net.minecraft.creativetab.CreativeTabs;");
        bf.newLine();
        bf.write("import cpw.mods.fml.common.IWorldGenerator;");
        bf.newLine();
        bf.write("import java.util.Random;");
        bf.newLine();
        bf.write("import net.minecraft.entity.Entity;");
        bf.newLine();
        for (EventBase event : block.getEvents()) {
            Iterator i$ = event.getExportHint().imports.iterator();
            while (i$.hasNext()) {
                String imports;
                String str = imports = (String)i$.next();
                if (imports.startsWith("import ")) {
                    str = imports.substring("import ".length());
                }
                if (str.endsWith(";")) {
                    str = str.substring(0, str.length() - 1);
                }
                bf.write("import " + str + ";");
                bf.newLine();
            }
        }
        bf.write("//Start Custom imports");
        bf.newLine();
        if (block.getCustomCode() != null) {
            if (block.getCustomCode().size() >= 1) {
                if (block.getCustomCode().get(0) != null || "".equals(block.getCustomCode().get(0))) {
                    bf.write((String)block.getCustomCode().get(0));
                } else {
                    bf.newLine();
                }
            } else {
                bf.newLine();
            }
        } else {
            bf.newLine();
        }
        bf.newLine();
        bf.write("//End Custom imports");
        bf.newLine();
        bf.newLine();
        Export.writeCredits((BufferedWriter)bf, (Mod)block.getMod());
        bf.newLine();
        bf.write("public class Block_" + block.getJavaName() + " extends Block" + (block.worldGen ? " implements IWorldGenerator{" : "{"));
        bf.newLine();
        bf.newLine();
        bf.write("    @SideOnly(Side.CLIENT)");
        bf.newLine();
        bf.write("    private Icon iconTop;");
        bf.newLine();
        bf.write("    @SideOnly(Side.CLIENT)");
        bf.newLine();
        bf.write("    private Icon iconBottom;");
        bf.newLine();
        bf.write("    @SideOnly(Side.CLIENT)");
        bf.newLine();
        bf.write("    private Icon iconRight;");
        bf.newLine();
        bf.write("    @SideOnly(Side.CLIENT)");
        bf.newLine();
        bf.write("    private Icon iconBack;");
        bf.newLine();
        bf.write("    @SideOnly(Side.CLIENT)");
        bf.newLine();
        bf.write("    private Icon iconLeft;");
        bf.newLine();
        bf.newLine();
        bf.write("    public Block_" + block.getJavaName() + "(){");
        bf.newLine();
        bf.write("        super(" + block.getId() + ", Material." + block.material.toLowerCase() + ");");
        bf.newLine();
        bf.write("        setHardness(" + block.hardness + "F);");
        bf.newLine();
        bf.write("        setResistance(" + block.resistance + "F);");
        bf.newLine();
        bf.write("        setStepSound(Block.sound" + block.stepSound + "Footstep);");
        bf.newLine();
        bf.write("        setCreativeTab(CreativeTabs.tabBlock);");
        bf.newLine();
        bf.write("        setLightOpacity(" + block.lightOpacity + ");");
        bf.newLine();
        bf.write("        setLightValue(" + block.lightValue + ");");
        bf.newLine();
        bf.write("        canBlockGrass[" + block.getId() + "] = " + block.canBlockGrass + ";");
        bf.newLine();
        bf.write("        setTickRandomly(" + block.tickRandomly + ");");
        bf.newLine();
        bf.write("        blockParticleGravity = " + block.particleGravity + "f;");
        bf.newLine();
        bf.write("        slipperiness = " + block.slipperiness + "f;");
        bf.newLine();
        bf.write("        setUnlocalizedName(\"" + block.getName() + "\");");
        bf.newLine();
        bf.write("        setBurnProperties(" + block.getId() + ", " + block.fireSpread + ", " + block.flammability + ");");
        bf.newLine();
        if (block.unbreakable) {
            bf.write("        setBlockUnbreakable();");
        }
        bf.newLine();
        bf.write("        //Start Custom constructor");
        bf.newLine();
        if (block.getCustomCode() != null) {
            if (block.getCustomCode().size() >= 2) {
                if (block.getCustomCode().get(1) != null || "".equals(block.getCustomCode().get(1))) {
                    bf.write((String)block.getCustomCode().get(1));
                } else {
                    bf.newLine();
                }
            } else {
                bf.newLine();
            }
        } else {
            bf.newLine();
        }
        bf.newLine();
        bf.write("        //End Custom constructor");
        bf.newLine();
        bf.write("    }");
        bf.newLine();
        bf.newLine();
        bf.write("    public void registerIcons(IconRegister reg){");
        bf.newLine();
        bf.write("        blockIcon = reg.registerIcon(\"" + block.getMod().name.replace(" ", "_").toLowerCase() + ":" + block.getJavaName() + "_front\");");
        bf.newLine();
        if (block.multiTextures) {
            bf.write("        iconTop = reg.registerIcon(\"" + block.getMod().name.replace(" ", "_").toLowerCase() + ":" + block.getJavaName() + "_top\");");
            bf.newLine();
            bf.write("        iconBottom = reg.registerIcon(\"" + block.getMod().name.replace(" ", "_").toLowerCase() + ":" + block.getJavaName() + "_bottom\");");
            bf.newLine();
            bf.write("        iconRight = reg.registerIcon(\"" + block.getMod().name.replace(" ", "_").toLowerCase() + ":" + block.getJavaName() + "_right\");");
            bf.newLine();
            bf.write("        iconBack = reg.registerIcon(\"" + block.getMod().name.replace(" ", "_").toLowerCase() + ":" + block.getJavaName() + "_back\");");
            bf.newLine();
            bf.write("        iconLeft = reg.registerIcon(\"" + block.getMod().name.replace(" ", "_").toLowerCase() + ":" + block.getJavaName() + "_left\");");
            bf.newLine();
        }
        bf.write("    }");
        bf.newLine();
        if (block.multiTextures) {
            bf.newLine();
            bf.write("    public Icon getIcon(int i, int j){");
            bf.newLine();
            bf.write("        if(i == 0){");
            bf.newLine();
            bf.write("            return iconBottom;");
            bf.newLine();
            bf.write("        }");
            bf.newLine();
            bf.write("        if(i == 1){");
            bf.newLine();
            bf.write("            return iconTop;");
            bf.newLine();
            bf.write("        }");
            bf.newLine();
            bf.write("        if(i == 2){");
            bf.newLine();
            bf.write("            return blockIcon;");
            bf.newLine();
            bf.write("        }");
            bf.newLine();
            bf.write("        if(i == 3){");
            bf.newLine();
            bf.write("            return iconBack;");
            bf.newLine();
            bf.write("        }");
            bf.newLine();
            bf.write("        if(i == 4){");
            bf.newLine();
            bf.write("            return iconRight;");
            bf.newLine();
            bf.write("        }");
            bf.newLine();
            bf.write("        if(i == 5){");
            bf.newLine();
            bf.write("            return iconLeft;");
            bf.newLine();
            bf.write("        }");
            bf.newLine();
            bf.write("        return null;");
            bf.newLine();
            bf.write("    }");
            bf.newLine();
        }
        if (block.worldGen) {
            bf.newLine();
            bf.write("    public void generate(Random random, int chunkX, int chunkZ, World world,IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {");
            bf.newLine();
            bf.write("        if(random.nextInt(100) <= " + block.percentChunks + "){");
            bf.newLine();
            bf.write("            for(int a = 0; a < " + block.amountChunk + "; a++){");
            bf.newLine();
            bf.write("                int x = chunkX*16 + random.nextInt(16);");
            bf.newLine();
            bf.write("                int z = chunkZ*16 + random.nextInt(16);");
            bf.newLine();
            bf.write("                int y = random.nextInt(" + (block.maxHeight - block.minHeight) + ") + " + block.minHeight + ";");
            bf.newLine();
            bf.write("                new WorldGenMinable(this.blockID, 10).generate(world, random, x, y, z);");
            bf.newLine();
            bf.write("            }");
            bf.newLine();
            bf.write("        }");
            bf.newLine();
            bf.write("    }");
            bf.newLine();
        }
        bf.newLine();
        bf.write("    public int tickRate(){");
        bf.newLine();
        bf.write("        return " + block.tickRate + ";");
        bf.newLine();
        bf.write("    }");
        bf.newLine();
        bf.newLine();
        bf.write("    public boolean isOpaqueCube(){");
        bf.newLine();
        bf.write("        return " + block.isOpaqueCube + ";");
        bf.newLine();
        bf.write("    }");
        bf.newLine();
        bf.newLine();
        bf.write("    public int getRenderBlockPass(){");
        bf.newLine();
        bf.write("        return " + (!block.alpha ? "1" : "0") + ";");
        bf.newLine();
        bf.write("    }");
        bf.newLine();
        bf.newLine();
        bf.write("    public void dropBlockAsItemWithChance(World world, int blockX, int blockY, int blockZ, int metaData, float par6, int fortune){");
        bf.newLine();
        bf.write("        if(!world.isRemote){");
        bf.newLine();
        if (block.dropItself()) {
            bf.write("            super.dropBlockAsItemWithChance(world, blockX, blockY, blockZ, metaData, par6, fortune);");
        }
        bf.newLine();
        if (!block.getRareDrops().isEmpty()) {
            bf.write("            if(world.rand.nextInt(100) <= 20){");
            bf.newLine();
            int chance = 0;
            int count = 0;
            for (DropData dd2 : block.getRareDrops()) {
                chance = dd2.getChance() + chance;
            }
            if (chance == 0) {
                chance = 1;
            }
            bf.write("                int chance = world.rand.nextInt(" + chance + ");");
            bf.newLine();
            int aa = 0;
            for (int a = 0; a < block.getRareDrops().size(); ++a) {
                dd = (DropData)block.getRareDrops().get(a);
                if (dd == null || dd.getBlockItemHolder() == null) continue;
                count += dd.getChance();
                if (++aa == 1) {
                    bf.write("                if(");
                }
                if (aa != 1) {
                    bf.write("                else if(");
                }
                bf.write("chance <= " + count + "){");
                bf.newLine();
                bf.write("                    dropBlockAsItem_do(world, blockX, blockY, blockZ, new ItemStack(" + dd.getBlockItemHolder().getJavaName() + ", " + dd.getAmount() + "));");
                bf.newLine();
                bf.write("                }");
                bf.newLine();
            }
            bf.write("            }");
            bf.newLine();
            bf.newLine();
        }
        if (!block.getDrops().isEmpty()) {
            int chance = 0;
            int count = 0;
            for (DropData dd3 : block.getDrops()) {
                chance = dd3.getChance() + chance;
            }
            if (chance == 0) {
                chance = 1;
            }
            bf.write("            int chance = world.rand.nextInt(" + chance + ");");
            bf.newLine();
            int aa = 0;
            for (int a = 0; a < block.getDrops().size(); ++a) {
                dd = (DropData)block.getDrops().get(a);
                if (dd == null || dd.getBlockItemHolder() == null) continue;
                count += dd.getChance();
                if (++aa == 1) {
                    bf.write("            if(");
                }
                if (aa != 1) {
                    bf.write("            else if(");
                }
                bf.write("chance <= " + count + "){");
                bf.newLine();
                bf.write("                dropBlockAsItem_do(world, blockX, blockY, blockZ, new ItemStack(" + dd.getBlockItemHolder().getJavaName() + ", " + dd.getAmount() + "));");
                bf.newLine();
                bf.write("            }");
                bf.newLine();
            }
            bf.newLine();
        }
        bf.write("        }");
        bf.newLine();
        bf.write("    }");
        bf.newLine();
        bf.newLine();
        for (EventBase event : block.getEvents()) {
            if (event.getActions().isEmpty()) continue;
            event.getExportHint().onExporting(bf, block.getMod(), root);
        }
        bf.newLine();
        bf.write("    //Start Custom Methodes");
        bf.newLine();
        if (block.getCustomCode() != null) {
            if (block.getCustomCode().size() >= 3) {
                if (block.getCustomCode().get(2) != null || "".equals(block.getCustomCode().get(2))) {
                    bf.write((String)block.getCustomCode().get(2));
                } else {
                    bf.newLine();
                }
            } else {
                bf.newLine();
            }
        } else {
            bf.newLine();
        }
        bf.newLine();
        bf.write("    //End Custom Methods");
        bf.newLine();
        bf.write("}");
        bf.close();
    }
}

