/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.plugin.Item;

import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import net.modmaker.Console.Console;
import net.modmaker.Export.Client;
import net.modmaker.Export.Export;
import net.modmaker.Export.Server;
import net.modmaker.MinecraftEvents.EventBase;
import net.modmaker.Mod.Mod;
import net.modmaker.plugin.Item.Item;
import net.modmaker.plugin.Plugin;
import net.modmaker.plugin.SaveBase;

public class ExportScript {
    private static Export.ExportHint exportItem;
    private static Export.ExportHint exportClientItem;
    private static Export.ExportTextureHint exportTexture;

    public static void Enable(Plugin plugin) {
        ArrayList imports = new ArrayList();
        exportItem = new Export.ExportHint(imports, plugin){

            public void onExporting(BufferedWriter bf, Mod mod, File root) throws IOException {
                for (SaveBase sb : mod.object) {
                    try {
                        if (!(sb instanceof Item)) continue;
                        Item item = (Item)sb;
                        bf.write("    public static final Item_" + item.getJavaName() + " " + item.getJavaName() + " = new Item_" + item.getJavaName() + "();");
                        bf.newLine();
                        ExportScript.exportItemClass(root, item);
                    }
                    catch (Exception e) {
                        Console.Err((Throwable)e);
                    }
                }
            }
        };
        ArrayList clientImports = new ArrayList();
        exportClientItem = new Export.ExportHint(clientImports, plugin){

            public void onExporting(BufferedWriter bf, Mod mod, File root) throws IOException {
                for (SaveBase sb : mod.object) {
                    try {
                        if (!(sb instanceof Item)) continue;
                        Item item = (Item)sb;
                        bf.write("        LanguageRegistry.addName(" + item.getJavaName() + ", \"" + item.getName() + "\");");
                        bf.newLine();
                    }
                    catch (Exception e) {
                        Console.Err((Throwable)e);
                    }
                }
            }
        };
        exportTexture = new Export.ExportTextureHint(){

            public void onExportTextureHint(Mod mod, File parent) throws IOException {
                for (SaveBase sb : mod.object) {
                    try {
                        if (!(sb instanceof Item)) continue;
                        Item item = (Item)sb;
                        ExportScript.exportTexture(parent, item);
                    }
                    catch (Exception e) {
                        Console.Err((Throwable)e);
                    }
                }
            }
        };
        Server.addVariables((Export.ExportHint)exportItem);
        Client.addRenderInfo((Export.ExportHint)exportClientItem);
        Export.addExportTextureHint((Export.ExportTextureHint)exportTexture);
    }

    public static void Disable() {
        if (exportItem != null) {
            Server.removeVariables((Export.ExportHint)exportItem);
        }
        if (exportClientItem != null) {
            Client.removeRenderInfo((Export.ExportHint)exportClientItem);
        }
        if (exportTexture != null) {
            Export.removeExportTextureHint((Export.ExportTextureHint)exportTexture);
        }
    }

    private static void exportTexture(File root, Item item) throws IOException {
        File tRoot = new File(root.getPath() + "/items");
        tRoot.mkdirs();
        ImageIO.write((RenderedImage)item.getTexture().getImage(), "PNG", new File(tRoot + "/" + item.getJavaName() + ".png"));
    }

    private static void exportItemClass(File root, Item item) throws IOException {
        BufferedWriter bf = new BufferedWriter(new FileWriter(root.getPath() + "/Item_" + item.getJavaName() + ".java"));
        bf.write("package mods." + item.getMod().name.replace(" ", "_") + ";");
        bf.newLine();
        bf.newLine();
        bf.write("import cpw.mods.fml.relauncher.Side;");
        bf.newLine();
        bf.write("import cpw.mods.fml.relauncher.SideOnly;");
        bf.newLine();
        bf.write("import net.minecraft.client.renderer.texture.IconRegister;");
        bf.newLine();
        bf.write("import net.minecraft.creativetab.CreativeTabs;");
        bf.newLine();
        bf.write("import net.minecraft.entity.player.EntityPlayer;");
        bf.newLine();
        bf.write("import net.minecraft.item.EnumAction;");
        bf.newLine();
        bf.write("import net.minecraft.item.Item;");
        bf.newLine();
        bf.write("import net.minecraft.item.ItemStack;");
        bf.newLine();
        bf.write("import net.minecraft.world.World;");
        bf.newLine();
        for (EventBase event : item.getEvents()) {
            Iterator i$ = event.getExportHint().imports.iterator();
            while (i$.hasNext()) {
                String i;
                String str = i = (String)i$.next();
                if (i.startsWith("import ")) {
                    str = i.substring("imports: ".length());
                }
                if (str.endsWith(";")) {
                    str = str.substring(0, str.length() - 1);
                }
                bf.write("import " + str + ";");
                bf.newLine();
            }
        }
        bf.write("//Start Custom imports");
        bf.newLine();
        if (item.getCustomCode() != null) {
            if (item.getCustomCode().size() >= 1) {
                if (item.getCustomCode().get(0) != null || "".equals(item.getCustomCode().get(0))) {
                    bf.write((String)item.getCustomCode().get(0));
                } else {
                    bf.newLine();
                }
            } else {
                bf.newLine();
            }
        } else {
            bf.newLine();
        }
        bf.newLine();
        bf.write("//End Custom imports");
        bf.newLine();
        bf.newLine();
        Export.writeCredits((BufferedWriter)bf, (Mod)item.getMod());
        bf.newLine();
        bf.write("public class Item_" + item.getJavaName() + " extends Item{");
        bf.newLine();
        bf.write("    public Item_" + item.getJavaName() + "(){");
        bf.newLine();
        bf.write("        super(" + item.getId() + ");");
        bf.newLine();
        bf.write("        setCreativeTab(CreativeTabs.tab" + item.tab + ");");
        bf.newLine();
        bf.write("        setMaxStackSize(" + item.maxStack + ");");
        bf.newLine();
        bf.write("        setMaxDamage(" + item.maxDamage + ");");
        bf.newLine();
        bf.write("        setUnlocalizedName(\"" + item.getName() + "\");");
        bf.newLine();
        if (item.retItem != null) {
            bf.write("        setContainerItem(" + item.retItem.getJavaName() + ");");
        }
        bf.newLine();
        if (item.full3D) {
            bf.write("        setFull3D();");
        }
        bf.newLine();
        bf.write("        //Start Custom constructor");
        bf.newLine();
        if (item.getCustomCode() != null) {
            if (item.getCustomCode().size() >= 2) {
                if (item.getCustomCode().get(1) != null || "".equals(item.getCustomCode().get(1))) {
                    bf.write((String)item.getCustomCode().get(1));
                } else {
                    bf.newLine();
                }
            } else {
                bf.newLine();
            }
        } else {
            bf.newLine();
        }
        bf.newLine();
        bf.write("        //End Custom constructor");
        bf.newLine();
        bf.write("    }");
        bf.newLine();
        bf.newLine();
        bf.write("    @SideOnly(Side.CLIENT)");
        bf.newLine();
        bf.write("    public void registerIcons(IconRegister iconRegister){");
        bf.newLine();
        bf.write("        itemIcon = iconRegister.registerIcon(\"" + item.getMod().name.replace(" ", "_").toLowerCase() + ":" + item.getJavaName() + "\");");
        bf.newLine();
        bf.write("    }");
        bf.newLine();
        bf.newLine();
        if (!item.action.equals("None")) {
            bf.write("    public EnumAction getItemUseAction(ItemStack par1ItemStack){");
            bf.newLine();
            bf.write("        return EnumAction." + item.action.toLowerCase() + ";");
            bf.newLine();
            bf.write("    }");
            bf.newLine();
            bf.newLine();
        }
        if (item.rotateWhenRendering) {
            bf.write("    public boolean shouldRotateAroundWhenRendering(){");
            bf.newLine();
            bf.write("        return true;");
            bf.newLine();
            bf.write("    }");
            bf.newLine();
            bf.newLine();
        }
        for (EventBase event : item.getEvents()) {
            event.getExportHint().onExporting(bf, item.getMod(), root);
        }
        bf.write("    //Start Custom methodes");
        bf.newLine();
        if (item.getCustomCode() != null) {
            if (item.getCustomCode().size() >= 3) {
                if (item.getCustomCode().get(2) != null || "".equals(item.getCustomCode().get(2))) {
                    bf.write((String)item.getCustomCode().get(2));
                } else {
                    bf.newLine();
                }
            } else {
                bf.newLine();
            }
        } else {
            bf.newLine();
        }
        bf.newLine();
        bf.write("    //End Custom methodes");
        bf.newLine();
        bf.write("}");
        bf.close();
    }
}

