/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.plugin.Smelting;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.modmaker.Console.Console;
import net.modmaker.Gui.Dialogs.ItemChooser;
import net.modmaker.Gui.Tree;
import net.modmaker.Mod.Mod;
import net.modmaker.Utils.BlockItemHolder;
import net.modmaker.Utils.Textures;
import net.modmaker.events.Listeners.UpdateListener;
import net.modmaker.events.UpdateEvent;
import net.modmaker.plugin.PanelBase;
import net.modmaker.plugin.SaveBase;
import net.modmaker.plugin.Smelting.Smelting;

public class SmeltingPanel
extends PanelBase {
    private UpdateListener[] listeners;
    private String backupName;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSpinner jSpinner1;
    private JSpinner jSpinner2;
    private JTextField jTextField1;

    public SmeltingPanel(SaveBase obj) {
        super(obj);
        this.initComponents();
        this.listeners = new UpdateListener[2];
        for (int a = 0; a < this.listeners.length; ++a) {
            final int index = a;
            this.listeners[a] = new UpdateListener(){

                public void onUpdate(UpdateEvent event) {
                    try {
                        Smelting s = (Smelting)SmeltingPanel.this.object;
                        BlockItemHolder bih = index == 0 ? s.in : s.out;
                        JButton button = index == 0 ? SmeltingPanel.this.jButton1 : SmeltingPanel.this.jButton2;
                        button.setToolTipText(bih.getName());
                        if (bih.getTexture() != null) {
                            button.setIcon(new ImageIcon(Textures.Resize((int)64, (int)64, (BufferedImage)bih.getTexture().getImage())));
                        } else {
                            button.setIcon(new ImageIcon(Textures.Resize((int)64, (int)64, (BufferedImage)Textures.getNoTexture())));
                        }
                    }
                    catch (Exception e) {
                        Console.Err((Throwable)e);
                    }
                }
            };
        }
        this.Load();
        this.jTextField1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SmeltingPanel.this.object.setName(SmeltingPanel.this.jTextField1.getText());
                Tree.getTree().UpdateTree();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SmeltingPanel.this.object.setName(SmeltingPanel.this.jTextField1.getText());
                Tree.getTree().UpdateTree();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SmeltingPanel.this.object.setName(SmeltingPanel.this.jTextField1.getText());
                Tree.getTree().UpdateTree();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jButton1 = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jButton2 = new JButton();
        this.jSpinner1 = new JSpinner();
        this.jLabel4 = new JLabel();
        this.jSpinner2 = new JSpinner();
        this.setBackground(new Color(100, 100, 100));
        this.jLabel1.setText("Name:");
        this.jTextField1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SmeltingPanel.this.jTextField1FocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SmeltingPanel.this.jTextField1FocusLost(evt);
            }
        });
        this.jSeparator1.setBackground(new Color(100, 100, 100));
        this.jSeparator1.setForeground(new Color(51, 51, 51));
        this.jButton1.setOpaque(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SmeltingPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jSeparator2.setBackground(new Color(100, 100, 100));
        this.jSeparator2.setForeground(new Color(51, 51, 51));
        this.jButton2.setOpaque(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SmeltingPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jSpinner1.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.jLabel4.setText("Xp:");
        this.jSpinner2.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2, -2, 70, -2).addComponent(this.jButton1, -2, 70, -2).addComponent(this.jLabel2, -2, 70, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSpinner1).addComponent(this.jButton2, -2, 70, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, 150, -2).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner2, -2, 70, -2))).addGap(0, 84, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jSpinner2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 70, -2)).addGroup(layout.createSequentialGroup().addGap(47, 47, 47).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jButton2, -2, 70, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner1, -2, -1, -2))).addContainerGap(138, Short.MAX_VALUE)));
    }

    private void jTextField1FocusGained(FocusEvent evt) {
        if (this.jTextField1.getText() != null && !"".equals(this.jTextField1.getText())) {
            this.backupName = this.jTextField1.getText();
        }
    }

    private void jTextField1FocusLost(FocusEvent evt) {
        if (this.jTextField1.getText() == null || "".equals(this.jTextField1.getText())) {
            if (this.backupName != null && !"".equals(this.backupName)) {
                this.jTextField1.setText(this.backupName);
            } else {
                this.jTextField1.setText("[No Name]");
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            ItemChooser tc = ItemChooser.getItemChooser();
            tc.setVisible(this.object.getMod());
            if (tc.getReturnState() == 1 && tc.getSelectedObject() != null) {
                BlockItemHolder bih = tc.getSelectedObject();
                Smelting s = (Smelting)this.object;
                if (s.in != null) {
                    s.in.removeUpdateListener(this.listeners[0]);
                }
                s.in = bih;
                bih.addUpdateListener(this.listeners[0]);
                this.jButton1.setToolTipText(bih.getName());
                if (bih.getTexture() != null) {
                    this.jButton1.setIcon(new ImageIcon(Textures.Resize((int)64, (int)64, (BufferedImage)bih.getTexture().getImage())));
                } else {
                    this.jButton1.setIcon(new ImageIcon(Textures.Resize((int)64, (int)64, (BufferedImage)Textures.getNoTexture())));
                }
            } else if (tc.getReturnState() == 2) {
                Smelting s = (Smelting)this.object;
                if (s.in != null) {
                    s.in.removeUpdateListener(this.listeners[0]);
                }
                s.in = null;
                this.jButton1.setToolTipText("<none>");
                this.jButton1.setIcon(null);
            }
        }
        catch (Exception ee) {
            Console.Err((Throwable)ee);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        try {
            ItemChooser tc = ItemChooser.getItemChooser();
            tc.setVisible(this.object.getMod());
            if (tc.getReturnState() == 1 && tc.getSelectedObject() != null) {
                BlockItemHolder bih = tc.getSelectedObject();
                Smelting s = (Smelting)this.object;
                if (s.out != null) {
                    s.out.removeUpdateListener(this.listeners[1]);
                }
                s.out = bih;
                bih.addUpdateListener(this.listeners[1]);
                this.jButton2.setToolTipText(bih.getName());
                if (bih.getTexture() != null) {
                    this.jButton2.setIcon(new ImageIcon(Textures.Resize((int)64, (int)64, (BufferedImage)bih.getTexture().getImage())));
                } else {
                    this.jButton2.setIcon(new ImageIcon(Textures.Resize((int)64, (int)64, (BufferedImage)Textures.getNoTexture())));
                }
            } else if (tc.getReturnState() == 2) {
                Smelting s = (Smelting)this.object;
                if (s.out != null) {
                    s.out.removeUpdateListener(this.listeners[1]);
                }
                s.out = null;
                this.jButton2.setToolTipText("<none>");
                this.jButton2.setIcon(null);
            }
        }
        catch (Exception ee) {
            Console.Err((Throwable)ee);
        }
    }

    public void Load() {
        Smelting s = (Smelting)this.object;
        try {
            this.jLabel3.setIcon(new ImageIcon(Textures.Arrow));
        }
        catch (Exception e) {
            Console.Err((Throwable)e);
        }
        try {
            this.jLabel2.setIcon(new ImageIcon(Textures.Fire));
        }
        catch (Exception e) {
            Console.Err((Throwable)e);
        }
        if (this.object.getName() == null) {
            this.object.setName(SmeltingPanel.getSmeltingName("Smelting", this.object.getMod()));
        }
        this.jSpinner1.setValue(s.amount >= 1 ? s.amount : 1);
        this.jSpinner2.setValue(s.xp >= 0 ? s.xp : 0);
        this.jTextField1.setText(s.getName());
        if (s.in != null) {
            s.in.addUpdateListener(this.listeners[0]);
            if (s.in.isInitialized()) {
                this.jButton1.setToolTipText(s.in.getName());
                if (s.in.getTexture() != null) {
                    this.jButton1.setIcon(new ImageIcon(Textures.Resize((int)64, (int)64, (BufferedImage)s.in.getTexture().getImage())));
                }
            }
        }
        if (s.out != null) {
            s.out.addUpdateListener(this.listeners[1]);
            if (s.out.isInitialized()) {
                this.jButton2.setToolTipText(s.out.getName());
                if (s.out.getTexture() != null) {
                    this.jButton2.setIcon(new ImageIcon(Textures.Resize((int)64, (int)64, (BufferedImage)s.out.getTexture().getImage())));
                }
            }
        }
    }

    public void Save() {
        this.object.setName(this.jTextField1.getText());
        Smelting s = (Smelting)this.object;
        s.amount = this.jSpinner1.getValue().hashCode();
        s.xp = this.jSpinner2.getValue().hashCode();
    }

    public static String getSmeltingName(String prefix, Mod mod) {
        boolean isUnique = false;
        String name = prefix;
        int count = 0;
        while (!isUnique) {
            isUnique = true;
            for (SaveBase sb : mod.object) {
                if (!(sb instanceof Smelting) || !name.equals(sb.getName())) continue;
                name = prefix + "_" + count;
                ++count;
                isUnique = false;
            }
        }
        return name;
    }
}

