/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Console;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import net.modmaker.Console.ConsoleWriter;
import net.modmaker.Console.LineInfo;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.IO.Settings;
import net.modmaker.events.ConsoleUpdateEvent;
import net.modmaker.events.Listeners.ConsoleUpdateListener;
import net.modmaker.events.Priority;

public class Console {
    public static ArrayList<LineInfo> log = new ArrayList();
    private static ArrayList<ConsoleUpdateListener> listeners = new ArrayList();
    private static final Console console = new Console();
    private static ConsoleWriter writer = new ConsoleWriter();

    public static void Out(Object line) {
        LineInfo li = new LineInfo(String.valueOf(line));
        System.out.println(li.toString());
        log.add(li);
        Console.triggerConsoleUpdateEvent(new LineInfo[]{li});
    }

    public static void Msg(Object line) {
        LineInfo li = new LineInfo("[MESSAGE] " + String.valueOf(line));
        System.out.println(li.toString());
        log.add(li);
        Console.triggerConsoleUpdateEvent(new LineInfo[]{li});
    }

    public static void Info(Object line) {
        LineInfo li = new LineInfo("[INFO] " + String.valueOf(line));
        System.out.println(li.toString());
        log.add(li);
        Console.triggerConsoleUpdateEvent(new LineInfo[]{li});
    }

    public static void Warning(Object line) {
        LineInfo li = new LineInfo("[WARNING] " + String.valueOf(line));
        System.out.println(li.toString());
        log.add(li);
        Console.triggerConsoleUpdateEvent(new LineInfo[]{li});
    }

    public static void Script(Object line) {
        LineInfo li = new LineInfo("[SCRIPTS] " + String.valueOf(line));
        System.out.println(li.toString());
        log.add(li);
        Console.triggerConsoleUpdateEvent(new LineInfo[]{li});
    }

    public static void Err(Throwable err) {
        err.printStackTrace();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        err.printStackTrace(pw);
        String[] errors = sw.toString().split("\n");
        LineInfo[] lis = new LineInfo[errors.length];
        lis[0] = new LineInfo("[ERROR] " + errors[0]);
        log.add(lis[0]);
        for (int a = 1; a < errors.length; ++a) {
            lis[a] = new LineInfo("[ERROR]         " + errors[a]);
            log.add(lis[a]);
        }
        Console.triggerConsoleUpdateEvent(lis);
    }

    public static ConsoleWriter getWriter() {
        return writer;
    }

    public static void addConsoleUpdateListener(ConsoleUpdateListener listener) {
        listeners.add(listener);
    }

    public static void removeConsoleUpdateListener(ConsoleUpdateListener listener) {
        listeners.remove(listener);
    }

    private static synchronized void triggerConsoleUpdateEvent(LineInfo[] li) {
        try {
            PrintWriter pw;
            StringWriter sw;
            ConsoleUpdateEvent event = new ConsoleUpdateEvent(console, li);
            for (ConsoleUpdateListener listener : listeners) {
                if (listener.getPriority().getValue() != Priority.HIGH.getValue()) continue;
                if (event.isCanceled()) break;
                try {
                    listener.onConsoleUpdate(event);
                }
                catch (Exception e) {
                    sw = new StringWriter();
                    pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    OptionPane.showMessageDialog(Settings.getFrame(), "Error onConsoleUpdate:" + sw.toString(), "Error!", 0);
                }
            }
            for (ConsoleUpdateListener listener : listeners) {
                if (listener.getPriority().getValue() != Priority.NORMAL.getValue()) continue;
                if (event.isCanceled()) break;
                try {
                    listener.onConsoleUpdate(event);
                }
                catch (Exception e) {
                    sw = new StringWriter();
                    pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    OptionPane.showMessageDialog(Settings.getFrame(), "Error onConsoleUpdate:" + sw.toString(), "Error!", 0);
                }
            }
            for (ConsoleUpdateListener listener : listeners) {
                if (listener.getPriority().getValue() != Priority.LOW.getValue()) continue;
                if (!event.isCanceled()) {
                    try {
                        listener.onConsoleUpdate(event);
                    }
                    catch (Exception e) {
                        sw = new StringWriter();
                        pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        OptionPane.showMessageDialog(Settings.getFrame(), "Error onConsoleUpdate:" + sw.toString(), "Error!", 0);
                    }
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

