/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Console;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import net.modmaker.Console.Console;
import net.modmaker.events.ConsoleInputEvent;
import net.modmaker.events.Listeners.ConsoleInputListener;

public class ConsoleInput
implements Runnable {
    private BufferedReader bf;
    private static ArrayList<ConsoleInputListener> listeners = new ArrayList();

    public ConsoleInput(InputStream in) {
        this.bf = new BufferedReader(new InputStreamReader(in));
    }

    public static void addConsoleInputListeners(ConsoleInputListener listener) {
        listeners.add(listener);
    }

    public static void removeConsoleInputListeners(ConsoleInputListener listener) {
        listeners.remove(listener);
    }

    @Override
    public void run() {
        try {
            String line;
            while ((line = this.bf.readLine()) != null) {
                this.doCommand(line);
            }
        }
        catch (Exception e) {
            Console.Warning("System inputStream has forced stop!");
            Console.Err(e);
        }
    }

    public void doCommand(String line) {
        ConsoleInputEvent event = new ConsoleInputEvent(this, line);
        for (ConsoleInputListener listener : listeners) {
            if (event.isCanceled()) continue;
            listener.onConsoleInput(event);
        }
    }
}

