/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Export;

import java.awt.Desktop;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import net.modmaker.Console.Console;
import net.modmaker.Export.Client;
import net.modmaker.Export.Main;
import net.modmaker.Export.Server;
import net.modmaker.Gui.Dialogs.FileChooser;
import net.modmaker.Gui.MainPanel;
import net.modmaker.IO.FileManager;
import net.modmaker.IO.Settings;
import net.modmaker.Mod.Mod;
import net.modmaker.Mod.ModManager;
import net.modmaker.Utils.McpScripts;
import net.modmaker.Utils.ThreadManager;
import net.modmaker.plugin.Plugin;

public class Export {
    private static ArrayList<ExportTextureHint> textureHints = new ArrayList();
    private static ArrayList<ExportHint> exportDmeApi = new ArrayList();
    private static String oldMod = null;

    public static File ExportSrc(ModManager mod) throws ExportException {
        Console.Info("Start Export Source Code");
        oldMod = null;
        FileManager.Delete(new File(Settings.getRoot() + "/MCP/src/minecraft/mods/"));
        File main = new File(Settings.getRoot() + "/MCP/src/minecraft/mods/" + mod.getMod().name.replace(" ", "_") + "/" + mod.getMod().name.replace(" ", "_") + ".java");
        main.getParentFile().mkdirs();
        main.delete();
        File server = new File(Settings.getRoot() + "/MCP/src/minecraft/mods/" + mod.getMod().name.replace(" ", "_") + "/Server.java");
        server.getParentFile().mkdirs();
        server.delete();
        File client = new File(Settings.getRoot() + "/MCP/src/minecraft/mods/" + mod.getMod().name.replace(" ", "_") + "/Client.java");
        client.getParentFile().mkdirs();
        client.delete();
        Main.ExportMod(mod.getMod(), main);
        Server.ExportMod(mod.getMod(), server);
        Client.ExportMod(mod.getMod(), client);
        File api = new File(Settings.getRoot() + "/MCP/src/minecraft/mods/DmeUtils");
        api.delete();
        api.mkdirs();
        Export.ExportDmeApi(api);
        Console.Info("Complete Export Source Code");
        return new File(Settings.getRoot() + "/MCP/src/minecraft/mods/" + mod.getMod().name.replace(" ", "_"));
    }

    public static File ExportTextures(ModManager mod) throws ExportException, IOException {
        return Export.ExportTextures(mod, new File(Settings.getRoot() + "/Export/" + mod.getMod().name.replace(" ", "_").toLowerCase() + "/textures/"));
    }

    public static File ExportTextures(ModManager mod, File parent) throws ExportException, IOException {
        Console.Info("Start Export Textures");
        if (parent.exists()) {
            FileManager.Delete(parent);
        }
        parent.mkdirs();
        new File(parent + "/textures").mkdirs();
        for (ExportTextureHint eth : textureHints) {
            try {
                eth.onExportTextureHint(mod.getMod(), new File(parent + "/textures"));
            }
            catch (Exception e) {
                Console.Err(e);
            }
        }
        Console.Info("Complete Export Textures");
        return parent;
    }

    public static void addExportTextureHint(ExportTextureHint eth) {
        textureHints.add(eth);
    }

    public static void removeExportTextureHint(ExportTextureHint eth) {
        textureHints.remove(eth);
    }

    public static void addExportDmeApiHint(ExportHint eth) {
        exportDmeApi.add(eth);
    }

    public static void removeExportDmeApiHint(ExportHint eth) {
        exportDmeApi.remove(eth);
    }

    public static File ExportToClasses(ModManager mod) throws Exception {
        try {
            Console.Info("Start Export to Classes");
            String ol = oldMod;
            FileManager.Delete(new File(Settings.getRoot() + "/MCP/backup"));
            if (new File(Settings.getRoot() + "/MCP/src/minecraft/mods").exists()) {
                FileManager.Copy(new File(Settings.getRoot() + "/MCP/src/minecraft/mods"), new File(Settings.getRoot() + "/MCP/backup/minecraft/mods"));
            }
            Export.ExportSrc(mod);
            oldMod = ol;
            boolean changed = Export.hasChanged(mod);
            oldMod = mod.getMod().name;
            if (changed) {
                Console.Info("Recompiling");
                Export.FastCompiling(mod);
                Settings.put("modmaker.reobf", "false");
            } else {
                Console.Info("Skip Recompiling");
            }
            if (!"true".equals(Settings.get("modmaker.reobf"))) {
                Console.Info("ReObfuscating");
                McpScripts.ReObfuscate(mod);
                Settings.put("modmaker.reobf", "true");
            } else {
                Console.Info("Skip ReObfuscating");
            }
            Export.ExportInfo(mod.getMod(), new File(Settings.getRoot() + "/MCP/reobf/minecraft/mcmod.info"));
            Export.writeCredits(new File(Settings.getRoot() + "/MCP/reobf/minecraft/Credits.txt"));
            Export.ExportTextures(mod, new File(Settings.getRoot() + "/MCP/reobf/minecraft/assets/" + mod.getMod().name.replace(" ", "_").toLowerCase()));
            File zip = new File(Settings.getRoot() + "/Export/" + mod.getMod().name + "/Final Mod/" + mod.getMod().name + ".zip");
            zip.delete();
            zip.getParentFile().mkdirs();
            FileManager.Zip2(new File(Settings.getRoot() + "/MCP/reobf/minecraft").getPath(), zip.getPath());
            Console.Info("Complete Export to Classes");
            return zip;
        }
        catch (Exception e) {
            oldMod = null;
            Settings.put("modmaker.reobf", "false");
            throw e;
        }
    }

    public static File ExportToInstaller(ModManager mod) throws Exception {
        Console.Info("Start Export to Installer");
        File classes = Export.ExportToClasses(mod);
        new File(classes.getParent() + "/Installer.jar").delete();
        File installation = new File(classes.getParentFile().getParent() + "/Installer/Installer.jar");
        FileManager.extractFromResources("/net/modmaker/res/Installer.jar", installation);
        FileManager.Copy(classes, new File(Settings.getRoot() + "/temp/installer/net/modmaker/Patcher/mod.zip"));
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(Settings.getRoot() + "/temp/installer/net/modmaker/Patcher/properties.yml")));
        bw.write(mod.getMod().name);
        bw.newLine();
        bw.write(Settings.get("modmaker.uptodate.forgeinstaller"));
        bw.newLine();
        bw.write(Settings.get("modmaker.uptodate.mclauncher"));
        bw.newLine();
        bw.flush();
        bw.close();
        FileManager.addToJar(installation, new File(Settings.getRoot() + "/temp/installer"));
        Console.Info("Complete Export to Installer");
        return installation;
    }

    public static File ExportCustomToClasses() throws Exception {
        File modFile = FileChooser.showDialog(Settings.getRoot() + "/CCExport", FileChooser.SAVE_DIALOG, 0, 0, new javax.swing.filechooser.FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return "Minecraft mod files (*.zip)";
            }
        });
        if (modFile == null) {
            return null;
        }
        if (!modFile.getName().endsWith(".zip")) {
            modFile = new File(modFile.getAbsolutePath() + ".zip");
        }
        return Export.ExportCustomToClasses(modFile);
    }

    public static File ExportCustomToClasses(File modFile) throws Exception {
        Console.Info("Start Export Custom Code to Classes");
        oldMod = null;
        Settings.put("modmaker.reobf", "false");
        Export.FastCompiling(null);
        McpScripts.ReObfuscate(null);
        ArrayList<String> obfFiles = new ArrayList<String>();
        File reobf = new File(Settings.getRoot() + "/MCP/reobf/minecraft/mods");
        File src = new File(Settings.getRoot() + "/MCP/src/minecraft/mods");
        Export.searchFiles(reobf, reobf, obfFiles);
        Export.applyFiles(src, src, obfFiles);
        Export.writeCredits(new File(Settings.getRoot() + "/MCP/reobf/minecraft/Credits.txt"));
        modFile.getParentFile().mkdirs();
        FileManager.compress(modFile, new File(Settings.getRoot() + "/MCP/reobf/minecraft"));
        Console.Info("Complete Export Custom Code to Classes");
        MainPanel.setProgress("Exporting to mod complete!", 100);
        return modFile;
    }

    public static File ExportCustomToInstaller() throws Exception {
        File modFile = FileChooser.showDialog(Settings.getRoot() + "/CCExport", FileChooser.SAVE_DIALOG, 0, 0, new javax.swing.filechooser.FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".jar");
            }

            @Override
            public String getDescription() {
                return "Jar Executable (*.jar)";
            }
        });
        if (modFile == null) {
            return null;
        }
        if (!modFile.getName().endsWith(".jar")) {
            modFile = new File(modFile.getAbsolutePath() + ".jar");
        }
        return Export.ExportCustomToInstaller(modFile);
    }

    public static File ExportCustomToInstaller(File installer) throws Exception {
        File classes = Export.ExportCustomToClasses(FileManager.getTempFile());
        Console.Info("Start Export Custom Code to Installer");
        new File(classes.getParent() + "/Installer.jar").delete();
        File installation = new File(classes.getParentFile().getParent() + "/Installer/Installer.jar");
        FileManager.extractFromResources("/net/modmaker/res/Installer.jar", installation);
        FileManager.Copy(classes, new File(Settings.getRoot() + "/temp/installer/net/modmaker/Patcher/mod.zip"));
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(Settings.getRoot() + "/temp/installer/net/modmaker/Patcher/properties.yml")));
        bw.write(installer.getName());
        bw.flush();
        bw.close();
        FileManager.addToJar(installation, new File(Settings.getRoot() + "/temp/installer"));
        Console.Info("Complete Export to Installer");
        return installer;
    }

    private static void searchFiles(File file, File root, ArrayList<String> obfFiles) {
        File[] array;
        if (file.isFile()) {
            obfFiles.add(file.getPath().substring(root.getPath().length() + 1));
        } else if (file.isDirectory() && (array = file.listFiles()) != null) {
            for (File f : array) {
                Export.searchFiles(f, root, obfFiles);
            }
        }
    }

    private static void applyFiles(File file, File root, ArrayList<String> obfFiles) throws IOException {
        File[] array;
        if (file.isFile()) {
            String key = file.getPath().substring(root.getPath().length() + 1);
            boolean exists = false;
            for (String str : obfFiles) {
                if (!str.equals(key.replace(".java", ".class"))) continue;
                exists = true;
                break;
            }
            if (!exists) {
                FileManager.Copy(file, new File(Settings.getRoot() + "/MCP/reobf/minecraft/mods/" + key));
            }
        } else if (file.isDirectory() && (array = file.listFiles()) != null) {
            for (File f : array) {
                Export.applyFiles(f, root, obfFiles);
            }
        }
    }

    public static void writeCredits(BufferedWriter bf, Mod mod) throws IOException {
        bf.write("/**");
        bf.newLine();
        bf.write(" *");
        bf.newLine();
        bf.write(" * @author " + Settings.getAuthor());
        bf.newLine();
        bf.write(" * @Version " + mod.version);
        bf.newLine();
        bf.write(" *");
        bf.newLine();
        bf.write(" * This class is generated by Deathly's Mod Editor Version " + Settings.getVersion());
        bf.newLine();
        bf.write(" * Original Author: Deathlykiller");
        bf.newLine();
        bf.write(" *");
        bf.newLine();
        bf.write(" * Licence: All rights reserved");
        bf.newLine();
        bf.write(" *");
        bf.newLine();
        bf.write(" * See Planet Minecraft: http://www.planetminecraft.com/mod/mc-mod-editor-1494390");
        bf.newLine();
        bf.write(" * See Minecraft Forums: http://www.minecraftforum.net/topic/1473653-deathlys-mod-editor");
        bf.newLine();
        bf.write(" *");
        bf.newLine();
        bf.write(" */");
        bf.newLine();
    }

    public static void writeCredits(File file) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write("****** Credits ******");
        writer.newLine();
        writer.write("This mod is generated by Deathly's Mod Editor Version " + Settings.getVersion());
        writer.newLine();
        writer.write("Author of Deathly's Mod Editor: Deathlykiller");
        writer.newLine();
        writer.newLine();
        writer.write("Licence: All rights reserved");
        writer.newLine();
        writer.newLine();
        writer.write("See Planet Minecraft: http://www.planetminecraft.com/mod/mc-mod-editor-1494390");
        writer.newLine();
        writer.write("See Minecraft Forums: http://www.minecraftforum.net/topic/1473653-deathlys-mod-editor");
        writer.newLine();
        writer.flush();
        writer.close();
    }

    public static void testMod(ModManager mod, boolean client) throws Exception {
        try {
            String line;
            Console.Info("Start Testing Mod");
            String ol = oldMod;
            FileManager.Delete(new File(Settings.getRoot() + "/MCP/backup"));
            if (new File(Settings.getRoot() + "/MCP/src/minecraft/mods").exists()) {
                FileManager.Copy(new File(Settings.getRoot() + "/MCP/src/minecraft/mods"), new File(Settings.getRoot() + "/MCP/backup/minecraft/mods"));
            }
            Export.ExportSrc(mod);
            File text = new File(Settings.getRoot() + "/MCP/bin/minecraft/assets/" + mod.getMod().name.replace(" ", "_").toLowerCase());
            if (client) {
                Export.ExportTextures(mod, text);
            }
            oldMod = ol;
            boolean changed = Export.hasChanged(mod);
            oldMod = mod.getMod().name;
            if (changed) {
                Console.Info("Recompiling");
                Export.FastCompiling(mod);
                Settings.put("modmaker.reobf", "false");
            } else {
                Console.Info("Skip Recompiling");
            }
            Process p = client ? McpScripts.StartClient() : McpScripts.StartServer();
            ThreadManager.addProcess(p, "Minecraft " + (client ? "client" : "server"));
            BufferedReader bf = new BufferedReader(new InputStreamReader(p.getInputStream()));
            final BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            Thread errStream = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String line;
                        while ((line = err.readLine()) != null) {
                            Console.Script(line);
                        }
                    }
                    catch (Exception e) {
                        Console.Err(e);
                    }
                    ThreadManager.removeThread("Minecraft Err Stream");
                }
            });
            ThreadManager.addThread(errStream, "Minecraft Err Stream");
            errStream.start();
            while ((line = bf.readLine()) != null) {
                Console.Script(line);
            }
            ThreadManager.removeProcess("Minecraft " + (client ? "client" : "server"));
            Console.Info("Complete Testing Mod");
        }
        catch (Exception e) {
            oldMod = null;
            Settings.put("modmaker.reobf", "false");
            throw e;
        }
    }

    public static boolean hasChanged(ModManager mod) {
        try {
            File[] bList;
            String od = oldMod;
            if (!mod.getMod().name.equals(od)) {
                return true;
            }
            File src = new File(Settings.getRoot() + "/MCP/src/minecraft/mods/" + mod.getMod().name.replace(" ", "_"));
            File backup = new File(Settings.getRoot() + "/MCP/backup/minecraft/mods/" + mod.getMod().name.replace(" ", "_"));
            if (!src.exists()) {
                return true;
            }
            if (!backup.exists()) {
                return true;
            }
            FileFilter ff = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".java");
                }
            };
            File[] sList = src.listFiles(ff);
            if (sList.length != (bList = backup.listFiles(ff)).length) {
                return true;
            }
            for (File sf : sList) {
                File bf = new File(backup.getPath() + "/" + sf.getName());
                if (!bf.exists()) {
                    return true;
                }
                if (FileManager.compareTwoFiles(sf, bf)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void setOldMod(String modName) {
        oldMod = modName;
    }

    public static String getOldMod() {
        return oldMod;
    }

    public static String ContainsError(String name) {
        String chars = ",/;[]-=\\<>?:{}+()*&^%$#@!~`\"'";
        if (name == null) {
            return " = null";
        }
        if ("".equals(name)) {
            return " is empty";
        }
        String error = "may not contains: ";
        boolean e = false;
        for (int a = 0; a < chars.length(); ++a) {
            if (!name.contains(chars.substring(a, a + 1))) continue;
            error = chars.substring(a, a + 1).equals(" ") ? error + "[space]" : error + chars.substring(a, a + 1);
            e = true;
        }
        if (e) {
            return error;
        }
        return null;
    }

    private static void ExportInfo(Mod mod, File info) throws ExportException {
        try {
            info.getParentFile().mkdirs();
            BufferedWriter bf = new BufferedWriter(new FileWriter(info));
            bf.write("[");
            bf.newLine();
            bf.write("{");
            bf.newLine();
            bf.write("\"modid\":\"ModEditor_" + mod.name.replace(" ", "_") + "\",");
            bf.newLine();
            bf.write("\"name\":\"" + mod.name + "\",");
            bf.newLine();
            bf.write("\"description\":\"" + mod.description + "\",");
            bf.newLine();
            bf.write("\"verion\":\"" + mod.version + "\",");
            bf.newLine();
            bf.write("\"credits\":\"Deathlykiller, " + mod.credits + "\",");
            bf.newLine();
            if (mod.logoFile != null || !"".equals(mod.logoFile)) {
                bf.write("\"logoFile\":\"/mods/" + mod.name.replace(" ", "_") + "/textures/Logo.png\",");
            }
            bf.newLine();
            bf.write("\"mcversion\":\"" + Settings.getMinecraftVersion() + "\",");
            bf.newLine();
            bf.write("\"url\":\"" + mod.url + "\",");
            bf.newLine();
            bf.write("\"updateUrl\":\"\",");
            bf.newLine();
            bf.write("\"authors\":[\"" + Settings.getAuthor() + "\"],");
            bf.newLine();
            bf.write("\"parent\":\"\",");
            bf.newLine();
            bf.write("\"screenshots\":[],");
            bf.newLine();
            bf.write("\"dependencies\":[");
            bf.newLine();
            bf.write("\"mod_MinecraftForge\"");
            bf.newLine();
            bf.write("]");
            bf.newLine();
            bf.write("}");
            bf.newLine();
            bf.write("]");
            bf.newLine();
            bf.flush();
            bf.close();
            if (mod.logoFile != null) {
                File export = new File(info.getParent() + "/mods/" + mod.name.replace(" ", "_") + "/textures/Logo.png");
                export.getParentFile().mkdirs();
                ImageIO.write((RenderedImage)mod.logoFile.getImage(), "PNG", export);
            }
        }
        catch (Exception e) {
            throw new ExportException("Info", e, null);
        }
    }

    public static void ExportDmeApi(File root) throws ExportException {
        try {
            for (ExportHint hint : exportDmeApi) {
                hint.onExporting(null, null, root);
            }
        }
        catch (Exception e) {
            throw new ExportException("Dme Api", e, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void FastCompiling(ModManager mm) throws Exception {
        try {
            Console.Info("Start Compiling");
            File bin = new File(Settings.getRoot() + "/MCP/bin/minecraft/");
            if (!new File(bin + "/Start.class").exists()) throw new Exception();
            MainPanel.setProgress("Compiling ...", 0);
            MainPanel.setIndeterminate(true);
            File src = new File(Settings.getRoot() + "/MCP/src/minecraft");
            if (new File(src + "/mods").exists()) {
                if (new File(bin + "/mods").exists()) {
                    FileManager.Delete(new File(bin + "/mods"));
                }
                new File(bin + "/mods").mkdirs();
                JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
                File[] files = Export.listFiles(new File(src + "/mods"));
                StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
                File[] libs = new File(Settings.getRoot() + "/MCP/jars/bin").listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.getName().endsWith(".jar");
                    }
                });
                String out = null;
                for (File lib : libs) {
                    out = out == null ? lib.getPath() : out + ";" + lib.getPath();
                }
                List<String> options = Arrays.asList("-classpath", bin.getPath() + ";" + out, "-d", bin.getPath());
                Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(Arrays.asList(files));
                boolean succeed = compiler.getTask(null, fileManager, null, options, null, compilationUnits).call();
                fileManager.close();
                if (!succeed) throw new Exception();
                Console.Info("Compiling complete!");
                MainPanel.setProgress("Compiling Complete", 0);
                MainPanel.setIndeterminate(false);
            } else {
                Console.Warning("No Source code found!");
                MainPanel.setProgress("Compiling Failed!", 0);
            }
            MainPanel.setIndeterminate(false);
        }
        catch (Exception e) {
            Console.Warning("Fast Compiling failed");
            McpScripts.Recompile(mm);
        }
        MainPanel.setProgress("", 0);
        MainPanel.setIndeterminate(false);
    }

    private static File[] listFiles(File root) {
        File[] files = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".java");
            }
        });
        for (File f : root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            File[] subFiles = Export.listFiles(f);
            File[] temp = files;
            files = new File[subFiles.length + temp.length];
            System.arraycopy(temp, 0, files, 0, temp.length);
            System.arraycopy(subFiles, 0, files, temp.length, subFiles.length);
        }
        return files;
    }

    public static void Install(ModManager manager) throws Exception {
        File file = Export.ExportToInstaller(manager);
        Console.Info("Run Installer: " + file.getPath());
        Desktop.getDesktop().open(file);
    }

    public static class ExportException
    extends Exception {
        private Plugin plugin;

        public ExportException(Plugin plugin) {
            this.plugin = plugin;
        }

        public ExportException(String message, Plugin plugin) {
            super(message);
            this.plugin = plugin;
        }

        public ExportException(String message, Throwable cause, Plugin plugin) {
            super(message, cause);
            this.plugin = plugin;
        }

        public ExportException(Throwable cause, Plugin plugin) {
            super(cause);
            this.plugin = plugin;
        }

        public Plugin getPlugin() {
            return this.plugin;
        }
    }

    public static interface ExportTextureHint {
        public void onExportTextureHint(Mod var1, File var2) throws IOException;
    }

    public static abstract class ExportHint {
        public final ArrayList<String> imports;
        private final Plugin plugin;

        public ExportHint(ArrayList<String> imports, Plugin plugin) {
            this.imports = imports;
            this.plugin = plugin;
        }

        public abstract void onExporting(BufferedWriter var1, Mod var2, File var3) throws IOException;

        public Plugin getPlugin() {
            return this.plugin;
        }
    }
}

