/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import net.modmaker.Console.Console;
import net.modmaker.IO.SaveManager;

public class CodeTextArea
extends JPanel {
    private ArrayList<JTextArea> textAreas = new ArrayList();
    private JTextArea rowNumbers = new JTextArea();
    private StyledDocument doc;
    private Thread coloringText;
    private String[] blue = new String[]{"public", "static", "void", "class", "private", "public", "true", "false", "import", "int", "boolean", "float", "long", "short", "byte", "interface", "enum", "for", "while", "break", "continue", "if", "else", "null", "return", "new", "this", "super", "extends", "implements", "try", "catch", "final", "throw", "throws", "char", "do", "package"};

    public CodeTextArea() {
        this.setLayout(new BoxLayout(this, 1));
        this.rowNumbers.setFont(new Font("Monospaced", 0, 13));
        this.rowNumbers.setEditable(false);
        this.rowNumbers.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.rowNumbers.setBackground(Color.DARK_GRAY);
        this.rowNumbers.setForeground(Color.white);
        this.rowNumbers.setEnabled(false);
        this.coloringText = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        for (JTextArea editor : CodeTextArea.this.textAreas) {
                            CodeTextArea.this.readDoc(editor);
                        }
                    }
                    catch (Exception e) {
                        Console.Err(e);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        });
        this.coloringText.setName("Coloring Text");
    }

    public void addText(String text, boolean editable) throws IOException {
        if (text == null) {
            text = "";
        }
        JTextArea ta = new JTextArea();
        ta.setText(text);
        ta.setTabSize(4);
        ta.setEditable(editable);
        Font font = new Font("Monospaced", 0, 13);
        ta.setFont(font);
        if (editable) {
            ta.setBackground(Color.white);
        } else {
            ta.setBackground(Color.lightGray);
        }
        ta.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CodeTextArea.this.init();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CodeTextArea.this.init();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CodeTextArea.this.init();
            }
        });
        this.add(ta);
        this.textAreas.add(ta);
        this.init();
    }

    public void addText(String text, boolean editable, int index) throws IOException {
        if (text == null) {
            text = "";
        }
        JTextArea ta = new JTextArea();
        ta.setEditable(editable);
        ta.setText(text);
        Font font = new Font("Monospaced", 0, 13);
        ta.setFont(font);
        ta.setTabSize(4);
        if (editable) {
            ta.setBackground(Color.white);
        } else {
            ta.setBackground(Color.lightGray);
        }
        ta.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CodeTextArea.this.init();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CodeTextArea.this.init();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CodeTextArea.this.init();
            }
        });
        this.add(ta);
        this.textAreas.add(index, ta);
        this.init();
    }

    public void removeText(int index) {
        this.textAreas.remove(index);
        this.init();
    }

    public void removeText(String text) {
        for (JTextArea ta : this.textAreas) {
            if (!ta.getText().equals(text)) continue;
            this.textAreas.remove(ta);
        }
        this.init();
    }

    public void clear() {
        this.textAreas.clear();
        this.removeAll();
        this.init();
    }

    public ArrayList<JTextArea> getTextAreas() {
        return this.textAreas;
    }

    public JTextArea getRowNumbers() {
        return this.rowNumbers;
    }

    public void stopColoringText() {
        if (this.coloringText.isAlive()) {
            this.coloringText.stop();
        }
    }

    public void startColoringText() {
    }

    private void init() {
        int rows = 0;
        for (int a = 0; a < this.textAreas.size(); ++a) {
            JTextArea ta = this.textAreas.get(a);
            ta.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getRows(ta.getText()) * 18));
            ta.setMaximumSize(ta.getPreferredSize());
            rows += this.getRows(ta.getText());
        }
        this.setPreferredSize(new Dimension(2000, rows * 18));
        this.setMaximumSize(this.getPreferredSize());
        this.updateRowNumbers(rows);
    }

    private void updateRowNumbers(int rows) {
        String text = "   1";
        for (int a = 2; a <= rows; ++a) {
            text = text + "\n" + this.space(a) + a;
        }
        this.rowNumbers.setText(text);
    }

    private String space(int a) {
        String spaces = "    ";
        spaces = spaces.substring(0, 4 - String.valueOf(a).length());
        return spaces;
    }

    private int getRows(String text) {
        if (text == null) {
            return 2;
        }
        if (text.equals("")) {
            return 2;
        }
        if (!text.contains("\n")) {
            return 2;
        }
        int rows = CodeTextArea.countOccurrences(text);
        return rows + 1;
    }

    private static int countOccurrences(String s) {
        int counter = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\n') continue;
            ++counter;
        }
        return counter;
    }

    public static void readJavaFile(CodeTextArea codeArea, File file, boolean partEditable) throws IOException {
        String line;
        codeArea.clear();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        ArrayList<String> texts = new ArrayList<String>();
        String text = null;
        boolean enabled = false;
        while ((line = reader.readLine()) != null) {
            if (partEditable) {
                if (!enabled) {
                    if (SaveManager.removeSpaces(line).startsWith("//Start")) {
                        text = text == null ? line : text + "\n" + line;
                        texts.add(text);
                        text = null;
                        enabled = true;
                        continue;
                    }
                    if (text == null) {
                        text = line;
                        continue;
                    }
                    text = text + "\n" + line;
                    continue;
                }
                if (SaveManager.removeSpaces(line).startsWith("//End")) {
                    texts.add(text);
                    text = line;
                    enabled = false;
                    continue;
                }
                if (text == null) {
                    text = line;
                    continue;
                }
                text = text + "\n" + line;
                continue;
            }
            if (text == null) {
                text = line;
                continue;
            }
            text = text + "\n" + line;
        }
        texts.add(text);
        boolean e = !partEditable;
        for (String str : texts) {
            codeArea.addText(str, e);
            e = !e;
        }
    }

    public ArrayList<String> getText() {
        ArrayList<String> text = new ArrayList<String>();
        for (JTextArea area : this.textAreas) {
            if (!area.isEditable()) continue;
            text.add(area.getText());
        }
        return text;
    }

    private void readDoc(JTextArea editor) {
        HTMLDocument doc = (HTMLDocument)editor.getDocument();
        String word = "";
        for (int a = 0; a < doc.getLength(); ++a) {
            try {
                String c = doc.getText(a, a + 1);
                if (c.equals(" ") || c.equals("<") || c.equals(">")) {
                    if (!word.equals("")) {
                        for (String line : this.blue) {
                            if (!line.equals(word)) continue;
                            SimpleAttributeSet atts = new SimpleAttributeSet();
                            StyleConstants.setForeground(atts, Color.blue);
                            doc.setCharacterAttributes(a - word.length() - 1, word.length(), atts, false);
                            try {
                                Console.Info("Blue: " + doc.getText(a - word.length() - 1, word.length()));
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    word = "";
                    continue;
                }
                word = word + c;
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
    }
}

