/*
 * Decompiled with CFR 0.152.
 */
package net.modmaker.Gui;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.modmaker.Console.Console;
import net.modmaker.Console.LineInfo;
import net.modmaker.Gui.CustomPaintPanel2;
import net.modmaker.Gui.Dialogs.OptionPane;
import net.modmaker.IO.Settings;
import net.modmaker.Utils.Textures;
import net.modmaker.events.ConsoleUpdateEvent;
import net.modmaker.events.Listeners.ConsoleUpdateListener;
import net.modmaker.events.Priority;

public class ConsolePanel
extends JPanel
implements ClipboardOwner {
    public ArrayList<LineInfo> lineInfos;
    private CustomPaintPanel2 customPaintPanel21;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextPane jTextPane1;
    private final StyledDocument doc;
    private final Style info;
    private final Style warning;
    private final Style error;
    private final Style scripts;
    private final Style msg;
    private final Style no;
    private static boolean errorHasTrowen = false;

    public ConsolePanel() {
        block3: {
            this("Console");
            Console.addConsoleUpdateListener(new ConsoleUpdateListener(Priority.NORMAL){

                @Override
                public void onConsoleUpdate(ConsoleUpdateEvent event) {
                    for (LineInfo line : event.getLineInfo()) {
                        ConsolePanel.this.addText(line);
                    }
                }
            });
            try {
                this.doc.insertString(this.doc.getLength(), "--------- Start" + this.jLabel1.getText() + " ---------", this.info);
            }
            catch (Throwable e) {
                if (errorHasTrowen) break block3;
                errorHasTrowen = true;
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Something went wrong console:\n\n" + sw.toString());
            }
        }
        for (int i = 0; i < Console.log.size(); ++i) {
            this.addText(Console.log.get(i));
        }
    }

    public ConsolePanel(String title) {
        this.lineInfos = new ArrayList();
        this.initComponents();
        this.doc = this.jTextPane1.getStyledDocument();
        this.info = this.doc.addStyle("Info", null);
        StyleConstants.setForeground(this.info, Color.green);
        this.warning = this.doc.addStyle("Warning", null);
        StyleConstants.setForeground(this.warning, Color.orange);
        this.error = this.doc.addStyle("Error", null);
        StyleConstants.setForeground(this.error, new Color(107, 0, 0));
        this.scripts = this.doc.addStyle("Scripts", null);
        StyleConstants.setForeground(this.scripts, Color.blue);
        this.msg = this.doc.addStyle("Message", null);
        StyleConstants.setForeground(this.msg, Color.BLACK);
        this.no = this.doc.addStyle("Nothing", null);
        StyleConstants.setForeground(this.no, Color.BLACK);
        this.jLabel1.setText(" " + title);
        this.jTextPane1.setSelectionStart(this.jTextPane1.getText().length() - 1);
        this.jTextPane1.setSelectionEnd(this.jTextPane1.getText().length() - 1);
    }

    public void setTitle(String title) {
        this.jLabel1.setText(title);
    }

    public void setText(String text) {
        block2: {
            try {
                this.doc.insertString(this.doc.getLength(), text, this.info);
            }
            catch (Throwable e) {
                if (errorHasTrowen) break block2;
                errorHasTrowen = true;
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Something went wrong console:\n\n" + sw.toString());
            }
        }
    }

    public void addText(LineInfo li) {
        this.lineInfos.add(li);
        String line = "\n" + li.getText();
        try {
            if (line.startsWith("\n[INFO]")) {
                this.doc.insertString(this.doc.getLength(), line, this.info);
            } else if (line.startsWith("\n[WARNING]")) {
                this.doc.insertString(this.doc.getLength(), line, this.warning);
            } else if (line.startsWith("\n[ERROR]")) {
                this.doc.insertString(this.doc.getLength(), line, this.error);
            } else if (line.startsWith("\n[SCRIPTS]")) {
                this.doc.insertString(this.doc.getLength(), line, this.scripts);
            } else if (line.startsWith("\n[MSG]") || line.startsWith("\n[MESSAGE]")) {
                this.doc.insertString(this.doc.getLength(), line, this.msg);
            } else {
                this.doc.insertString(this.doc.getLength(), line, this.no);
            }
        }
        catch (Throwable e) {
            System.err.println("Something went wrong with the console: " + e.getMessage());
        }
        this.jTextPane1.setSelectionStart(this.jTextPane1.getText().length() - 1);
        this.jTextPane1.setSelectionEnd(this.jTextPane1.getText().length() - 1);
        this.jScrollPane1.getVerticalScrollBar().setValue(this.jScrollPane1.getVerticalScrollBar().getMaximum());
    }

    private void initComponents() {
        this.customPaintPanel21 = new CustomPaintPanel2();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jPanel1 = new JPanel();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jLabel1 = new JLabel();
        this.setBackground(new Color(51, 51, 51));
        this.jScrollPane1.setBackground(new Color(51, 51, 51));
        this.jScrollPane1.setBorder(BorderFactory.createBevelBorder(1));
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setBackground(new Color(100, 100, 100));
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.jPanel1.setOpaque(false);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/net/modmaker/res/Copy.png")));
        this.jButton2.setToolTipText("Copy Console");
        this.jButton2.setContentAreaFilled(false);
        this.jButton2.setFocusPainted(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConsolePanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setIcon(new ImageIcon(Textures.smallClear));
        this.jButton3.setToolTipText("Clear Console");
        this.jButton3.setBorderPainted(false);
        this.jButton3.setContentAreaFilled(false);
        this.jButton3.setFocusPainted(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConsolePanel.this.jButton3ActionPerformed(evt);
            }
        });
        this.jLabel1.setForeground(new Color(204, 204, 204));
        this.jLabel1.setText("  Console");
        this.jLabel1.setToolTipText("dubbel click to hide");
        this.jLabel1.setDoubleBuffered(true);
        this.jLabel1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ConsolePanel.this.jLabel1MouseClicked(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1, -1, 803, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2, -2, 25, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, 20, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton2, GroupLayout.Alignment.TRAILING, -2, 20, -2).addComponent(this.jButton3, GroupLayout.Alignment.TRAILING, -2, 20, -2)))));
        GroupLayout customPaintPanel21Layout = new GroupLayout(this.customPaintPanel21);
        this.customPaintPanel21.setLayout(customPaintPanel21Layout);
        customPaintPanel21Layout.setHorizontalGroup(customPaintPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 873, Short.MAX_VALUE).addGroup(customPaintPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 787, Short.MAX_VALUE)));
        customPaintPanel21Layout.setVerticalGroup(customPaintPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 343, Short.MAX_VALUE).addGroup(customPaintPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customPaintPanel21Layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 291, Short.MAX_VALUE))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.customPaintPanel21, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.customPaintPanel21, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        block3: {
            int ret = OptionPane.showConfirmDialog(Settings.getFrame(), "Are you sure you want to clear the console?", "Clear Console", 0, 3);
            if (ret == 0) {
                Console.log = new ArrayList();
                this.jTextPane1.setText("");
                try {
                    this.doc.insertString(this.doc.getLength(), "--------- Start" + this.jLabel1.getText() + " ---------", this.info);
                }
                catch (Throwable e) {
                    if (errorHasTrowen) break block3;
                    errorHasTrowen = true;
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Something went wrong console:\n\n" + sw.toString());
                }
            }
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        try {
            if (!this.lineInfos.isEmpty()) {
                String copy = Console.log.get(0).toString();
                for (int a = 1; a < this.lineInfos.size(); ++a) {
                    copy = copy + "\n" + this.lineInfos.get(a);
                }
                this.setClipboardContents(copy);
                OptionPane.showMessageDialog(Settings.getFrame(), "Console Copyed", "Copyed", 1);
            }
        }
        catch (Exception e) {
            Console.Err(e);
        }
    }

    private void jLabel1MouseClicked(MouseEvent evt) {
        try {
            if (evt.getClickCount() == 2 && this.getParent() instanceof JSplitPane) {
                JSplitPane sp = (JSplitPane)this.getParent();
                if (sp.getDividerLocation() >= sp.getHeight() - 27) {
                    sp.setDividerLocation(sp.getLastDividerLocation());
                } else {
                    sp.setDividerLocation(sp.getHeight() - 27);
                }
            }
        }
        catch (Throwable e) {
            Console.Err(e);
        }
    }

    public void setClipboardContents(String aString) {
        StringSelection stringSelection = new StringSelection(aString);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

